/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="explosion", aliases={"explode"}, description="Causes an explosion at the target location")
public class ExplosionMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float yield;
    protected boolean blockdamage;
    protected boolean fire;

    public ExplosionMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.yield = (float)mlc.getDouble(new String[]{"yield", "y"}, 0.01337);
        this.blockdamage = mlc.getBoolean(new String[]{"blockdamage", "bd"}, false);
        this.fire = mlc.getBoolean(new String[]{"fire", "ft", "f"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        target.getLocation().getWorld().createExplosion(target.getLocation(), this.yield, this.fire, this.blockdamage);
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        target.getWorld().createExplosion(target, this.yield, this.fire, this.blockdamage);
        return true;
    }
}

