/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.Location;
import org.bukkit.boss.DragonBattle;

@MythicMechanic(author="Ashijin", name="enderDragonSetRespawnPhase", aliases={"setEnderDragonRespawnPhase"}, description="Sets the game phase on an EnderDragon")
public class EnderDragonSetRespawnPhaseMechanic
extends SkillMechanic
implements ITargetedLocationSkill {
    private DragonBattle.RespawnPhase phase = DragonBattle.RespawnPhase.NONE;

    public EnderDragonSetRespawnPhaseMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        String strPhase = mlc.getString(new String[]{"phase", "p"}, "NONE", new String[0]).toUpperCase();
        try {
            this.phase = DragonBattle.RespawnPhase.valueOf((String)strPhase);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid phase supplied");
            this.phase = DragonBattle.RespawnPhase.NONE;
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        location.getWorld().getEnderDragonBattle().setRespawnPhase(this.phase);
        return true;
    }
}

