/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.drops.LootBag;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="dropitem", aliases={"drop", "dropitems", "itemdrop"}, description="Drops an item or droptable")
public class DropItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private String itemString;
    private List<String> items = new ArrayList<String>();
    private DropTable dropTable;

    public DropItemMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.itemString = mlc.getString(new String[]{"items", "item", "i"});
        Optional<DropTable> maybeTable = DropItemMechanic.getPlugin().getDropManager().getDropTable(this.itemString);
        if (maybeTable.isPresent()) {
            this.dropTable = maybeTable.get();
            return;
        }
        if (this.itemString.startsWith("\"")) {
            try {
                this.itemString = this.itemString.substring(1, this.itemString.length() - 1);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
            }
            this.itemString = SkillString.parseMessageSpecialChars(this.itemString);
        }
        for (String s2 : this.itemString.split(",")) {
            this.items.add(s2);
        }
        this.dropTable = new DropTable("DropItemMechanic", "DropItemMechanic", this.items);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        LootBag loot = this.dropTable.generate(new DropMetadata(data.getCaster(), data.getCaster().getEntity()));
        loot.drop(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        LootBag loot = this.dropTable.generate(new DropMetadata(data.getCaster(), data.getCaster().getEntity()));
        loot.drop(target);
        return true;
    }
}

