/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillAudience;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.Collection;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="disguiseTarget", description="Disguises the target entity")
public class DisguiseTargetMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected SkillAudience audience;
    protected PlaceholderString disguise;

    public DisguiseTargetMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.audience = mlc.getAudience("audience", null);
        this.disguise = mlc.getPlaceholderString(new String[]{"type", "disguise", "d"}, "player Xikage", new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (CompatibilityManager.LibsDisguises != null) {
            String dstring = this.disguise.get(data, target);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Disguising {0} as {1}", target.getName(), dstring);
            Disguise d = CompatibilityManager.LibsDisguises.getDisguise(dstring);
            Entity entity = target.getBukkitEntity();
            if (this.audience == null) {
                DisguiseAPI.disguiseEntity((Entity)entity, (Disguise)d);
            } else {
                Collection<AbstractEntity> audience = this.audience.get(data, data.getCaster().getEntity());
                ArrayList<Player> pa = Lists.newArrayList();
                for (AbstractEntity ae : audience) {
                    if (!ae.isPlayer()) continue;
                    pa.add((Player)ae.getBukkitEntity());
                }
                DisguiseAPI.disguiseToPlayers((Entity)entity, (Disguise)d, pa);
            }
            return true;
        }
        return false;
    }
}

