/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillAudience;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.Collection;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="disguise", description="Disguises the target entity")
public class DisguiseAsBlockMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected SkillAudience audience;
    protected PlaceholderString disguise;

    public DisguiseAsBlockMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.audience = mlc.getAudience("audience", null);
        this.disguise = mlc.getPlaceholderString(new String[]{"type", "disguise", "d"}, "player Ashijin", new String[0]);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (CompatibilityManager.LibsDisguises != null) {
            Disguise d = CompatibilityManager.LibsDisguises.getParsedDisguise(this.disguise.get(data));
            Entity entity = data.getCaster().getEntity().getBukkitEntity();
            if (this.audience == null) {
                DisguiseAPI.disguiseEntity((Entity)entity, (Disguise)d);
            } else {
                Collection<AbstractEntity> audience = this.audience.get(data, data.getCaster().getEntity());
                ArrayList<Player> pa = Lists.newArrayList();
                for (AbstractEntity ae : audience) {
                    if (!ae.isPlayer()) continue;
                    pa.add((Player)ae.getBukkitEntity());
                }
                DisguiseAPI.disguiseToPlayers((Entity)entity, (Disguise)d, pa);
            }
            return true;
        }
        return false;
    }
}

