/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileMaterial;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

@MythicMechanic(author="Ashijin", name="decapitate", aliases={"dropHead"}, description="Drops the target entity's head")
public class DecapitateMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public DecapitateMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return true;
        }
        ItemStack skull = new ItemStack(VolatileMaterial.PLAYER_HEAD, 1, 3);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setOwner(target.asPlayer().getName());
        skull.setItemMeta((ItemMeta)meta);
        Location location = BukkitAdapter.adapt(target.getLocation());
        location.getWorld().dropItem(location, skull);
        return true;
    }
}

