/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.damage.DamagingMechanic;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="damage", aliases={"d"}, description="Deals damage to the target")
public class DamageMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble amount;

    public DamageMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = PlaceholderDouble.of(mlc.getString(new String[]{"amount", "a"}, "1", new String[0]));
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || data.getCaster().isUsingDamageSkill() || target.isLiving() && target.getHealth() <= 0.0) {
            return false;
        }
        double damage = this.amount.get(data, target) * (double)data.getPower();
        this.doDamage(data.getCaster(), target, damage);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ DamageMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
        return true;
    }
}

