/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CustomMechanic
extends SkillMechanic {
    protected final String skillName;
    protected final MythicLineConfig config;
    protected SkillMechanic mechanic = null;
    protected boolean loaded = false;

    public CustomMechanic(String skill, String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.skillName = skill;
        this.config = mlc;
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loading CustomMechanic with name " + skill, new Object[0]);
        Schedulers.sync().runLater(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Attempting to Register CustomMechanic: " + skill, new Object[0]);
            MythicMechanicLoadEvent event = new MythicMechanicLoadEvent(this, skill, this.config);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.getMechanic().isPresent()) {
                this.mechanic = event.getMechanic().get();
                this.threadSafetyLevel = this.mechanic.getThreadSafetyLevel();
                this.loaded = true;
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loaded Custom Mechanic {0}", this.skillName);
            } else {
                MythicLogger.errorMechanicConfig(this, mlc, "Failed to load custom mechanic " + this.skillName);
            }
        }, 1L);
    }

    public Optional<SkillMechanic> getMechanic() {
        return Optional.ofNullable(this.mechanic);
    }
}

