/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ChainMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.MissileMechanic;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

@MythicMechanic(author="Ashijin", name="chainmissile", aliases={"cmi"}, description="Shoots a chaining homing missile at the target")
public class ChainMissileMechanic
extends MissileMechanic
implements ITargetedEntitySkill {
    @MythicField(name="bounces", aliases={"b"}, defValue="2", version="4.12", description="How many times the chain should bounce")
    protected PlaceholderInt bounces;
    @MythicField(name="radius", aliases={"r"}, defValue="5", version="4.12", description="How far the skill will bounce to a new target")
    protected PlaceholderDouble bounceRadius;
    @MythicField(name="returnToCaster", aliases={"return", "rtc"}, defValue="false", version="4.12", description="If the missile should return to the caster")
    protected boolean returnToCaster;
    protected ChainMechanic.BounceSelector bounceSelector;
    protected String bounceConditionString;
    @MythicField(name="bounceConditions", aliases={"conditions", "cond", "c"}, defValue="NONE", version="4.8", description="Conditions applied to the bounce target")
    protected List<SkillCondition> bounceConditions = null;

    public ChainMissileMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        if (!MythicMobs.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "ChainMissile mechanic requires Mythic Premium");
            return;
        }
        this.bounces = mlc.getPlaceholderInteger(new String[]{"bounces", "b"}, 2, new String[0]);
        this.bounceRadius = mlc.getPlaceholderDouble(new String[]{"bounceradius", "bouncerange", "radius", "range", "r"}, 5.0, new String[0]);
        this.returnToCaster = mlc.getBoolean(new String[]{"returntocaster", "return", "rtc"}, false);
        if (this.returnToCaster) {
            this.hitSelf = true;
        }
        this.bounceConditionString = mlc.getString(new String[]{"bounceconditions", "conditions", "cond", "c"}, "null", new String[0]);
        ChainMissileMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (this.bounceConditionString != null) {
                this.bounceConditions = ChainMissileMechanic.getPlugin().getSkillManager().getConditions(this.bounceConditionString);
            }
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!MythicMobs.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "ChainMissile mechanic requires Mythic Premium");
            return false;
        }
        try {
            new ChainMissileTracker(data, target).start();
            return true;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return false;
        }
    }

    public class ChainMissileTracker
    extends MissileMechanic.MissileTracker {
        AbstractEntity currentBounce;
        UUID currentBounceUUID;
        AbstractLocation currentOrigin;
        protected final double bounceRadius;
        protected final double bounceRadiusSq;
        protected int bouncesRemaining;
        protected float power;
        protected boolean finalBounce;
        protected HashSet<AbstractEntity> alreadyHit;

        public ChainMissileTracker(SkillMetadata data, AbstractEntity target) {
            super(data, target);
            this.finalBounce = false;
            this.alreadyHit = new HashSet();
            this.currentBounce = data.getCaster().getEntity();
            this.currentBounceUUID = this.currentBounce.getUniqueId();
            this.currentOrigin = data.getCaster().getLocation();
            this.bouncesRemaining = ChainMissileMechanic.this.bounces.get(data);
            this.bounceRadius = ChainMissileMechanic.this.bounceRadius.get(data);
            this.bounceRadiusSq = Math.pow(this.bounceRadius, 2.0);
            this.evaluatePotentialTargets();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ ChainMissile fired by Entity {0}: skill = {1}", data.getCaster().getEntity().getName(), ChainMissileMechanic.this.line);
        }

        @Override
        public AbstractLocation getTarget() {
            if (this.target != null) {
                if (this.target.isDead() || !this.target.isValid()) {
                    this.doBounce(this.target);
                }
                return this.target.getLocation();
            }
            return this.targetLocation.clone();
        }

        @Override
        public void doHit(HashSet<AbstractEntity> targets) {
            if (!ChainMissileMechanic.this.onHitSkill.isPresent()) {
                return;
            }
            this.data = this.data.deepClone();
            this.data.setEntityTargets(targets);
            this.data.setOrigin(this.currentLocation.clone());
            AbstractEntity hit = null;
            Iterator<AbstractEntity> iterator = targets.iterator();
            if (iterator.hasNext()) {
                AbstractEntity t;
                hit = t = iterator.next();
            }
            if (hit == null) {
                return;
            }
            this.alreadyHit.add(hit);
            if (((Skill)ChainMissileMechanic.this.onHitSkill.get()).isUsable(this.data)) {
                VariableRegistry vars = this.data.getVariables();
                vars.putInt("chain-bounces", this.bouncesRemaining);
                ((Skill)ChainMissileMechanic.this.onHitSkill.get()).execute(this.data);
            }
            if (hit.equals(this.target)) {
                if (this.finalBounce) {
                    this.terminate();
                } else {
                    this.doBounce(hit);
                }
            }
        }

        private void doBounce(AbstractEntity hit) {
            this.currentBounce = hit;
            this.currentBounceUUID = hit.getUniqueId();
            --this.bouncesRemaining;
            if (this.bouncesRemaining == 0) {
                if (ChainMissileMechanic.this.returnToCaster && !this.target.equals(this.data.getCaster().getEntity())) {
                    this.target = this.data.getCaster().getEntity();
                    this.finalBounce = true;
                } else {
                    this.terminate();
                }
            } else if (this.bouncesRemaining < 0) {
                this.terminate();
            } else {
                this.target = this.getNextTarget();
            }
        }

        private void evaluatePotentialTargets() {
            double maxDistance = Math.pow(this.bounceRadius * (double)this.bouncesRemaining * 2.0, 2.0);
            if (ChainMissileMechanic.this.hitSelf || ChainMissileMechanic.this.hitPlayers || ChainMissileMechanic.this.hitNonPlayers) {
                this.inRange.addAll(AbstractSkill.getPlugin().getEntityManager().getLivingEntities(this.data.getCaster().getLocation().getWorld()));
                this.inRange.removeIf(e -> {
                    if (e == null) {
                        return true;
                    }
                    if (this.bullet != null && this.bullet.equals(e)) {
                        return true;
                    }
                    if (this.currentOrigin.distanceSquared(e.getLocation()) > maxDistance && !e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!e.isLiving() || e.isCitizensNPC()) {
                        return true;
                    }
                    if (!ChainMissileMechanic.this.hitSelf && e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!ChainMissileMechanic.this.hitPlayers && e.isPlayer()) {
                        return true;
                    }
                    return !ChainMissileMechanic.this.hitNonPlayers && !e.isPlayer();
                });
                if (ChainMissileMechanic.this.returnToCaster) {
                    this.inRange.add(this.data.getCaster().getEntity());
                }
            }
        }

        private AbstractEntity getNextTarget() {
            if (this.currentBounce == null) {
                return null;
            }
            AbstractEntity target = null;
            double range = 0.0;
            for (AbstractEntity entity : this.inRange) {
                AbstractLocation origin;
                double nextRange;
                if (entity == null || entity.isDead() || !entity.isValid() || this.alreadyHit.contains(entity) || ChainMissileMechanic.this.returnToCaster && entity.equals(this.data.getCaster().getEntity()) || (nextRange = (origin = this.currentBounce != null ? this.currentBounce.getLocation() : this.currentOrigin).distanceSquared(entity.getLocation())) > this.bounceRadiusSq) continue;
                if (ChainMissileMechanic.this.bounceConditions != null) {
                    boolean ok = true;
                    for (SkillCondition condition : ChainMissileMechanic.this.bounceConditions) {
                        if (condition.evaluateToEntity(this.currentBounce, entity)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                }
                if (target == null) {
                    target = entity;
                    range = this.currentBounce.getLocation().distanceSquared(entity.getLocation());
                    continue;
                }
                if (!(nextRange < range)) continue;
                target = entity;
                range = nextRange;
            }
            if (target == null) {
                if (ChainMissileMechanic.this.returnToCaster) {
                    target = this.data.getCaster().getEntity();
                    this.finalBounce = true;
                } else {
                    this.terminate();
                    return null;
                }
            }
            return target;
        }

        public AbstractEntity getCurrentBounce() {
            return this.currentBounce;
        }

        public UUID getCurrentBounceUUID() {
            return this.currentBounceUUID;
        }

        public AbstractLocation getCurrentOrigin() {
            return this.currentOrigin;
        }

        public double getBounceRadius() {
            return this.bounceRadius;
        }

        public double getBounceRadiusSq() {
            return this.bounceRadiusSq;
        }

        public int getBouncesRemaining() {
            return this.bouncesRemaining;
        }

        public float getPower() {
            return this.power;
        }
    }
}

