/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="breakBlock", aliases={"blockBreak"}, description="Breaks the block at the target location")
public class BreakBlockMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private boolean doDrops;
    private boolean doEffect;
    private boolean useTool;

    public BreakBlockMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.doDrops = mlc.getBoolean(new String[]{"dodrops", "drops", "d"}, true);
        this.doEffect = mlc.getBoolean(new String[]{"doeffect", "effect", "e"}, true);
        this.useTool = mlc.getBoolean(new String[]{"usetool", "tool", "t"}, true);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data, target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data, target);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playEffect(SkillMetadata data, AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        if (data.getCaster().isUsingDamageSkill()) {
            return;
        }
        data.getCaster().setUsingDamageSkill(true);
        try {
            if (data.getCaster().getEntity().isPlayer()) {
                BlockBreakEvent event = new BlockBreakEvent(l.getBlock(), (Player)data.getCaster().getEntity().getBukkitEntity());
                Events.call((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            if (this.doDrops) {
                if (this.useTool) {
                    ItemStack tool = data.getCaster().getEntity().isPlayer() ? ((Player)data.getCaster().getEntity().getBukkitEntity()).getInventory().getItemInMainHand() : new ItemStack(Material.AIR);
                    l.getBlock().breakNaturally(tool);
                } else {
                    l.getBlock().breakNaturally();
                }
            } else {
                l.getBlock().setType(Material.AIR);
            }
        }
        finally {
            data.getCaster().setUsingDamageSkill(false);
        }
    }
}

