/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", version="4.11", name="bossBorder", aliases={"effect:bossBorder", "e:bossBorder"}, description="Draws a world border to create a boss arena")
public class BossBorderEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="radius", aliases={"r"}, version="4.11", description="Radius of the border")
    private int radius;

    public BossBorderEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 32);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        BossBorderEffect.getPlugin().getVolatileCodeHandler().getEntityHandler().setPlayerWorldBorder(target.asPlayer(), ((ActiveMob)data.getCaster()).getSpawnLocation(), this.radius);
        return true;
    }
}

