/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.LegacyItemConverter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="blockMask", aliases={"effect:blockMask", "e:blockMask"}, description="Temporarily masks a block as a different block")
public class BlockMaskEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private Material mat = Material.GRAVEL;
    private byte data;
    private int radius;
    private int duration;
    private double randomness;
    private boolean sphere;
    private MaskType maskType;
    private int radiusSq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockMaskEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        String strMaterial = mlc.getString(new String[]{"material", "mat", "m"}, "GRAVEL", new String[0]).toUpperCase();
        try {
            this.mat = this.data == 0 ? Material.valueOf((String)strMaterial) : LegacyItemConverter.getMaterial(strMaterial, this.data);
        }
        catch (Exception ex) {
            this.mat = LegacyItemConverter.getMaterial(strMaterial, this.data);
        }
        finally {
            if (this.mat == null) {
                MythicLogger.errorMechanicConfig(this, mlc, "Material '" + strMaterial + "' not found or invalid.");
            }
        }
        this.data = (byte)mlc.getInteger(new String[]{"materialdata", "md", "data", "dv"}, 0);
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 0);
        this.randomness = mlc.getDouble(new String[]{"noise", "n"}, 0.0);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 0);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        boolean noAir = mlc.getBoolean(new String[]{"noair", "na"}, true);
        boolean onlyAir = mlc.getBoolean(new String[]{"onlyair", "oa"}, false);
        this.maskType = noAir && !onlyAir ? MaskType.IGNORE_AIR : (onlyAir ? MaskType.ONLY_AIR : MaskType.ALL);
        if (this.radius < 0) {
            this.radius = 0;
        }
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        if (this.radius == 0) {
            for (Player p : l.getWorld().getPlayers()) {
                if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                    p.sendBlockChange(l, this.mat.createBlockData());
                    continue;
                }
                p.sendBlockChange(l, this.mat, this.data);
            }
        } else {
            for (Location ll : this.getBlocksInRadius(l, true)) {
                for (Player p : l.getWorld().getPlayers()) {
                    if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                        p.sendBlockChange(ll, this.mat.createBlockData());
                        continue;
                    }
                    p.sendBlockChange(ll, this.mat, this.data);
                }
            }
        }
        if (this.duration > 0) {
            Schedulers.sync().runLater(() -> {
                Location lll = BukkitAdapter.adapt(location);
                if (this.radius == 0) {
                    for (Player p : lll.getWorld().getPlayers()) {
                        if (!(p.getLocation().distanceSquared(lll) < 65536.0)) continue;
                        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                            p.sendBlockChange(lll, lll.getBlock().getBlockData());
                            continue;
                        }
                        p.sendBlockChange(lll, lll.getBlock().getType(), lll.getBlock().getData());
                    }
                } else {
                    for (Location ll : this.getBlocksInRadius(lll, false)) {
                        for (Player p : lll.getWorld().getPlayers()) {
                            if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                                p.sendBlockChange(ll, ll.getBlock().getBlockData());
                                continue;
                            }
                            p.sendBlockChange(ll, ll.getBlock().getType(), ll.getBlock().getData());
                        }
                    }
                }
            }, this.duration);
        }
    }

    private List<Location> getBlocksInRadius(Location l, boolean randomize) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int y = -this.radius; y <= this.radius; ++y) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    Location newloc = new Location(l.getWorld(), l.getX() + (double)x, l.getY() + (double)y, l.getZ() + (double)z);
                    if (this.sphere && l.distanceSquared(newloc) > (double)this.radiusSq || randomize && this.randomness > 0.0 && this.randomness < Numbers.randomDouble()) continue;
                    if (this.maskType == MaskType.ALL) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType == MaskType.IGNORE_AIR && newloc.getBlock().getType().isOccluding()) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType != MaskType.ONLY_AIR || newloc.getBlock().getType().isOccluding()) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }

    private static enum MaskType {
        ALL,
        IGNORE_AIR,
        ONLY_AIR;

    }
}

