/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractBossBar;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="barCreate", aliases={"barAdd", "createBar"}, version="4.8", description="Creates a custom bossbar display")
public class BarCreateMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected String barName;
    protected PlaceholderString barDisplay;
    protected AbstractBossBar.BarColor barTimerColor;
    protected AbstractBossBar.BarStyle barTimerStyle;
    protected PlaceholderDouble value;

    public BarCreateMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.barName = mlc.getString(new String[]{"name", "n"}, "infobar", new String[0]);
        this.barDisplay = mlc.getPlaceholderString(new String[]{"display", "d", "bartimerdisplay", "bartimertext"}, "<skill.var.aura-name>", new String[0]);
        this.value = mlc.getPlaceholderDouble(new String[]{"value", "v"}, 1.0, new String[0]);
        String barTimerColor = mlc.getString(new String[]{"color", "c", "bartimercolor"}, "RED", new String[0]);
        String barTimerStyle = mlc.getString(new String[]{"style", "s", "bartimerstyle"}, "SOLID", new String[0]);
        try {
            this.barTimerColor = AbstractBossBar.BarColor.valueOf(barTimerColor);
        }
        catch (Exception ex) {
            this.barTimerColor = AbstractBossBar.BarColor.RED;
        }
        try {
            this.barTimerStyle = AbstractBossBar.BarStyle.valueOf(barTimerStyle);
        }
        catch (Exception ex) {
            this.barTimerStyle = AbstractBossBar.BarStyle.SOLID;
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        AbstractBossBar bar = BarCreateMechanic.getPlugin().server().createBossBar(this.barDisplay.get(data), this.barTimerColor, this.barTimerStyle);
        bar.setProgress(this.value.get(data));
        am.addBar(this.barName, bar);
        return true;
    }
}

