/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="arrowvolley", description="Shoots a volley of arrows")
public class ArrowVolleyMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderInt amount;
    protected int spread;
    protected int fireTicks;
    protected int removeDelay;
    protected float velocity;

    public ArrowVolleyMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "arrows", "a"}, 20, new String[0]);
        this.spread = mlc.getInteger(new String[]{"spread", "s"}, 45);
        this.fireTicks = mlc.getInteger(new String[]{"fireticks", "ft", "f"}, 0);
        this.velocity = mlc.getFloat(new String[]{"velocity", "v"}, 20.0f);
        this.removeDelay = mlc.getInteger(new String[]{"removedelay", "rd", "r"}, 200);
        this.velocity /= 10.0f;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        SkillAdapter.get().executeVolley(data.getCaster(), target, this.amount.get(data), this.velocity, this.spread, this.fireTicks, this.removeDelay);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        SkillAdapter.get().executeVolley(data.getCaster(), target.getLocation(), this.amount.get(data, target), this.velocity, this.spread, this.fireTicks, this.removeDelay);
        return true;
    }
}

