/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.damage;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.damage.DamageMetadata;

public abstract class DamagingMechanic
extends SkillMechanic {
    protected static boolean noloop = false;
    protected boolean ignoresArmor;
    protected boolean preventImmunity;
    protected boolean preventKnockback;
    protected String element;

    public DamagingMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.ignoresArmor = mlc.getBoolean(new String[]{"ignorearmor", "ia", "i"}, false);
        this.preventImmunity = mlc.getBoolean(new String[]{"preventimmunity", "pi"}, false);
        this.preventKnockback = mlc.getBoolean(new String[]{"preventknockback", "pkb", "pk"}, false);
        this.element = mlc.getString(new String[]{"element", "e", "damagetype", "type"}, null, new String[0]);
        if (this.element != null && !MythicMobs.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, mlc, "Custom damage types require MythicMobs Premium to use.");
            this.element = null;
        }
    }

    protected void doDamage(SkillCaster caster, AbstractEntity target, double amount) {
        DamageMetadata meta = new DamageMetadata(caster, amount, this.element, this.ignoresArmor, this.preventImmunity, this.preventKnockback);
        SkillAdapter.get().doDamage(meta, target);
    }
}

