/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationComparisonCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="ydiff", aliases={}, description="Whether the y-difference between the caster and target is within the given range")
public class YDiffCondition
extends SkillCondition
implements IEntityComparisonCondition,
ILocationComparisonCondition {
    @MythicField(name="difference", aliases={"diff", "d"}, description="The difference to match")
    protected RangedDouble diff;

    public YDiffCondition(String line, MythicLineConfig mlc) {
        super(line);
        String d = mlc.getString(new String[]{"difference", "diff", "d"}, this.conditionVar, new String[0]);
        this.diff = new RangedDouble(d);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        double tY = target.getLocation().getY();
        double cY = entity.getLocation().getY();
        return this.diff.equals(tY - cY);
    }

    @Override
    public boolean check(AbstractLocation location, AbstractLocation target) {
        double tY = target.getY();
        double cY = location.getY();
        return this.diff.equals(tY - cY);
    }
}

