/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;

@MythicCondition(author="Ashijin", name="stringEquals", aliases={"stringEq"}, version="4.6", description="Checks if value1 equals value2. Both values can use variables and placeholders.")
public class StringEqualsCondition
extends SkillCondition
implements IEntityCondition,
ILocationCondition,
ISkillMetaCondition {
    @MythicField(name="value1", aliases={"val1", "v1"}, description="")
    private PlaceholderString value1;
    @MythicField(name="value2", aliases={"val2", "v2"}, description="")
    private PlaceholderString value2;

    public StringEqualsCondition(String line, MythicLineConfig mlc) {
        super(line);
        try {
            this.value1 = PlaceholderString.of(mlc.getString(new String[]{"value1", "val1", "v1", "string", "s"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable name must be set.");
            return;
        }
        try {
            this.value2 = PlaceholderString.of(mlc.getString(new String[]{"value2", "val2", "v2", "value", "val", "v", "equals", "eq", "e"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable name must be set.");
            return;
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        String compare1 = this.value1.get(target);
        String compare2 = this.value2.get(target);
        return compare1.equals(compare2);
    }

    @Override
    public boolean check(AbstractLocation target) {
        String compare1 = this.value1.get();
        String compare2 = this.value2.get();
        return compare1.equals(compare2);
    }

    @Override
    public boolean check(SkillMetadata meta) {
        String compare1 = this.value1.get(meta, meta.getCaster().getEntity());
        String compare2 = this.value2.get(meta, meta.getCaster().getEntity());
        return compare1.equals(compare2);
    }
}

