/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedInt;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Slime;

@MythicCondition(author="Ashijin", name="size", aliases={"mobSize"}, description="Checks against the entity's size")
public class SizeCondition
extends SkillCondition
implements IEntityCondition {
    private RangedInt range;

    public SizeCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.range = new RangedInt(mlc.getString(new String[]{"size", "s"}, this.conditionVar, new String[0]));
    }

    @Override
    public boolean check(AbstractEntity entity) {
        int size;
        if (!entity.isLiving()) {
            return false;
        }
        LivingEntity le = (LivingEntity)entity.getBukkitEntity();
        if (le instanceof Slime) {
            size = ((Slime)le).getSize();
        } else if (le instanceof MagmaCube) {
            size = ((MagmaCube)le).getSize();
        } else if (le instanceof Phantom) {
            size = ((Phantom)le).getSize();
        } else {
            return false;
        }
        return this.range.equals(size);
    }
}

