/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedInt;

@MythicCondition(author="Ashijin", name="playerInRadius", aliases={"pir"}, description="Checks for a given number of players within a radius of the target")
public class PlayersInRadiusCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="amount", aliases={"a"}, description="The number of players to check for")
    private RangedInt amount;
    @MythicField(name="radius", aliases={"range", "r"}, description="The radius to check in")
    private PlaceholderDouble distance;

    public PlayersInRadiusCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.amount = new RangedInt(mlc.getString(new String[]{"amount", "a"}, ">0", this.conditionVar));
        this.distance = mlc.getPlaceholderDouble(new String[]{"radius", "r", "distance", "d"}, "32", new String[0]);
    }

    @Override
    public boolean check(AbstractLocation location) {
        double range = this.distance.get();
        return this.amount.equals(PlayersInRadiusCondition.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(location, range, e -> e.isPlayer()).size());
    }
}

