/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;

@MythicCondition(author="Ashijin", name="playerNotWithin", aliases={"playersnotwithin"}, description="Checks if any players are within a radius of the target")
public class PlayerNotWithinCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="distance", aliases={"d"}, description="The radius to check in")
    private double distance;

    public PlayerNotWithinCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.distance = Math.pow(Double.valueOf(mlc.getString(new String[]{"distance", "d"}, "0", this.conditionVar)), 2.0);
    }

    @Override
    public boolean check(AbstractLocation location) {
        for (AbstractPlayer p : location.getWorld().getPlayers()) {
            if (!p.getWorld().equals(location.getWorld()) || !(location.distanceSquared(p.getLocation()) <= this.distance)) continue;
            return false;
        }
        return true;
    }
}

