/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.players.PlayerManager;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import org.bukkit.Location;

@MythicCondition(author="Ashijin", name="moving", aliases={"ismoving"}, description="If the target has a velocity greater than zero")
public class MovingCondition
extends SkillCondition
implements IEntityCondition {
    private boolean exact;

    public MovingCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.exact = mlc.getBoolean(new String[]{"exact", "e"}, true);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        boolean isMoving;
        if (entity.isPlayer()) {
            PlayerManager.PlayerMovementData data = MovingCondition.getPlugin().getPlayerManager().getPlayerPositions().get(entity.getUniqueId());
            if (data == null || System.currentTimeMillis() - data.getLastMovementTime() > 50L) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Player hasn't moved recently", new Object[0]);
                return false;
            }
            Location t = data.getTo();
            Location f = data.getFrom();
            isMoving = f.getX() != t.getX() || f.getY() != t.getY() || f.getZ() != t.getZ();
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Player Movement {0},{1},{2} == {3},{4},{5}", f.getX(), f.getY(), f.getZ(), t.getX(), t.getY(), t.getZ());
        } else {
            isMoving = MovingCondition.getPlugin().getVolatileCodeHandler().getEntityHandler().isEntityInMotion(entity, this.exact);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Is Entity Moving? {0}", String.valueOf(isMoving));
        return isMoving;
    }
}

