/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedInt;

@MythicCondition(author="Ashijin", name="livinginradius", aliases={}, description="Matches a range to how many living entities are in the given radius")
public class LivingInRadiusCondition
extends SkillCondition
implements ISkillMetaCondition {
    @MythicField(name="amount", aliases={"a"}, description="The number range to match")
    private RangedInt amount;
    @MythicField(name="radius", aliases={"r"}, description="The radius to check")
    private PlaceholderDouble radius;

    public LivingInRadiusCondition(String line, MythicLineConfig mlc) {
        super(line);
        String k = mlc.getString(new String[]{"amount", "a"}, "1", this.conditionVar);
        this.amount = new RangedInt(k);
        this.radius = mlc.getPlaceholderDouble(new String[]{"radius", "r"}, "5", this.conditionVar);
    }

    @Override
    public boolean check(SkillMetadata meta) {
        SkillCaster caster = meta.getCaster();
        AbstractLocation l = caster.getEntity().getLocation();
        double radiusSq = Math.pow(this.radius.get(meta), 2.0);
        int count = 0;
        for (AbstractEntity entity : LivingInRadiusCondition.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(l, radiusSq)) {
            if (!(l.distanceSquared(entity.getLocation()) <= radiusSq)) continue;
            ++count;
        }
        return this.amount.equals(count);
    }
}

