/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedInt;

@MythicCondition(author="Ashijin", name="lightLevelfromblocks", aliases={"blocklightlevel"}, description="Tests the light level at the target location")
public class LightLevelBlockCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="level", aliases={"l"}, description="The level range to match")
    private RangedInt level;

    public LightLevelBlockCondition(String line, MythicLineConfig mlc) {
        super(line);
        String k = mlc.getString(new String[]{"level", "l"}, "0", this.conditionVar);
        this.level = new RangedInt(k);
    }

    @Override
    public boolean check(AbstractLocation l) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking LightLevel: {0} vs {1}", l.getWorld().getLightLevelFromBlocks(l), this.level.toString());
        byte level = l.getWorld().getLightLevelFromBlocks(l);
        return this.level.equals(level);
    }
}

