/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Ashijin", name="holding", aliases={}, description="Checks if the target is holding a given material")
public class HoldingCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="material", aliases={"m"}, description="The material type to match")
    private BukkitItemStack comparison;

    public HoldingCondition(String line, MythicLineConfig mlc) {
        super(line);
        String materialString = mlc.getString(new String[]{"material", "m", "type", "t"}, "DIRT", this.conditionVar);
        try {
            this.comparison = new BukkitItemStack(materialString);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorConditionConfig(this, mlc, "'" + materialString + "' is not a valid material.");
        }
    }

    @Override
    public boolean check(AbstractEntity e) {
        EntityEquipment entityEquipment;
        if (e.isLiving() && (entityEquipment = ((LivingEntity)e.getBukkitEntity()).getEquipment()) != null) {
            ItemStack holding = entityEquipment.getItemInMainHand();
            return this.comparison.isSimilar(holding);
        }
        return false;
    }
}

