/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="health", aliases={"hp"}, description="Matches the target's health")
public class HealthCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="amount", aliases={"a"}, description="The health range to check for")
    private RangedDouble amount;

    public HealthCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.amount = new RangedDouble(mlc.getString(new String[]{"amount", "a", "health", "h"}, "0", this.conditionVar));
    }

    @Override
    public boolean check(AbstractEntity entity) {
        double health = entity.getHealth();
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking Health: {0} vs {1}", health, this.amount.toString());
        return this.amount.equals(health);
    }
}

