/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;

@MythicCondition(author="Ashijin", name="hasCurrency", aliases={"hasmoney"}, description="If the target has the given amount of vault currency")
public class HasCurrencyCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="amount", aliases={"a"}, description="The amount of currency")
    protected double amount;

    public HasCurrencyCondition(String line, MythicLineConfig mlc) {
        super(line);
        String amount = mlc.getString(new String[]{"amount", "a"}, String.valueOf(Double.MAX_VALUE), this.conditionVar);
        this.amount = Double.valueOf(amount);
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        if (MythicMobs.inst().getCompatibility().getVault().isPresent()) {
            return MythicMobs.inst().getCompatibility().getVault().get().hasMoney(target.asPlayer(), this.amount);
        }
        return false;
    }
}

