/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.TraderLlama;
import org.bukkit.material.Colorable;

@MythicCondition(author="Phil", name="color", aliases={"clr"}, description="Checks for entity's color")
public class ColorCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="color", aliases={"clr", "c"}, description="The color to check")
    private PlaceholderString color;

    public ColorCondition(String line, MythicLineConfig config) {
        super(line);
        this.color = config.getPlaceholderString(new String[]{"clr", "color", "c"}, null, this.conditionVar);
    }

    @Override
    public boolean check(AbstractEntity e) {
        Entity target = e.getBukkitEntity();
        switch (target.getType()) {
            case SHEEP: 
            case SHULKER: {
                return this.color.toString().equalsIgnoreCase(String.valueOf(((Colorable)target).getColor()));
            }
            case HORSE: {
                return this.color.toString().equalsIgnoreCase(String.valueOf(((Horse)target).getColor()));
            }
            case LLAMA: {
                return this.color.toString().equalsIgnoreCase(String.valueOf(((Llama)target).getColor()));
            }
            case TRADER_LLAMA: {
                return this.color.toString().equalsIgnoreCase(String.valueOf(((TraderLlama)target).getColor()));
            }
            case PARROT: {
                return this.color.toString().equalsIgnoreCase(String.valueOf(((Parrot)target).getVariant()));
            }
            case CAT: {
                return this.color.toString().equalsIgnoreCase(String.valueOf(((Cat)target).getCatType()));
            }
        }
        return false;
    }
}

