/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import java.util.HashSet;
import java.util.Set;

@MythicCondition(author="Ashijin", name="biome", aliases={}, description="Tests if the target is within the given list of biomes")
public class BiomeCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="biome", aliases={"b"}, description="A list of biomes to check")
    private Set<String> biome = new HashSet<String>();

    public BiomeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String b = mlc.getString(new String[]{"biome", "b"}, "PLAINS", this.conditionVar);
        for (String s2 : b.split(",")) {
            this.biome.add(s2.toUpperCase());
        }
    }

    @Override
    public boolean check(AbstractLocation l) {
        String b = l.getBiome().toString();
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "BiomeCondition checking {0} contains {1}", this.biome.toString(), b);
        return this.biome.contains(b);
    }
}

