/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Collection;
import java.util.function.Consumer;

public class TriggeredSkill
implements IParentSkill {
    private SkillMetadata data;
    private boolean sync = false;
    private boolean cancel = false;

    public TriggeredSkill(SkillTrigger cause, ActiveMob am, AbstractEntity trigger) {
        this(cause, am, trigger, false, null);
    }

    public TriggeredSkill(SkillTrigger cause, ActiveMob am, AbstractEntity trigger, boolean sync) {
        this(cause, am, trigger, sync, null);
    }

    public TriggeredSkill(SkillTrigger cause, ActiveMob am, AbstractEntity trigger, boolean sync, Consumer<SkillMetadata> transformer) {
        this.data = new SkillMetadata(cause, am, trigger);
        this.data.setCallingEvent(this);
        if (sync) {
            this.data.setIsAsync(false);
        } else {
            this.data.setIsAsync(true);
        }
        if (this.data.getTrigger() != null) {
            if (am instanceof ActiveMob) {
                am.setLastAggroCause(this.data.getTrigger());
            }
            this.data.setEntityTarget(trigger);
        }
        this.data.setPower(am.getPower());
        if (transformer != null) {
            transformer.accept(this.data);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.TRIGGER, "Skill Trigger {0} fired for ActiveMob {1} (uuid: {2})", new Object[]{cause, am.getDisplayName(), am.getUniqueId()});
        am.getType().executeSkills(this.data.getCause(), this.data);
    }

    public TriggeredSkill(SkillTrigger cause, SkillCaster am, AbstractLocation origin, AbstractEntity trigger, Collection<SkillMechanic> mechanics, boolean sync) {
        this(cause, am, origin, trigger, mechanics, sync, null);
    }

    public TriggeredSkill(SkillTrigger cause, SkillCaster am, AbstractLocation origin, AbstractEntity trigger, Collection<SkillMechanic> mechanics, boolean sync, Consumer<SkillMetadata> transformer) {
        this.data = new SkillMetadata(cause, am, trigger);
        this.data.setCallingEvent(this);
        if (sync) {
            this.data.setIsAsync(false);
        } else {
            this.data.setIsAsync(true);
        }
        if (origin != null) {
            this.data.setOrigin(origin);
        }
        if (this.data.getTrigger() != null) {
            this.data.setEntityTarget(trigger);
        }
        this.data.setPower(am.getPower());
        if (transformer != null) {
            transformer.accept(this.data);
        }
        if (this.data.getIsAsync()) {
            for (SkillMechanic ms : mechanics) {
                if (ms.getRunAsync() || !ms.isUsableFromCaster(this.data)) continue;
                ms.execute(this.data.deepClone().setIsAsync(false));
            }
            Schedulers.async().run(() -> {
                for (SkillMechanic ms : mechanics) {
                    if (!ms.getRunAsync() || !ms.isUsableFromCaster(this.data)) continue;
                    ms.execute(this.data);
                }
            });
        } else {
            for (SkillMechanic ms : mechanics) {
                if (!ms.isUsableFromCaster(this.data)) continue;
                ms.execute(this.data);
            }
        }
    }

    @Override
    public void setCancelled() {
        this.cancel = true;
    }

    @Override
    public boolean getCancelled() {
        return this.cancel;
    }

    public SkillMetadata getData() {
        return this.data;
    }
}

