/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.mechanics.CastMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.CustomMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SudoSkillMechanic;
import io.lumine.xikage.mythicmobs.skills.targeters.IPathSelector;
import io.lumine.xikage.mythicmobs.skills.targeters.MPEntity;
import io.lumine.xikage.mythicmobs.skills.targeters.MPLocation;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.tasks.Task;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.Bukkit;

public class SkillMechanic
extends AbstractSkill {
    protected final MythicLineConfig config;
    protected int interval = 0;
    protected long clock = 0L;
    protected String line;
    protected boolean forceSync = false;
    protected boolean executeAfterDeath = false;
    protected boolean targetIsOrigin = false;
    protected Optional<SkillTargeter> originOverride;

    public SkillMechanic(String skill, MythicLineConfig mlc, int interval) {
        this.config = mlc;
        this.interval = interval + (ConfigManager.ClockInterval - interval % ConfigManager.ClockInterval);
        this.init(skill, mlc);
    }

    public SkillMechanic(String skill, MythicLineConfig mlc) {
        this.config = mlc;
        this.init(skill, mlc);
    }

    public void init(String skill, MythicLineConfig mlc) {
        this.line = skill;
        this.cooldown = (float)mlc.getDouble(new String[]{"cooldown", "cd"}, 0.0);
        this.delay = mlc.getPlaceholderInteger("delay", 0);
        this.repeat = mlc.getPlaceholderInteger("repeat", 0);
        this.repeatInterval = mlc.getPlaceholderInteger(new String[]{"repeatinterval", "repeati"}, 0, new String[0]);
        this.power = mlc.getFloat("power", 1.0f);
        this.powerSplitBetweenTargets = mlc.getBoolean(new String[]{"powersplitbetweentargets", "powersplit", "splitpower"}, false);
        this.forceSync = mlc.getBoolean(new String[]{"forcesync", "sync"}, false);
        this.targetIsOrigin = mlc.getBoolean("targetisorigin", false);
        this.sourceIsOrigin = mlc.getBoolean(new String[]{"sourceisorigin", "castfromorigin", "fromorigin", "fo"}, false);
        String originOverride = mlc.getString("origin", null);
        this.originOverride = originOverride != null && MythicMobs.isVolatile() ? Optional.of(this.parseSkillTargeter(originOverride)) : Optional.empty();
        this.target_creative = mlc.getBoolean("targetcreative", this.target_creative);
        String[] split = skill.split(" ");
        for (int i = 1; i < split.length; ++i) {
            SkillCondition cond;
            if (split[i].startsWith("@")) {
                this.targeter = Optional.of(this.parseSkillTargeter(split[i]));
                continue;
            }
            if (split[i].startsWith("~")) {
                this.trigger = this.parseSkillTrigger(split[i]);
                continue;
            }
            if (split[i].startsWith("=") || split[i].startsWith(">") || split[i].startsWith("<")) {
                this.healthMod = split[i];
                continue;
            }
            if (split[i].startsWith("?~")) {
                if (this.conditionsTrigger == null) {
                    this.conditionsTrigger = new ArrayList();
                }
                cond = this.parseSkillCondition(split[i].substring(1));
                this.conditionsTrigger.add(cond);
                continue;
            }
            if (split[i].startsWith("?")) {
                if (this.conditions == null) {
                    this.conditions = new ArrayList();
                }
                cond = this.parseSkillCondition(split[i]);
                this.conditions.add(cond);
                continue;
            }
            if (!split[i].matches("[0-9]*[.]?[0-9]+")) continue;
            this.chance = Float.parseFloat(split[i]);
        }
        if (this.trigger == null) {
            this.trigger = SkillTrigger.COMBAT;
        }
    }

    public String getConfigLine() {
        return this.line;
    }

    public void setAsyncSafe(boolean bool) {
        this.threadSafetyLevel = bool ? AbstractSkill.ThreadSafetyLevel.EITHER : AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
    }

    public boolean isAsyncSafe() {
        return this.threadSafetyLevel != AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
    }

    public void setTimerInterval(int interval) {
        this.interval = interval;
    }

    public int getTimerInterval() {
        return this.interval;
    }

    public void resetClock() {
        this.clock = 0L;
    }

    public void tickClock() {
        this.clock += (long)ConfigManager.ClockInterval;
    }

    public long getClock() {
        return this.clock;
    }

    public boolean isUsableFromSkill(SkillMetadata meta) {
        SkillCaster skillCaster = meta.getCaster();
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateTrigger(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: TriggerConditions failed", new Object[0]);
                return false;
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateCaster(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Conditions failed", new Object[0]);
                return false;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    public boolean isUsableFromCaster(SkillMetadata meta) {
        SkillCaster skillCaster = meta.getCaster();
        if (!this.checkSkillTrigger(meta)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: SkillTrigger check failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateTrigger(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: TriggerConditions failed", new Object[0]);
                return false;
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateCaster(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Conditions failed", new Object[0]);
                return false;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    @Deprecated
    public boolean usable(SkillMetadata meta) {
        return this.isUsableFromCaster(meta);
    }

    @Deprecated
    public boolean usable(SkillCaster skillCaster, SkillTrigger trigger) {
        if (!this.checkSkillTrigger(trigger)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: SkillTrigger check failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    @Deprecated
    public boolean usable(SkillCaster am) {
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(am)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (am instanceof ActiveMob && !this.checkHealth(am)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    public boolean execute(SkillMetadata oData) {
        final SkillMetadata data = oData.deepClone();
        if (this.originOverride.isPresent()) {
            data.setOrigin(this.evaluateNewOrigin(this.originOverride.get(), oData));
        }
        final int delay = this.delay.get(oData);
        final int repeat = this.repeat.get(oData);
        final int repeatInterval = this.repeatInterval.get(oData);
        if (repeat > 0 && repeatInterval > 0) {
            final SkillMechanic skill = this;
            new Runnable(){
                private int ticks = 0;
                private int repeats = repeat;
                private Task task = Schedulers.sync().runRepeating(this, (long)delay, (long)repeatInterval);

                @Override
                public void run() {
                    ++this.ticks;
                    try {
                        skill.executeSkills(data.deepClone());
                        if (this.ticks > this.repeats) {
                            this.task.terminate();
                        }
                    }
                    catch (Error | Exception ex) {
                        ex.printStackTrace();
                        this.task.terminate();
                    }
                }
            };
            return true;
        }
        if (delay == 0) {
            return this.executeSkills(data);
        }
        SkillMechanic skill = this;
        Schedulers.sync().runLater(() -> skill.executeSkills(data), delay);
        return true;
    }

    public boolean executeSkills(SkillTrigger skilltrigger, ActiveMob am, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadata data = new SkillMetadata(skilltrigger, am, trigger, origin, eTargets, lTargets, power);
        return this.executeSkills(data);
    }

    public boolean executeSkills(SkillMetadata data) {
        SkillMechanic mechanic;
        if (!data.getExecuteAfterDeath().booleanValue()) {
            ActiveMob am;
            if (this.executeAfterDeath) {
                data.setExecuteAfterDeath(true);
            } else if (data.getCaster() instanceof ActiveMob && (am = (ActiveMob)data.getCaster()).isDead()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Caster is dead, cancelling execution (line: {0})", this.line);
                return false;
            }
        }
        if (data.getOrigin() == null) {
            data.setOrigin(data.getCaster().getEntity().getLocation());
        }
        data.setPower(data.getPower() * this.power);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Executing SkillMechanic with power {0} (line: {1})", Float.valueOf(data.getPower()), this.line);
        if (this instanceof SudoSkillMechanic) {
            ((SudoSkillMechanic)this).cast(data);
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        this.evaluateTargets(data);
        if (this instanceof CustomMechanic && ((CustomMechanic)this).getMechanic().isPresent()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is a CUSTOM mechanic", new Object[0]);
            mechanic = ((CustomMechanic)this).getMechanic().get();
        } else {
            mechanic = this;
        }
        if (mechanic instanceof IMetaSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is a META mechanic. Executing...", new Object[0]);
            ((IMetaSkill)((Object)mechanic)).cast(data);
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        if (mechanic instanceof ITargetedEntitySkill && mechanic instanceof ITargetedLocationSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic accepts multiple types...", new Object[0]);
            if (this.targeter.isPresent() && this.targeter.get() instanceof IPathSelector) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Targeter is PATH SELECTOR", new Object[0]);
                if (this.targeter.get() instanceof MPEntity) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic set as ENTITY skill. Executing...", new Object[0]);
                    SkillMechanic.executeTargetedEntitySkill(mechanic, data);
                    this.setCooldown(data.getCaster(), this.cooldown);
                    return true;
                }
                if (this.targeter.get() instanceof MPLocation) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic set as LOCATION skill. Executing...", new Object[0]);
                    SkillMechanic.executeTargetedLocationSkill(mechanic, data);
                    this.setCooldown(data.getCaster(), this.cooldown);
                    return true;
                }
            }
        }
        if (mechanic instanceof ITargetedEntitySkill && data.getEntityTargets() != null && !data.getEntityTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is an ENTITY skill. Executing...", new Object[0]);
            this.runMechanic(data, () -> SkillMechanic.executeTargetedEntitySkill(mechanic, data));
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        if (mechanic instanceof ITargetedLocationSkill) {
            if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Executing SkillMechanic as LOCATION skill", new Object[0]);
                this.runMechanic(data, () -> SkillMechanic.executeTargetedLocationSkill(mechanic, data));
                this.setCooldown(data.getCaster(), this.cooldown);
                return true;
            }
            if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Executing SkillMechanic as ENTITY_LOCATION skill", new Object[0]);
                this.runMechanic(data, () -> SkillMechanic.executeTargetedLocationSkill(mechanic, data));
                this.setCooldown(data.getCaster(), this.cooldown);
                return true;
            }
        }
        if (mechanic instanceof INoTargetSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic runnable with no targets. Executing...", new Object[0]);
            this.runMechanic(data, () -> SkillMechanic.executeNoTargetSkill(mechanic, data));
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        if (mechanic instanceof CastMechanic) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "- SkillMechanic is a CAST mechanic. Executing NoTargets fallback.", new Object[0]);
            ((CastMechanic)mechanic).failNoTargets(data);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "! No targets available. Cancelling.", new Object[0]);
        return false;
    }

    private void runMechanic(SkillMetadata data, Runnable run) {
        if ((data.getIsAsync() || !Bukkit.isPrimaryThread()) && this.threadSafetyLevel == AbstractSkill.ThreadSafetyLevel.SYNC_ONLY) {
            Schedulers.sync().run(run);
        } else if ((!data.getIsAsync() || Bukkit.isPrimaryThread()) && this.threadSafetyLevel == AbstractSkill.ThreadSafetyLevel.ASYNC_ONLY) {
            Schedulers.async().run(run);
        } else {
            run.run();
        }
    }

    protected static void executeTargetedEntitySkill(SkillMechanic mechanic, SkillMetadata data) {
        data.getEntityTargets().forEach(target -> {
            if (mechanic.targetIsOrigin) {
                ((ITargetedEntitySkill)((Object)mechanic)).castAtEntity(data.deepClone().setOrigin(target.getLocation()), (AbstractEntity)target);
            } else {
                ((ITargetedEntitySkill)((Object)mechanic)).castAtEntity(data, (AbstractEntity)target);
            }
        });
    }

    protected static void executeTargetedLocationSkill(SkillMechanic mechanic, SkillMetadata data) {
        if (data.getLocationTargets() != null) {
            data.getLocationTargets().forEach(target -> {
                if (mechanic.targetIsOrigin) {
                    ((ITargetedLocationSkill)((Object)mechanic)).castAtLocation(data.deepClone().setOrigin((AbstractLocation)target), (AbstractLocation)target);
                } else {
                    ((ITargetedLocationSkill)((Object)mechanic)).castAtLocation(data, (AbstractLocation)target);
                }
            });
        } else if (data.getEntityTargets() != null) {
            data.getEntityTargets().forEach(entity -> {
                AbstractLocation target = entity.getLocation();
                if (mechanic.targetIsOrigin) {
                    ((ITargetedLocationSkill)((Object)mechanic)).castAtLocation(data.deepClone().setOrigin(target), target);
                } else {
                    ((ITargetedLocationSkill)((Object)mechanic)).castAtLocation(data, target);
                }
            });
        }
    }

    protected static void executeNoTargetSkill(SkillMechanic mechanic, SkillMetadata data) {
        ((INoTargetSkill)((Object)mechanic)).cast(data);
    }

    public boolean getRunAsync() {
        return !this.forceSync;
    }
}

