/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.ai.goals;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ai.Pathfinder;
import io.lumine.xikage.mythicmobs.mobs.ai.PathfindingGoal;
import io.lumine.xikage.mythicmobs.util.annotations.MythicAIGoal;

@MythicAIGoal(name="goToLocation", aliases={"goto"}, version="4.8", description="Go to a location")
public class GoToLocationGoal
extends Pathfinder
implements PathfindingGoal {
    private double x;
    private double y;
    private double z;
    private float speed;
    private AbstractLocation destination;
    private float distanceSq = 4.0f;

    public GoToLocationGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.goalType = Pathfinder.GoalType.MOVE;
        try {
            if (this.dataVar1 != null) {
                String[] sp = this.dataVar1.split(",");
                this.x = Integer.valueOf(sp[0]).intValue();
                this.y = Integer.valueOf(sp[1]).intValue();
                this.z = Integer.valueOf(sp[2]).intValue();
            }
            float speed = 1.0f;
            if (this.dataVar2 != null) {
                speed = Float.valueOf(this.dataVar2).floatValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.destination = new AbstractLocation(entity.getWorld(), this.x, this.y, this.z);
    }

    @Override
    public boolean shouldStart() {
        return this.entity.getLocation().distanceSquared(this.destination) > (double)this.distanceSq;
    }

    @Override
    public void start() {
        GoToLocationGoal.ai().navigateToLocation(this.entity, this.destination, this.speed);
    }

    @Override
    public void tick() {
        GoToLocationGoal.ai().navigateToLocation(this.entity, this.destination, this.speed);
    }

    @Override
    public boolean shouldEnd() {
        return this.entity.getLocation().distanceSquared(this.destination) <= (double)this.distanceSq;
    }

    @Override
    public void end() {
    }
}

