/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.SerializingComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.constants.MobKeys;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.CasterRegistry;
import io.lumine.xikage.mythicmobs.mobs.MobRegistry;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMobStack;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntityType;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.logging.ConsoleColor;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.serialization.WrappedJsonFile;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class MobManager
extends SerializingComponent
implements CasterRegistry {
    private static final String FOLDER_MOBS = "Mobs";
    private Map<String, MythicMob> mmList = Maps.newConcurrentMap();
    private Map<String, MythicMob> mmDisplayLookup = Maps.newConcurrentMap();
    private List<MythicMobStack> listMobStacks = Lists.newArrayList();
    private Map<MythicEntityType, MythicMob> mmDefaultList = Maps.newConcurrentMap();
    private WrappedJsonFile<MobRegistry> mobRegistry;
    private transient Map<UUID, ActiveMob> activeMobsInCombat = Maps.newConcurrentMap();
    private transient Cache<UUID, Boolean> mmVoidList = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build(new CacheLoader<UUID, Boolean>(){

        @Override
        public Boolean load(UUID uuid) {
            return true;
        }
    });
    public static boolean spawnflag = false;
    public static boolean mountflag = false;

    public MobManager(MythicMobs core) {
        super(core);
    }

    @Override
    public void load(MythicMobs plugin) {
        MythicLogger.log("Loading Mob Registry...");
        try {
            this.mobRegistry = this.loadFile(this.getModuleFile("active-mobs.json"), MobRegistry.class);
            Schedulers.sync().runLater(() -> {
                if (this.mobRegistry.get() == null) {
                    this.regenerateMobRegistry();
                }
                this.mobRegistry.get().loadSaved();
            }, 1L);
        }
        catch (Exception ex) {
            this.regenerateMobRegistry();
        }
    }

    @Override
    public void unload() {
        this.mobRegistry.get().terminate();
        this.mobRegistry.save();
    }

    public void regenerateMobRegistry() {
        try {
            MythicLogger.error((Object)((Object)ConsoleColor.RED) + "----------------------------------------");
            MythicLogger.error((Object)((Object)ConsoleColor.YELLOW) + "Failed to load active-mobs.json: file may have been corrupted during a server crash or improper shutdown.");
            MythicLogger.error((Object)((Object)ConsoleColor.YELLOW) + "This file has been regenerated and a backup has been saved of the old one.");
            MythicLogger.error((Object)((Object)ConsoleColor.RED) + "----------------------------------------");
            File file = this.getModuleFile("active-mobs.json");
            if (file.exists()) {
                int i = 1;
                File copyFile = this.getModuleFile("active-mobs.corrupt" + i + ".json");
                while (copyFile.exists()) {
                    copyFile = this.getModuleFile("active-mobs.corrupt" + ++i + ".json");
                }
                file.renameTo(copyFile);
            }
            this.mobRegistry = new WrappedJsonFile<MobRegistry>(this, this.getModuleFile("active-mobs.json"), (MobRegistry)MobRegistry.class.newInstance());
        }
        catch (Error | Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public void loadMobs() {
        IOLoader<MythicMobs> defaultMobs = new IOLoader<MythicMobs>(MythicMobs.inst(), "VanillaMobs.yml", FOLDER_MOBS);
        defaultMobs = new IOLoader<MythicMobs>(MythicMobs.inst(), "ExampleMobs.yml", FOLDER_MOBS);
        List<File> mobFiles = IOHandler.getAllFiles(defaultMobs.getFile().getParent());
        File packsFolder = new File(((MythicMobs)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + FOLDER_MOBS)).exists() || !confFolder.isDirectory()) continue;
                mobFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        List<IOLoader<MythicMobs>> mobLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), mobFiles, FOLDER_MOBS);
        this.mmList.clear();
        this.mmDefaultList.clear();
        this.mmDisplayLookup.clear();
        for (IOLoader<MythicMobs> sl : mobLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                try {
                    MythicMob mm3;
                    MythicConfig mc = new MythicConfig(name, sl.getFile(), sl.getCustomConfig());
                    String file = sl.getFile().getPath();
                    if (BukkitEntityType.getMythicEntity(name) != null) {
                        MythicEntityType met = MythicEntityType.get(name);
                        mm3 = new MythicMob(file, name, mc);
                        this.mmDefaultList.put(met, mm3);
                        continue;
                    }
                    if (sl.getCustomConfig().getString(name + ".MobStack") != null) {
                        String stack = sl.getCustomConfig().getString(name + ".MobStack");
                        this.listMobStacks.add(new MythicMobStack(name, stack, file));
                        continue;
                    }
                    String Display = sl.getCustomConfig().getString(name + ".Display");
                    Display = sl.getCustomConfig().getString(name + ".DisplayName", Display);
                    mm3 = new MythicMob(file, name, mc);
                    this.mmList.put(name, mm3);
                    if (Display == null) continue;
                    this.mmDisplayLookup.put(Display, mm3);
                }
                catch (Exception ex) {
                    MythicLogger.error("Error loading mob '" + name + "'. Enable debugging for a stack trace.");
                    if (ConfigManager.debugLevel <= 0) continue;
                    ex.printStackTrace();
                }
            }
        }
    }

    public Collection<MythicMob> getMobTypes() {
        return this.mmList.values();
    }

    public Collection<String> getMobNames() {
        return this.mmList.keySet();
    }

    public Collection<MythicMob> getVanillaTypes() {
        return this.mmDefaultList.values();
    }

    public Optional<MythicMob> getVanillaType(MythicEntityType type) {
        return Optional.ofNullable(this.mmDefaultList.getOrDefault((Object)type, null));
    }

    public Collection<MythicMobStack> getMobStacks() {
        return this.listMobStacks;
    }

    @Override
    public Optional<SkillCaster> getSkillCaster(UUID uuid) {
        return Optional.ofNullable(this.mobRegistry.get().get(uuid));
    }

    public Collection<ActiveMob> getActiveMobs() {
        return this.mobRegistry.get().values();
    }

    public Collection<ActiveMob> getActiveMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    public boolean isActiveMob(AbstractEntity entity) {
        return this.isActiveMob(entity.getUniqueId());
    }

    public boolean isActiveMob(UUID uuid) {
        return this.mobRegistry.get().isActiveMob(uuid);
    }

    public Optional<ActiveMob> getActiveMob(UUID uuid) {
        return this.mobRegistry.get().getActiveMob(uuid);
    }

    public Set<UUID> getVoidList() {
        return this.mmVoidList.asMap().keySet();
    }

    public void setIgnoreEntity(UUID uuid) {
        this.mmVoidList.put(uuid, true);
    }

    public boolean isIgnoredEntity(UUID uuid) {
        return this.mmVoidList.asMap().keySet().contains(uuid);
    }

    public int removeAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.get().values()) {
            if (am.getType() != null && am.getType().isPersistent()) continue;
            am.setDespawned();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int removeAllAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.get().values()) {
            am.setDespawned();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int despawnAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.get().values()) {
            if (!am.getType().optionDespawn || am.getType().isPersistent()) continue;
            am.setDespawnedSync();
            MythicMobs.inst().getMobManager().unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public void setEntityDespawned(UUID uniqueId) {
        this.mobRegistry.get().getActiveMob(uniqueId).ifPresent(mob -> mob.setDespawned());
    }

    public void ScanWorld() {
        Schedulers.async().run(() -> {
            for (AbstractWorld w : ((MythicMobs)this.getPlugin()).server().getWorlds()) {
                for (AbstractEntity e : ((MythicMobs)this.getPlugin()).getEntityManager().getLivingEntities(w)) {
                    if (!this.isActiveMob(e)) {
                        this.registerActiveMob(e);
                        continue;
                    }
                    this.verifyMythicMobInstance(e);
                }
            }
            for (ActiveMob am : this.getActiveMobs()) {
                if (!am.isDead()) continue;
                am.setDespawned();
            }
        });
    }

    public ActiveMob registerActiveMob(ActiveMob am) {
        this.mobRegistry.get().put(am.getUniqueId(), am);
        return am;
    }

    public ActiveMob registerActiveMob(AbstractEntity l, MythicMob mm3, int level) {
        if (this.isActiveMob(l)) {
            return this.getMythicMobInstance(l);
        }
        ActiveMob am = new ActiveMob(l, mm3, level);
        this.mobRegistry.get().put(l.getUniqueId(), am);
        mm3.applyMobVolatileOptions(am);
        new TriggeredSkill(SkillTrigger.SPAWN, am, null);
        return am;
    }

    public ActiveMob registerActiveMob(AbstractEntity l) {
        String mobType;
        if (this.mmVoidList.asMap().containsKey(l.getUniqueId())) {
            return null;
        }
        if (this.isActiveMob(l)) {
            ActiveMob am = this.getMythicMobInstance(l);
            am.loadSaved();
            return am;
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && (mobType = (String)l.getDataContainer().getOrDefault(MobKeys.TYPE, PersistentDataType.STRING, null)) != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading Mob {0} from PersistentData", l.getUniqueId());
            ActiveMob am = new ActiveMob(l);
            this.mobRegistry.get().put(l.getUniqueId(), am);
            am.loadSaved();
            return am;
        }
        this.mmVoidList.put(l.getUniqueId(), true);
        return null;
    }

    public void unregisterActiveMob(UUID u) {
        this.mobRegistry.get().removeMob(u);
        this.activeMobsInCombat.remove(u);
    }

    public void unregisterActiveMob(ActiveMob am) {
        this.unregisterActiveMob(am.getUniqueId());
    }

    public ActiveMob getMythicMobInstance(Entity target) {
        return this.getMythicMobInstance(BukkitAdapter.adapt(target));
    }

    public ActiveMob getMythicMobInstance(AbstractEntity target) {
        ActiveMob am;
        if (this.mobRegistry.get() == null) {
            this.regenerateMobRegistry();
        }
        if ((am = this.mobRegistry.get().get(target.getUniqueId())) != null) {
            this.resetActiveMobEntity(am, target);
            return am;
        }
        return this.registerActiveMob(target);
    }

    public void verifyMythicMobInstance(AbstractEntity e) {
        ActiveMob am = this.mobRegistry.get().get(e.getUniqueId());
        if (am != null) {
            this.resetActiveMobEntity(am, e);
        }
    }

    private void resetActiveMobEntity(ActiveMob am, AbstractEntity e) {
        if (!am.getEntity().isValid() && e.isValid()) {
            am.setEntity(e);
        }
    }

    public ActiveMob spawnMob(String type, Location loc) {
        return this.spawnMob(type, BukkitAdapter.adapt(loc), SpawnReason.OTHER, 1.0);
    }

    public ActiveMob spawnMob(String type, Location loc, double level) {
        return this.spawnMob(type, BukkitAdapter.adapt(loc), SpawnReason.OTHER, level);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc) {
        return this.spawnMob(type, loc, SpawnReason.OTHER, 1.0);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc, double level) {
        return this.spawnMob(type, loc, SpawnReason.OTHER, level);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc, SpawnReason reason, double level) {
        MythicMob mm3 = this.getMythicMob(type);
        if (mm3 != null) {
            return mm3.spawn(loc, level, reason);
        }
        MythicMobStack ms = MythicMobs.inst().getMobManager().getMythicMobStack(type);
        if (ms != null) {
            return ms.spawn(loc, level, reason);
        }
        return null;
    }

    public void SetupMythicMobCompat(LivingEntity l, MythicMob mm3) {
        if (spawnflag) {
            return;
        }
        if (mm3.getMythicEntity() != null) {
            l = (LivingEntity)mm3.getMythicEntity().applyOptions((Entity)l);
        }
        AbstractEntity abstractEntity = BukkitAdapter.adapt((Entity)l);
        MythicMobs.inst().getMobManager();
        ActiveMob am = new ActiveMob(abstractEntity, mm3, MobManager.getMythicMobLevel(mm3, BukkitAdapter.adapt((Entity)l)));
        this.mobRegistry.get().put(l.getUniqueId(), am);
        l = (LivingEntity)mm3.applyMobOptions(am, am.getLevel());
        l = (LivingEntity)mm3.applyMobVolatileOptions(am);
        new TriggeredSkill(SkillTrigger.SPAWN, am, null);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation b, int radiusXZ, int radiusY, int mob_height, boolean Ymod, boolean onSurface) {
        Location base = BukkitAdapter.adapt(b);
        if (radiusXZ <= 0) {
            radiusXZ = 1;
        }
        if (radiusY <= 0) {
            radiusY = 1;
        }
        double x = base.getX() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
        double z = base.getZ() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
        double y = Ymod ? base.getY() - (double)radiusY + (double)Numbers.randomInt(radiusY * 2) : base.getY() + (double)Numbers.randomInt(radiusY);
        Location loc = new Location(base.getWorld(), x, y, z);
        if (loc.getBlock().getType().isSolid()) {
            int j = 10;
            while (loc.getBlock().getType().isSolid()) {
                x = base.getX() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
                z = base.getZ() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
                y = Ymod ? base.getY() - (double)radiusY + (double)Numbers.randomInt(radiusY * 2) : base.getY() + (double)Numbers.randomInt(radiusY);
                loc = new Location(base.getWorld(), x, y, z);
                if (--j != 0) continue;
                loc = new Location(base.getWorld(), base.getX(), base.getY() + 1.0, base.getZ());
                break;
            }
        }
        if (onSurface && !loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
            int highestY = loc.getWorld().getHighestBlockYAt(loc);
            if ((double)highestY <= loc.getY()) {
                loc.setY((double)(highestY + 1));
            } else {
                int j = 10;
                while (!loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                    if (j == 0) {
                        loc = new Location(base.getWorld(), base.getX(), base.getY() + 1.0, base.getZ());
                        break;
                    }
                    loc.setY(loc.getY() - 1.0);
                    --j;
                }
            }
        }
        return BukkitAdapter.adapt(loc);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radiusXZ, int radiusY, int mob_height, boolean yMod) {
        return MobManager.findSafeSpawnLocation(base, radiusXZ, radiusY, mob_height, yMod, false);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radiusXZ, int radiusY, int mob_height) {
        return MobManager.findSafeSpawnLocation(base, radiusXZ, radiusY, mob_height, true, false);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radius, int mob_height) {
        return MobManager.findSafeSpawnLocation(base, radius, radius, mob_height, true, false);
    }

    public Collection<ActiveMob> getMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    public boolean getInCombat(ActiveMob am) {
        return this.activeMobsInCombat.containsKey(am.getUniqueId());
    }

    public void setInCombat(ActiveMob am, boolean b) {
        if (b) {
            this.activeMobsInCombat.put(am.getUniqueId(), am);
        } else {
            this.activeMobsInCombat.remove(am.getUniqueId());
        }
    }

    public void saveCachedActiveMobs() {
        Schedulers.async().run(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Saving all active Mythic Mobs...", new Object[0]);
            this.mobRegistry.save();
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "All active mobs have been saved!", new Object[0]);
        });
    }

    public List<LivingEntity> getAllMythicEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (World w : Bukkit.getWorlds()) {
            for (LivingEntity e : w.getLivingEntities()) {
                if (!this.mobRegistry.get().isActiveMob(e.getUniqueId())) continue;
                list.add(e);
            }
        }
        return list;
    }

    public MythicMob getMythicMob(String s2) {
        if (s2 == null) {
            return null;
        }
        if (this.mmList.containsKey(s2)) {
            return this.mmList.get(s2);
        }
        return null;
    }

    public MythicMobStack getMythicMobStack(String s2) {
        for (MythicMobStack ML : this.listMobStacks) {
            if (!ML.getName().equals(s2)) continue;
            return ML;
        }
        return null;
    }

    public static int getMythicMobLevel(MythicMob mm3, AbstractEntity l) {
        int si;
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobLevel");
        if (o != null && (si = o.getScore(l.getUniqueId().toString()).getScore()) > 0) {
            return si;
        }
        int level = 1;
        if (!(mm3.lvlModHealth > 0.0)) {
            return 1;
        }
        double health = l.getMaxHealth() - mm3.getHealth().get();
        return level += (int)(health / mm3.lvlModHealth);
    }

    public static void setMetaData(AbstractEntity abstractEntity, String s2, String key) {
        BukkitAdapter.adapt(abstractEntity).setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.inst(), (Object)s2));
    }

    public MythicMob determineMobType(AbstractEntity l) {
        List list = l.getBukkitEntity().getMetadata("mobname");
        MythicMob mm3 = null;
        for (MetadataValue mv : list) {
            mm3 = this.mmList.get(mv);
            if (mm3 == null) continue;
            return mm3;
        }
        if (l.getCustomName() == null) {
            return null;
        }
        mm3 = this.mmDisplayLookup.get(l.getCustomName());
        if (mm3 != null) {
            return mm3;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName().toString();
            search = search.replace("[", "\\[");
            search = search.replace("]", "\\]");
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = search.replace("<mob.level>", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            try {
                if (!l.getCustomName().toString().matches(search) || !(MM.getHealth().get() <= l.getMaxHealth())) continue;
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public MythicMob getMythicMobByDisplayCompat(AbstractEntity l) {
        if (l.getCustomName() == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Attempting to match mob for compatibility: " + l.getCustomName().toString(), new Object[0]);
        MythicMob mm3 = this.mmDisplayLookup.get(l.getCustomName());
        if (mm3 != null) {
            return mm3;
        }
        mm3 = this.determineMobType(l);
        if (mm3 != null) {
            return mm3;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName().toString();
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            try {
                String name = ChatColor.translateAlternateColorCodes((char)'&', (String)l.getCustomName().toString());
                if (!name.matches(search)) continue;
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String convertMobTypeAliases(String s2) {
        s2 = s2.toLowerCase();
        s2 = s2.replace("zombievillager", "ZOMBIE_VILLAGER");
        s2 = s2.replace("villagezombie", "ZOMBIE_VILLAGER");
        s2 = s2.replace("babydrowned", "BABY_DROWNED");
        s2 = s2.replace("babyvillagezombie", "BABY_ZOMBIE_VILLAGER");
        s2 = s2.replace("babypigzombie", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babyzombiepig", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babyzombiepigman", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babypigzombievillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombiepigvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombiepigmanvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombie", "BABY_ZOMBIE");
        s2 = s2.replace("cavespider", "CAVE_SPIDER");
        s2 = s2.replace("enderdragon", "ENDER_DRAGON");
        s2 = s2.replace("glowsquid", "GLOW_SQUID");
        s2 = s2.replace("glowingsquid", "GLOW_SQUID");
        s2 = s2.replace("irongolem", "IRON_GOLEM");
        s2 = s2.replace("lavaslime", "MAGMA_CUBE");
        s2 = s2.replace("magmacube", "MAGMA_CUBE");
        s2 = s2.replace("mooshroom", "MUSHROOM_COW");
        s2 = s2.replace("mushroomcow", "MUSHROOM_COW");
        s2 = s2.replace("pigzombie", "PIG_ZOMBIE");
        s2 = s2.replace("zombiepig", "PIG_ZOMBIE");
        s2 = s2.replace("zombiepigman", "PIG_ZOMBIE");
        s2 = s2.replace("zombified_piglin", "PIG_ZOMBIE");
        s2 = s2.replace("pigzombievillager", "PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("zombiepigvillager", "PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("zombiepigmanvillager", "PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("tnt", "PRIMED_TNT");
        s2 = s2.replace("tropicalfish", "TROPICAL_FISH");
        s2 = s2.replace("skeletalhorse", "SKELETON_HORSE");
        s2 = s2.replace("skeletonhorse", "SKELETON_HORSE");
        s2 = s2.replace("zombiehorse", "ZOMBIE_HORSE");
        s2 = s2.replace("witherskeleton", "WITHER_SKELETON");
        return s2;
    }

    public WrappedJsonFile<MobRegistry> getMobRegistry() {
        return this.mobRegistry;
    }
}

