/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractBossBar;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWolf;
import io.lumine.xikage.mythicmobs.constants.MobKeys;
import io.lumine.xikage.mythicmobs.holograms.types.HealthBar;
import io.lumine.xikage.mythicmobs.holograms.types.Nameplate;
import io.lumine.xikage.mythicmobs.holograms.types.SpeechBubble;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.skills.auras.AuraRegistry;
import io.lumine.xikage.mythicmobs.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.serialize.Optl;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.IllegalPluginAccessException;

public class ActiveMob
implements SkillCaster {
    private UUID uuid;
    private String mobType;
    private transient AbstractEntity entity;
    private transient MythicMob type;
    private long aliveTime = 0L;
    private long lastSeen = System.currentTimeMillis();
    private AbstractLocation spawnLocation;
    private VariableRegistry variables = new VariableRegistry();
    private PlaceholderString displayName;
    private double level;
    private int globalCooldown = 0;
    private String stance;
    private String lastSignal = "";
    private int playerKills = 0;
    private Optl<UUID> owner = Optl.empty();
    private String spawnerName = null;
    private Optl<String> faction = Optl.empty();
    public Map<String, Long> cooldowns = Maps.newHashMap();
    private transient SkillCaster parent;
    private transient Collection<AbstractEntity> children = Sets.newConcurrentHashSet();
    private transient Optional<ActiveMob> mount = Optional.empty();
    private transient MythicSpawner spawner = null;
    private transient ThreatTable threatTable;
    private transient ImmunityTable immunityTable;
    private transient Optional<AbstractBossBar> bossBar = Optional.empty();
    private transient Map<String, AbstractBossBar> bossBars = null;
    protected transient HealthBar healthbar = null;
    protected transient Nameplate nameplate = null;
    protected transient SpeechBubble speechBubble = null;
    private transient AbstractEntity newTarget = null;
    private transient double lastDamageSkillAmount = 0.0;
    private transient boolean damageSkillRunning = false;
    private transient boolean dead = false;
    private transient int noDamageTicks;
    protected transient AbstractEntity lastAggroCause;
    private boolean changingTarget = false;

    private static final MythicMobs getPlugin() {
        return MythicMobs.inst();
    }

    public ActiveMob() {
    }

    public ActiveMob(AbstractEntity entity, MythicMob type, double level) {
        this.uuid = entity.getUniqueId();
        this.entity = entity;
        this.type = type;
        this.mobType = type.getInternalName();
        this.spawnLocation = entity.getLocation();
        this.level = level;
        this.faction = Optl.of(type.getFaction());
        this.globalCooldown = 0;
        this.stance = "default";
        this.noDamageTicks = type.getNoDamageTicks();
        Schedulers.sync().runLater(() -> this.setups(), 5L);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
            PersistentDataContainer data = entity.getDataContainer();
            data.set(MobKeys.TYPE, PersistentDataType.STRING, (Object)this.mobType);
            data.set(MobKeys.LEVEL, PersistentDataType.DOUBLE, (Object)this.level);
            if (this.faction.isPresent()) {
                data.set(MobKeys.FACTION, PersistentDataType.STRING, (Object)this.faction.get());
            }
        }
    }

    public ActiveMob(AbstractEntity entity) {
        PersistentDataContainer data = entity.getDataContainer();
        this.uuid = entity.getUniqueId();
        this.mobType = (String)data.getOrDefault(MobKeys.TYPE, PersistentDataType.STRING, null);
        this.level = (Double)data.getOrDefault(MobKeys.LEVEL, PersistentDataType.DOUBLE, (Object)1.0);
        this.faction = Optl.of((String)data.getOrDefault(MobKeys.FACTION, PersistentDataType.STRING, null));
        this.spawnerName = (String)data.getOrDefault(MobKeys.SPAWNER, PersistentDataType.STRING, null);
        if (this.mobType == null) {
            throw new IllegalArgumentException("Supplied entity is not a valid MythicMob");
        }
    }

    public void setups() {
        if (!this.entity.isValid() || this.entity.isDead()) {
            this.unregisterSync();
            return;
        }
        if (this.type.usesBossBar()) {
            this.bossBar = this.type.getBossBar();
        }
        if (!this.getType().getDespawns()) {
            this.remountSpawner();
        }
        this.threatTable = ConfigManager.EnableThreatTables && this.type.usesThreatTable() ? new ThreatTable() : null;
        this.immunityTable = this.type.usesImmunityTable() ? new ImmunityTable() : null;
    }

    public boolean loadSaved() {
        this.type = ActiveMob.getPlugin().getMobManager().getMythicMob(this.mobType);
        this.entity = ActiveMob.getPlugin().server().getEntity(this.uuid);
        if (this.type == null) {
            return false;
        }
        if (this.entity == null) {
            return false;
        }
        if (this.entity.isDead()) {
            return false;
        }
        this.lastSeen = System.currentTimeMillis();
        this.getType().applyMobOptions(this, this.level);
        this.getType().applyMobVolatileOptions(this);
        if (this.hasFaction()) {
            this.entity.setMetadata("faction", this.getFaction());
        }
        if (this.spawnerName != null) {
            this.remountSpawner();
        }
        new TriggeredSkill(SkillTrigger.LOAD, this, null);
        return true;
    }

    public void tick(long timer, int c) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && this.getEntity() != null && !this.getEntity().isValid() && !this.isDead()) {
            this.setUnloaded();
            return;
        }
        if (this.entity.isDead()) {
            this.setDead();
            return;
        }
        this.aliveTime += (long)c;
        if (this.globalCooldown > 0) {
            this.globalCooldown -= c;
        }
        this.children.removeIf(child -> child.isDead() || !child.isValid());
        if ((double)timer % (20.0 / (double)c) == 0.0) {
            this.updateBossBar();
        }
    }

    @Override
    public AbstractEntity getEntity() {
        if (this.entity == null) {
            if (Bukkit.isPrimaryThread()) {
                this.entity = ActiveMob.getPlugin().server().getEntity(this.uuid);
            } else {
                Schedulers.sync().run(() -> {
                    this.entity = ActiveMob.getPlugin().server().getEntity(this.uuid);
                    if (this.entity == null) {
                        this.setDespawnedSync();
                    }
                });
                return null;
            }
        }
        return this.entity;
    }

    public void setEntity(AbstractEntity e) {
        this.entity = e;
    }

    public MythicMob getType() {
        if (this.type == null) {
            this.type = ActiveMob.getPlugin().getMobManager().getMythicMob(this.mobType);
        }
        return this.type;
    }

    public String getDisplayName() {
        PlaceholderString display = this.type.getDisplayName();
        return display == null ? null : display.get(this);
    }

    @Override
    public AbstractLocation getLocation() {
        return this.entity.getLocation();
    }

    public void setParent(SkillCaster am) {
        this.parent = am;
        this.parent.addChild(this.getEntity());
    }

    @Override
    public void addChild(AbstractEntity entity) {
        this.children.add(entity);
    }

    public void setOwner(UUID uuid) {
        this.owner = Optl.of(uuid);
        if (this.getType().getMythicEntity() instanceof BukkitWolf) {
            Wolf wolf = (Wolf)this.getEntity().getBukkitEntity();
            wolf.setOwner((AnimalTamer)Bukkit.getPlayer((UUID)uuid));
        }
    }

    public void removeOwner() {
        this.owner = null;
    }

    public void setMount(ActiveMob am) {
        this.mount = Optional.of(am);
    }

    public void remountType() {
        if (this.mobType == null) {
            this.unregister();
            return;
        }
        MythicMob mm3 = ActiveMob.getPlugin().getMobManager().getMythicMob(this.mobType);
        if (mm3 == null) {
            this.unregister();
            return;
        }
        this.type = mm3;
        if (this.getEntity() != null && (this.getEntity().isLiving() && this.getEntity().getHealth() == this.getEntity().getMaxHealth() || !this.getEntity().isLiving())) {
            this.type.applyMobOptions(this, this.level);
            this.type.applyMobVolatileOptions(this);
        }
    }

    public double getDamage() {
        return this.getType().getDamage(this);
    }

    public double getArmor() {
        return this.getType().getArmor(this);
    }

    public void setLevel(double level) {
        this.level = level;
        this.getType().applyMobOptions(this, level);
        this.getType().applyMobVolatileOptions(this);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
            this.entity.getDataContainer().set(MobKeys.LEVEL, PersistentDataType.DOUBLE, (Object)this.level);
        }
    }

    @Override
    public float getPower() {
        return (float)(1.0 + (this.getLevel() - 1.0) * this.getType().getPerLevelPower());
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public boolean hasFaction() {
        if (this.faction.isPresent()) {
            return true;
        }
        return this.type.hasFaction();
    }

    public String getFaction() {
        if (this.faction.isPresent()) {
            return this.faction.get();
        }
        return this.type.getFaction();
    }

    public ActiveMob setFaction(String faction) {
        this.faction = Optl.of(faction);
        if (faction != null) {
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
                this.entity.getDataContainer().set(MobKeys.FACTION, PersistentDataType.STRING, (Object)faction);
            }
            this.entity.setMetadata("faction", this.getFaction());
        } else {
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
                this.entity.getDataContainer().remove(MobKeys.FACTION);
            }
            this.entity.removeMetadata("faction");
        }
        return this;
    }

    public void incrementPlayerKills() {
        ++this.playerKills;
    }

    public void importPlayerKills(int pk) {
        this.playerKills = pk;
    }

    public void setLastAggroCause(AbstractEntity aggro) {
        this.lastAggroCause = aggro;
    }

    public boolean hasTarget() {
        if (this.hasThreatTable()) {
            return this.threatTable.getTopThreatHolder() == null;
        }
        return this.entity.isCreature() && this.entity.getTarget() != null;
    }

    public void setTarget(AbstractEntity l) {
        this.newTarget = l;
        if (this.entity.isLiving() && !this.changingTarget) {
            this.changingTarget = true;
            ActiveMob.getPlugin().getVolatileCodeHandler().getAIHandler().setTarget((LivingEntity)BukkitAdapter.adapt(this.entity), (LivingEntity)BukkitAdapter.adapt(l));
            this.changingTarget = false;
        }
    }

    public boolean changingTarget() {
        return this.newTarget != null;
    }

    public AbstractEntity getNewTarget() {
        return this.newTarget;
    }

    public void voidTargetChange() {
        this.newTarget = null;
    }

    public void resetTarget() {
        if (this.hasThreatTable()) {
            this.threatTable.dropCombat();
        } else {
            ActiveMob.getPlugin().getVolatileCodeHandler().getAIHandler().setTarget((LivingEntity)BukkitAdapter.adapt(this.entity), null);
        }
    }

    public ThreatTable getThreatTable() {
        if (this.threatTable == null && ConfigManager.EnableThreatTables && this.type.usesThreatTable()) {
            this.threatTable = new ThreatTable();
        }
        return this.threatTable;
    }

    public boolean hasThreatTable() {
        return this.threatTable != null;
    }

    public void importThreatTable(ThreatTable tt) {
        this.threatTable = tt;
    }

    public boolean hasImmunityTable() {
        return this.immunityTable != null;
    }

    public void setDespawned() {
        if (!this.dead) {
            this.dead = true;
            try {
                TriggeredSkill triggeredSkill = new TriggeredSkill(SkillTrigger.DESPAWNED, this, this.getEntity());
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
                // empty catch block
            }
            Schedulers.sync().run(() -> ActiveMob.getPlugin().server().handleMobDespawnEvent(this));
            if (this.getSpawner() != null) {
                this.getSpawner().markMobDespawned(this);
            }
        }
        this.unregister();
    }

    public void setDespawnedSync() {
        if (!this.dead) {
            this.dead = true;
            try {
                TriggeredSkill triggeredSkill = new TriggeredSkill(SkillTrigger.DESPAWNED, this, this.getEntity());
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
                // empty catch block
            }
            ActiveMob.getPlugin().server().handleMobDespawnEvent(this);
            if (this.getSpawner() != null) {
                this.getSpawner().markMobDespawned(this);
            }
        }
        this.unregisterSync();
    }

    public void setDead() {
        if (!this.dead) {
            this.dead = true;
            if (this.getSpawner() != null) {
                this.getSpawner().markMobDead(this);
            }
            this.unregister();
        }
    }

    public void setUnloaded() {
        if (!this.dead) {
            if (this.type == null) {
                this.dead = true;
                this.unregister();
            } else if (this.type.getDespawns() && !this.type.isPersistent()) {
                this.dead = true;
                try {
                    TriggeredSkill triggeredSkill = new TriggeredSkill(SkillTrigger.DESPAWNED, this, this.getEntity());
                }
                catch (IllegalPluginAccessException illegalPluginAccessException) {
                    // empty catch block
                }
                ActiveMob.getPlugin().server().handleMobDespawnEvent(this);
                if (this.getSpawner() != null) {
                    this.getSpawner().markMobDespawned(this);
                }
                this.unregister();
            } else {
                this.unloadBossBars();
                ActiveMob.getPlugin().getMobManager().getMobRegistry().get().setInactive(this.uuid);
            }
        }
    }

    public void unregister() {
        if (this.entity != null) {
            ActiveMob.getPlugin().getMobManager().setIgnoreEntity(this.entity.getUniqueId());
        }
        this.unloadBossBars();
        this.setShowCustomNameplate(false);
        Schedulers.sync().runLater(() -> MythicMobs.inst().getMobManager().unregisterActiveMob(this), 60L);
    }

    public void unregisterSync() {
        ActiveMob.getPlugin().getMobManager().setIgnoreEntity(this.entity.getUniqueId());
        this.unloadBossBars();
        this.setShowCustomNameplate(false);
        MythicMobs.inst().getMobManager().unregisterActiveMob(this);
    }

    @Override
    public void setUsingDamageSkill(boolean b) {
        this.damageSkillRunning = b;
    }

    @Override
    public boolean isUsingDamageSkill() {
        return this.damageSkillRunning;
    }

    public void setLastDamageSkillAmount(double d) {
        this.lastDamageSkillAmount = d;
    }

    public double getLastDamageSkillAmount() {
        return this.lastDamageSkillAmount;
    }

    public void setSpawner(MythicSpawner ms) {
        this.spawnerName = ms.getInternalName();
        this.spawner = ms;
    }

    public void remountSpawner() {
        MythicSpawner maybeSpawner;
        if (this.spawnerName != null && (maybeSpawner = ActiveMob.getPlugin().getSpawnerManager().getSpawnerByName(this.spawnerName)) != null) {
            this.spawner = maybeSpawner;
            this.spawner.trackMob(this);
        }
    }

    public void signalMob(AbstractEntity trigger, String signal) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Received signal {0} from {1}", signal, trigger.getUniqueId());
        SkillMetadata data = new SkillMetadata(SkillTrigger.SIGNAL, this, trigger);
        if (trigger != null) {
            HashSet<AbstractEntity> eTargets = new HashSet<AbstractEntity>();
            eTargets.add(data.getTrigger());
            data.setEntityTargets(eTargets);
        }
        data.setPower(this.getPower());
        this.lastSignal = signal;
        this.getType().executeSignalSkill(signal, data);
    }

    public void signalDamaged() {
        if (this.healthbar != null) {
            this.healthbar.update();
        } else if (this.getType().getUsesHealthBar().booleanValue()) {
            this.healthbar = ActiveMob.getPlugin().getHologramManager().createHealthBar(this);
        }
    }

    @Override
    public AuraRegistry getAuraRegistry() {
        return ActiveMob.getPlugin().getSkillManager().getAuraManager().getAuraRegistry(this.entity);
    }

    public void addBar(String key, AbstractBossBar bar) {
        if (this.bossBars == null) {
            this.bossBars = new ConcurrentHashMap<String, AbstractBossBar>();
        }
        this.bossBars.put(key, bar);
    }

    public AbstractBossBar getBar(String key) {
        return this.bossBars == null ? null : (AbstractBossBar)this.bossBars.getOrDefault(key, null);
    }

    public void removeBar(String key) {
        if (this.bossBars != null && this.bossBars.containsKey(key)) {
            this.bossBars.remove(key).terminate();
        }
    }

    public void updateBossBar() {
        if (!this.bossBar.isPresent() && this.bossBars == null) {
            return;
        }
        Collection<AbstractPlayer> inRange = this.getLocation().getWorld().getPlayersInRadius(this.getLocation(), this.getType().getBossBarRangeSquared());
        Collection inRangeIds = inRange.stream().map(p -> p.getUniqueId()).collect(Collectors.toSet());
        if (this.bossBar.isPresent()) {
            AbstractBossBar bar = this.bossBar.get();
            Collection<AbstractPlayer> current = bar.getPlayers();
            double progress = this.getEntity().getHealth() / this.getEntity().getMaxHealth();
            String title = this.type.getBossBarTitle().get(new GenericPlaceholderMeta(this, this.getEntity()));
            bar.setTitle(title);
            bar.setProgress(progress);
            current.stream().forEach(player -> {
                if (!inRangeIds.contains(player.getUniqueId())) {
                    bar.removePlayer((AbstractPlayer)player);
                }
            });
            inRange.stream().forEach(player -> {
                if (!bar.isViewing((AbstractPlayer)player)) {
                    bar.addPlayer((AbstractPlayer)player);
                }
            });
        }
        if (this.bossBars != null) {
            this.bossBars.values().forEach(barx -> barx.getPlayers().removeIf(player -> !inRange.contains(player)));
            inRange.stream().forEach(player -> this.bossBars.values().forEach(barx -> {
                if (!barx.getPlayers().contains(player)) {
                    barx.addPlayer((AbstractPlayer)player);
                }
            }));
        }
    }

    public void unloadBossBars() {
        if (this.bossBar.isPresent()) {
            this.bossBar.get().removeAll();
            this.bossBar = Optional.empty();
        }
        if (this.bossBars != null) {
            this.bossBars.values().forEach(bar -> bar.terminate());
            this.bossBars.clear();
        }
    }

    public boolean getShowCustomNameplate() {
        return this.nameplate == null;
    }

    public void setShowCustomNameplate(boolean b) {
        if (b) {
            if (this.nameplate == null) {
                this.nameplate = ActiveMob.getPlugin().getHologramManager().createNameplate(this);
            }
        } else if (this.nameplate != null) {
            this.nameplate.terminate();
            this.nameplate = null;
        }
    }

    public SpeechBubble createSpeechBubble() {
        if (this.speechBubble == null) {
            this.speechBubble = ActiveMob.getPlugin().getHologramManager().createSpeechBubble(this);
        }
        return this.speechBubble;
    }

    public void removeSpeechBubble() {
        if (this.speechBubble != null) {
            this.speechBubble.terminate();
        }
    }

    public int hashCode() {
        return this.getUniqueId().toString().hashCode();
    }

    public String getMobType() {
        return this.mobType;
    }

    public long getAliveTime() {
        return this.aliveTime;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public AbstractLocation getSpawnLocation() {
        return this.spawnLocation;
    }

    public VariableRegistry getVariables() {
        return this.variables;
    }

    @Override
    public double getLevel() {
        return this.level;
    }

    @Override
    public int getGlobalCooldown() {
        return this.globalCooldown;
    }

    @Override
    public void setGlobalCooldown(int globalCooldown) {
        this.globalCooldown = globalCooldown;
    }

    public String getStance() {
        return this.stance;
    }

    public void setStance(String stance) {
        this.stance = stance;
    }

    public String getLastSignal() {
        return this.lastSignal;
    }

    public int getPlayerKills() {
        return this.playerKills;
    }

    public Optl<UUID> getOwner() {
        return this.owner;
    }

    public SkillCaster getParent() {
        return this.parent;
    }

    @Override
    public Collection<AbstractEntity> getChildren() {
        return this.children;
    }

    public Optional<ActiveMob> getMount() {
        return this.mount;
    }

    public MythicSpawner getSpawner() {
        return this.spawner;
    }

    public ImmunityTable getImmunityTable() {
        return this.immunityTable;
    }

    public SpeechBubble getSpeechBubble() {
        return this.speechBubble;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    public AbstractEntity getLastAggroCause() {
        return this.lastAggroCause;
    }

    public class ThreatTable
    implements Cloneable {
        private WeakReference<ActiveMob> mob;
        private double totalThreat = 0.0;
        private double targetThreat = 0.0;
        private int targetOutOfRangeTicks = 0;
        private AbstractEntity target = null;
        private Map<AbstractEntity, Double> threatTable = new ConcurrentHashMap<AbstractEntity, Double>();

        public void setParent(ActiveMob am) {
            this.mob = new WeakReference<ActiveMob>(am);
        }

        public void tickThreat() {
            block12: {
                try {
                    if (this.target == null) {
                        this.clearTarget();
                        this.targetHighestThreat();
                        return;
                    }
                    if (this.target.isDead()) {
                        this.targetDeath();
                        return;
                    }
                    if (this.threatTable.size() == 0) {
                        this.dropCombat();
                        return;
                    }
                    if (ActiveMob.this.getType().getThreatTableDecaysUnreachable() && !this.target.hasLineOfSight(ActiveMob.this.getEntity())) {
                        this.decayTargetThreat();
                    }
                    if (this.target.isPlayer() && !this.target.asPlayer().isOnline()) {
                        this.clearTarget();
                        this.targetHighestThreat();
                    }
                    if (!this.target.getLocation().getWorld().equals(ActiveMob.this.getEntity().getLocation().getWorld()) || this.target.isPlayer() && (this.target.asPlayer().isInCreativeMode() || this.target.asPlayer().isInSpectatorMode())) {
                        this.clearTarget();
                        this.targetHighestThreat();
                        this.targetOutOfRangeTicks = 0;
                    } else if (ActiveMob.this.getType().getThreatTableDecaysUnreachable() && this.target.getLocation().distance(ActiveMob.this.getEntity().getLocation()) > (double)ActiveMob.this.getType().getMaxThreatDistance()) {
                        ++this.targetOutOfRangeTicks;
                        if (this.targetOutOfRangeTicks >= 10) {
                            this.clearTarget();
                            this.targetHighestThreat();
                            this.targetOutOfRangeTicks = 0;
                        }
                    } else {
                        this.targetOutOfRangeTicks = 0;
                    }
                }
                catch (Error | Exception ex) {
                    this.clearTarget();
                    this.targetHighestThreat();
                    if (ConfigManager.debugLevel <= 0) break block12;
                    ex.printStackTrace();
                }
            }
        }

        public boolean inCombat() {
            return this.threatTable.size() > 0;
        }

        public boolean targetEvent(AbstractEntity entity) {
            if (entity == null) {
                return false;
            }
            if (this.target == null) {
                this.target = entity;
                ActiveMob.this.setTarget(entity);
                if (this.threatTable.containsKey(entity)) {
                    this.targetThreat = this.threatTable.get(entity);
                } else {
                    if (!this.inCombat()) {
                        ActiveMob.getPlugin().getMobManager().setInCombat(ActiveMob.this, true);
                        new TriggeredSkill(SkillTrigger.ENTERCOMBAT, ActiveMob.this, entity);
                    }
                    this.targetThreat = 1.0;
                    this.threatTable.put(entity, 1.0);
                }
                return true;
            }
            if (this.target.equals(entity)) {
                return true;
            }
            if (this.target.isDead()) {
                this.targetDeath();
                return this.target != null && this.target.equals(entity);
            }
            return false;
        }

        public boolean Taunt(AbstractEntity target) {
            if (target.equals(this.target)) {
                return false;
            }
            this.threatTable.put(target, this.targetThreat * 1.1);
            this.targetThreateningEntity(target);
            return true;
        }

        public void dropCombat() {
            this.target = null;
            this.targetThreat = 0.0;
            this.totalThreat = 0.0;
            this.threatTable.clear();
            ActiveMob.getPlugin().getMobManager().setInCombat(ActiveMob.this, false);
            ActiveMob.getPlugin().getVolatileCodeHandler().getAIHandler().setTarget((LivingEntity)ActiveMob.this.entity.getBukkitEntity(), null);
            new TriggeredSkill(SkillTrigger.DROPCOMBAT, ActiveMob.this, null);
        }

        public void observeDeath(AbstractEntity entity) {
            if (this.target == null) {
                return;
            }
            if (this.target.equals(entity)) {
                this.targetDeath();
            }
            this.threatTable.remove(entity);
        }

        public void observeChangeWorld(AbstractEntity entity) {
            if (this.target == null) {
                return;
            }
            if (this.target.equals(entity)) {
                this.clearTarget();
                if (this.inCombat()) {
                    this.targetHighestThreat();
                }
            }
            this.threatTable.remove(entity);
        }

        public boolean targetThreateningEntity(AbstractEntity entity) {
            this.target = entity;
            this.targetThreat = this.threatTable.get(entity);
            ActiveMob.this.setTarget(this.target);
            return true;
        }

        public void targetHighestThreat() {
            if (this.threatTable.size() == 0) {
                this.dropCombat();
                return;
            }
            Iterator<Map.Entry<AbstractEntity, Double>> it = this.threatTable.entrySet().iterator();
            this.targetThreat = 0.0;
            while (it.hasNext()) {
                Map.Entry<AbstractEntity, Double> pairs = it.next();
                if (!(pairs.getValue() > this.targetThreat)) continue;
                this.targetThreat = pairs.getValue();
                this.target = pairs.getKey();
            }
            ActiveMob.this.setTarget(this.target);
        }

        public void clearTarget() {
            if (this.target != null) {
                this.threatTable.remove(this.target);
            }
            if (this.threatTable.size() == 0) {
                this.dropCombat();
            }
        }

        public void targetDeath() {
            if (this.target.isDead()) {
                this.clearTarget();
                this.targetHighestThreat();
            }
        }

        public void threatSet(AbstractEntity entity, double amount) {
            if (entity == null) {
                return;
            }
            if (entity.getUniqueId().equals(ActiveMob.this.getUniqueId())) {
                return;
            }
            if (ActiveMob.this.owner.isPresent() && ((UUID)ActiveMob.this.owner.get()).equals(entity.getUniqueId())) {
                return;
            }
            if (entity.isPlayer() && (entity.asPlayer().isInCreativeMode() || entity.asPlayer().isInSpectatorMode())) {
                return;
            }
            if (this.target == null) {
                this.targetEvent(entity);
                this.targetThreat = amount;
            } else if (this.target.equals(entity)) {
                this.targetThreat += amount;
                amount = this.targetThreat;
            }
            this.threatTable.put(entity, amount);
            if (amount > this.targetThreat * 1.1) {
                this.targetThreateningEntity(entity);
            }
            this.totalThreat += amount;
        }

        public void threatGain(AbstractEntity entity, double amount) {
            if (entity == null) {
                return;
            }
            if (entity.getUniqueId().equals(ActiveMob.this.getUniqueId())) {
                return;
            }
            if (ActiveMob.this.owner.isPresent() && ((UUID)ActiveMob.this.owner.get()).equals(entity.getUniqueId())) {
                return;
            }
            if (entity.isPlayer() && (entity.asPlayer().isInCreativeMode() || entity.asPlayer().isInSpectatorMode())) {
                return;
            }
            if (this.target == null) {
                this.targetEvent(entity);
                this.targetThreat = amount;
            } else if (this.target.equals(entity)) {
                this.targetThreat += amount;
                amount = this.targetThreat;
            } else if (this.threatTable.containsKey(entity)) {
                amount += this.threatTable.get(entity).doubleValue();
            }
            this.threatTable.put(entity, amount);
            if (amount > this.targetThreat * 1.1) {
                this.targetThreateningEntity(entity);
            }
            this.totalThreat += amount;
        }

        public void threatLoss(AbstractEntity entity, double amount) {
            double nT;
            if (this.threatTable.containsKey(entity)) {
                nT = this.threatTable.get(entity) - amount;
                if (nT < 0.0) {
                    amount -= 0.0 - nT;
                    nT = 0.0;
                }
            } else {
                return;
            }
            this.threatTable.put(entity, nT);
            this.totalThreat -= amount;
            if (this.target.equals(entity)) {
                this.targetHighestThreat();
            }
        }

        public void decayTargetThreat() {
            double dt = this.targetThreat * 0.96;
            this.totalThreat -= this.targetThreat - dt;
            this.targetThreat = dt;
            this.threatTable.put(this.target, dt);
        }

        public AbstractEntity getTopThreatHolder() {
            return this.target;
        }

        public double getTopTargetThreat() {
            return this.targetThreat;
        }

        public double getThreat(AbstractEntity entity) {
            if (this.threatTable.containsKey(entity)) {
                return this.threatTable.get(entity);
            }
            return 0.0;
        }

        public double getTotalThreat() {
            return this.totalThreat;
        }

        public Set<AbstractEntity> getAllThreatTargets() {
            return this.threatTable.keySet();
        }

        public int size() {
            return this.threatTable.size();
        }

        public ImmutableMap<AbstractEntity, Double> asMap() {
            return ImmutableMap.copyOf(this.threatTable);
        }

        public ThreatTable clone() throws CloneNotSupportedException {
            return (ThreatTable)super.clone();
        }
    }

    public class ImmunityTable {
        private long otherSource;
        private ConcurrentHashMap<AbstractEntity, Long> immunityTable = new ConcurrentHashMap();

        public void setCooldown(AbstractEntity e) {
            if (e == null) {
                this.otherSource = ActiveMob.this.aliveTime;
            } else {
                this.immunityTable.put(e, ActiveMob.this.aliveTime);
            }
        }

        public boolean onCooldown(AbstractEntity e) {
            if (e == null) {
                return ActiveMob.this.aliveTime - this.otherSource <= (long)(ActiveMob.this.getNoDamageTicks() / 2);
            }
            if (this.immunityTable.containsKey(e)) {
                long last = this.immunityTable.get(e);
                return ActiveMob.this.aliveTime - last <= (long)(ActiveMob.this.getNoDamageTicks() / 2);
            }
            return false;
        }
    }
}

