/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.items;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.items.LegacyItemConverter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.Patterns;
import io.lumine.xikage.mythicmobs.util.jnbt.ByteTag;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTagBuilder;
import io.lumine.xikage.mythicmobs.util.jnbt.DoubleTag;
import io.lumine.xikage.mythicmobs.util.jnbt.IntTag;
import io.lumine.xikage.mythicmobs.util.jnbt.ListTag;
import io.lumine.xikage.mythicmobs.util.jnbt.ListTagBuilder;
import io.lumine.xikage.mythicmobs.util.jnbt.LongTag;
import io.lumine.xikage.mythicmobs.util.jnbt.StringTag;
import io.lumine.xikage.mythicmobs.util.jnbt.Tag;
import io.lumine.xikage.mythicmobs.utils.adventure.text.serializer.gson.GsonComponentSerializer;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.text.Text;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileMaterial;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileItemHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class MythicItem
implements Comparable<MythicItem> {
    private final MythicConfig config;
    private BukkitItemStack itemStack;
    private final String internalName;
    private final String file;
    private String displayName;
    private String id;
    private String mythicType;
    private Material material;
    private int iid;
    private boolean useiid;
    @Deprecated
    private int data;
    private int amount;
    private int customModelData;
    private PlaceholderInt maxEnchantments;
    private String color;
    private String player;
    private String skinURL;
    private String skinTexture;
    private UUID skinUUID;
    private List<PlaceholderString> lore;
    private List<String> enchantments;
    private List<String> potionEffects;
    private List<String> bannerLayers;
    private List<String> fireworkColors;
    private List<String> fireworkFadeColors;
    private Map<String, Map<String, Object>> itemNBT;
    private ListTag tagItemAttributes;
    private Map<String, Tag> itemOptions;
    private List<String> hideOptions;
    private boolean unbreakable;
    private boolean hideFlags;
    private Boolean appendType;

    private static final MythicMobs getPlugin() {
        return MythicMobs.inst();
    }

    private static final VolatileItemHandler getItemHandler() {
        return MythicItem.getPlugin().getVolatileCodeHandler().getItemHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MythicItem(String file, String internalName, MythicConfig mc) {
        block49: {
            boolean preventStacking;
            List<String> hideOptions;
            double mmoPvEDamage;
            boolean repairable;
            int repairCost;
            block47: {
                this.useiid = false;
                this.data = 0;
                this.amount = 1;
                this.itemNBT = new HashMap<String, Map<String, Object>>();
                this.tagItemAttributes = null;
                this.itemOptions = new HashMap<String, Tag>();
                this.hideOptions = new ArrayList<String>();
                this.appendType = true;
                this.config = mc;
                this.file = file;
                this.internalName = internalName;
                this.mythicType = internalName;
                this.data = mc.getInteger("Data", 0);
                this.data = mc.getInteger("Durability", this.data);
                this.data = mc.getInteger("Options.Durability", this.data);
                if (mc.isSet("ItemStack")) {
                    ItemStack is = mc.getItemStack("ItemStack", null);
                    if (is != null) {
                        this.itemStack = new BukkitItemStack(is);
                        try {
                            this.displayName = is.getItemMeta().getDisplayName();
                            this.lore = new ArrayList<PlaceholderString>();
                            for (String s2 : is.getItemMeta().getLore()) {
                                this.lore.add(PlaceholderString.of(s2));
                            }
                        }
                        catch (Exception ex) {
                            MythicLogger.errorItemConfig(this, mc, "Couldn't get name/lore of ItemStack");
                        }
                    } else {
                        MythicLogger.errorItemConfig(this, mc, "Failed to load imported Bukkit ItemStack");
                        this.itemStack = new BukkitItemStack(Material.STONE);
                    }
                } else {
                    this.id = mc.getString("Id", "STONE").toUpperCase();
                    try {
                        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
                            this.material = Material.AIR;
                            try {
                                Material material = this.material = this.data == 0 ? Material.valueOf((String)this.id) : LegacyItemConverter.getMaterial(this.id, (byte)this.data);
                                if (this.material == null && this.data > 0) {
                                    this.material = Material.valueOf((String)this.id);
                                }
                                break block47;
                            }
                            catch (Exception ex) {
                                this.material = LegacyItemConverter.getMaterial(this.id, (byte)this.data);
                                if (this.material == null && this.data > 0) {
                                    this.material = Material.valueOf((String)this.id);
                                }
                                break block47;
                            }
                            finally {
                                this.itemStack = new BukkitItemStack(this.material);
                            }
                        }
                        if (this.id.matches("[0-9]*")) {
                            this.material = LegacyItemConverter.getMaterial(this.id, (byte)0);
                            this.itemStack = new BukkitItemStack(this.material).data((byte)this.data).amount(this.amount * this.amount);
                        } else {
                            this.material = Material.valueOf((String)this.id);
                            this.itemStack = new BukkitItemStack(this.material).data((byte)this.data).amount(this.amount * this.amount);
                        }
                    }
                    catch (Exception ex) {
                        this.material = Material.STONE;
                        this.itemStack = new BukkitItemStack(this.material);
                        MythicLogger.errorItemConfig(this, mc, "Material type '" + this.id + "' not found");
                    }
                }
            }
            this.amount = mc.getInteger("Amount", 1);
            this.displayName = SkillString.parseMessageSpecialChars(mc.getColorString("Display"));
            this.lore = mc.getPlaceholderStringList("Lore");
            this.enchantments = mc.getStringList("Enchantments");
            this.potionEffects = mc.getStringList("PotionEffects");
            this.bannerLayers = mc.getStringList("BannerLayers");
            this.fireworkColors = mc.getStringList("Firework.Colors");
            this.fireworkFadeColors = mc.getStringList("Firework.FadeColors");
            this.color = mc.getString("Options.Color");
            this.player = mc.getString("Options.Player");
            this.skinURL = mc.getString("Options.SkinURL");
            this.skinTexture = mc.getString("Options.SkinTexture");
            if (this.skinTexture != null) {
                this.skinUUID = MythicUtil.getUUIDFromString(this.skinTexture);
            } else if (this.skinURL != null) {
                this.skinUUID = MythicUtil.getUUIDFromString(this.skinURL);
            }
            this.unbreakable = mc.getBoolean("Options.Indestructable", false);
            this.unbreakable = mc.getBoolean("Options.Unbreakable", this.unbreakable);
            this.hideFlags = mc.getBoolean("Options.HideFlags", false);
            this.appendType = mc.getBoolean("Options.AppendType", false);
            this.customModelData = mc.getInteger("Options.Model", -1);
            this.customModelData = mc.getInteger("Options.CustomModelData", this.customModelData);
            this.customModelData = mc.getInteger("Model", this.customModelData);
            this.customModelData = mc.getInteger("CustomModelData", this.customModelData);
            this.maxEnchantments = PlaceholderInt.of(mc.getString("Options.MaxEnchants", "-1"));
            if (this.customModelData > -1) {
                this.itemOptions.put("CustomModelData", new IntTag(this.customModelData));
            }
            if (this.unbreakable) {
                this.itemOptions.put("Unbreakable", new ByteTag(1));
            }
            if (this.hideFlags) {
                this.itemOptions.put("HideFlags", new IntTag(127));
            }
            if ((repairCost = mc.getInteger("Options.RepairCost", -1)) >= 0) {
                this.itemOptions.put("RepairCost", new IntTag(repairCost));
            }
            if (!(repairable = mc.getBoolean("Options.Repairable", true))) {
                this.itemOptions.put("RepairCost", new IntTag(Integer.MAX_VALUE));
            }
            if ((mmoPvEDamage = mc.getDouble("MMOItemsStats.PvEDamage", -1.0)) > -1.0) {
                this.itemOptions.put("MMOITEMS_PVE_DAMAGE", new DoubleTag(mmoPvEDamage));
            }
            if ((hideOptions = mc.getStringList("Hide")) != null) {
                for (String hide : hideOptions) {
                    String f = "HIDE_" + hide.toUpperCase();
                    this.hideOptions.add(f);
                }
            }
            if (preventStacking = mc.getBoolean("Options.PreventStacking", false)) {
                UUID rand = UUID.randomUUID();
                this.itemOptions.put("UUIDMost", new LongTag(rand.getMostSignificantBits()));
                this.itemOptions.put("UUIDLeast", new LongTag(rand.getLeastSignificantBits()));
            }
            if (mc.isSet("NBT")) {
                try {
                    for (String baseKey : mc.getKeys("NBT")) {
                        HashMap<String, Object> tags = new HashMap<String, Object>();
                        if (mc.isConfigurationSection("NBT." + baseKey)) {
                            for (String key : mc.getKeys("NBT." + baseKey)) {
                                if (key.equals("@Denizen")) {
                                    key = "Denizen NBT";
                                }
                                tags.put(key, this.getNbtValue(mc.getString("NBT." + baseKey + "." + key)));
                            }
                            this.itemNBT.put(baseKey, tags);
                            continue;
                        }
                        for (String key : mc.getKeys("NBT")) {
                            tags.put(key, this.getNbtValue(mc.getString("NBT." + key)));
                        }
                        this.itemNBT.put("Base", tags);
                        break;
                    }
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, mc, "NBT tags are configured incorrectly.");
                }
            }
            if (mc.isSet("Attributes")) {
                try {
                    ListTagBuilder itemAttributesBuilder = ListTagBuilder.create(CompoundTag.class);
                    UUID tagUUID = MythicUtil.getUUIDFromString(this.internalName);
                    for (String slot : mc.getKeys("Attributes")) {
                        for (String attr : mc.getKeys("Attributes." + slot)) {
                            String strValue = mc.getString("Attributes." + slot + "." + attr);
                            String attributeKey = MythicMobs.inst().getItemManager().getItemAttribute(attr);
                            int operation = -1;
                            CompoundTag tagAttribute = MythicItem.getPlugin().getVolatileCodeHandler().createCompoundTag(new HashMap<String, Tag>());
                            if (strValue.endsWith("%")) {
                                strValue = strValue.substring(0, strValue.length() - 1);
                                operation = 1;
                                strValue = String.valueOf(Double.valueOf(strValue) / 100.0);
                            }
                            PlaceholderDouble value = PlaceholderDouble.of(strValue);
                            if (operation == -1) {
                                operation = attributeKey.equals("generic.attackSpeed") || attributeKey.equals("generic.attack_speed") || attributeKey.equals("generic.movementSpeed") || attributeKey.equals("generic.movement_speed") ? 1 : 0;
                            }
                            CompoundTagBuilder builder = tagAttribute.createBuilder();
                            builder.putString("Name", attributeKey).putString("AttributeName", attributeKey).putPlaceholderDouble("Amount", value).putInt("Operation", operation).putLong("UUIDMost", tagUUID.getMostSignificantBits()).putLong("UUIDLeast", tagUUID.getLeastSignificantBits());
                            if (!slot.equals("ALL")) {
                                builder.putString("Slot", slot);
                            }
                            itemAttributesBuilder.add(builder.build());
                        }
                    }
                    this.tagItemAttributes = itemAttributesBuilder.build();
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, mc, "Attributes are configured incorrectly.");
                    if (ConfigManager.debugLevel <= 0) break block49;
                    ex.printStackTrace();
                }
            }
        }
    }

    private Object getNbtValue(String string) {
        if (string.startsWith("int/")) {
            return Integer.parseInt(string.substring(4));
        }
        if (string.startsWith("float/")) {
            return Float.valueOf(Float.parseFloat(string.substring(6)));
        }
        if (string.startsWith("double/")) {
            return Double.parseDouble(string.substring(7));
        }
        if (string.startsWith("byte/")) {
            return Byte.parseByte(string.substring(5));
        }
        if (string.startsWith("bool/")) {
            return Boolean.parseBoolean(string.substring(5));
        }
        if (string.startsWith("boolean/")) {
            return Boolean.parseBoolean(string.substring(8));
        }
        return string;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public String getFile() {
        return this.file;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        ArrayList<String> ret = new ArrayList<String>();
        for (PlaceholderString pl : this.lore) {
            ret.add(pl.toString());
        }
        return ret;
    }

    public Material getMaterial() {
        return this.material;
    }

    @Deprecated
    public String getMaterialName() {
        return this.id;
    }

    @Deprecated
    public int getMaterialData() {
        return this.data;
    }

    public int getAmount() {
        return this.amount;
    }

    public AbstractItemStack generateItemStack(int amount) {
        return this.generateItemStack(null, amount);
    }

    @Deprecated
    public AbstractItemStack generateItemStack(int amount, AbstractEntity dropper, AbstractEntity trigger) {
        return this.generateItemStack(null, amount);
    }

    public AbstractItemStack generateItemStack(DropMetadata meta, int amount) {
        ItemMeta im;
        AbstractEntity trigger;
        AbstractEntity dropper;
        if (meta != null) {
            dropper = meta.getDropper().isPresent() ? meta.getDropper().get().getEntity() : null;
            trigger = meta.getCause().isPresent() ? meta.getCause().get() : null;
        } else {
            dropper = null;
            trigger = null;
        }
        Entity d = dropper == null ? null : BukkitAdapter.adapt(dropper);
        Entity k = trigger == null ? null : BukkitAdapter.adapt(trigger);
        ItemStack stack = this.itemStack.build().clone();
        stack.setAmount(stack.getAmount() * amount);
        CompoundTagBuilder compoundTag = MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(stack).createBuilder();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            boolean usesDisplayTag = false;
            CompoundTagBuilder displayTag = CompoundTagBuilder.create();
            if (this.displayName != null) {
                usesDisplayTag = true;
                displayTag.putString("Name", (String)GsonComponentSerializer.gson().serialize(Text.parse(this.displayName)));
            }
            if (this.lore != null && this.lore.size() > 0) {
                usesDisplayTag = true;
                ListTagBuilder loreBuilder = ListTagBuilder.create(StringTag.class);
                for (PlaceholderString pl : this.lore) {
                    String str = pl.get(meta);
                    if ((str = SkillString.parseMessageSpecialChars(str)).contains("{")) {
                        Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                        while (pMatcher.find()) {
                            int min2 = Integer.parseInt(pMatcher.group(1));
                            int max = Integer.parseInt(pMatcher.group(2));
                            int num = Numbers.randomInt(max - min2) + min2;
                            str = str.replace(pMatcher.group(0), "" + num);
                        }
                    }
                    loreBuilder.add(new StringTag((String)GsonComponentSerializer.gson().serialize(Text.parse(str))));
                }
                displayTag.put("Lore", loreBuilder.build());
            }
            if (usesDisplayTag) {
                compoundTag.put("display", displayTag.build());
            }
        }
        compoundTag.putAll(this.itemOptions);
        if (this.tagItemAttributes != null) {
            compoundTag.put("AttributeModifiers", this.tagItemAttributes);
        }
        if (this.appendType.booleanValue()) {
            compoundTag.putString("MYTHIC_TYPE", this.mythicType);
        }
        stack = MythicItem.getItemHandler().setNBTData(stack, compoundTag.build(), meta);
        if (this.itemNBT.size() > 0) {
            try {
                for (Map.Entry<String, Map<String, Object>> entry : this.itemNBT.entrySet()) {
                    stack = MythicItem.addItemNBT(stack, entry.getKey(), entry.getValue());
                }
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "Failed to add Item NBT - is this version supported?");
            }
        }
        if ((im = stack.getItemMeta()) == null && (im = Bukkit.getItemFactory().getItemMeta(stack.getType())) == null) {
            MythicLogger.errorItemConfig(this, this.config, "Failed to apply ItemMeta to item");
            return BukkitAdapter.adapt(stack);
        }
        if (this.lore != null && !this.lore.isEmpty() && !ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            ArrayList<String> parsedLore = Lists.newArrayList();
            for (PlaceholderString pl : this.lore) {
                String str = pl.get(meta);
                if ((str = SkillString.parseMessageSpecialChars(str)).contains("{")) {
                    Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                    while (pMatcher.find()) {
                        int min3 = Integer.parseInt(pMatcher.group(1));
                        int max = Integer.parseInt(pMatcher.group(2));
                        int num = Numbers.randomInt(max - min3) + min3;
                        str = str.replace(pMatcher.group(0), "" + num);
                    }
                }
                parsedLore.add(str);
            }
            im.setLore(parsedLore);
        }
        try {
            Class.forName("org.bukkit.inventory.meta.BannerMeta");
            if (im instanceof BannerMeta) {
                im = this.buildBanner(im);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (stack.getType().equals((Object)Material.SHIELD)) {
                im = this.buildShield(im);
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        if (stack.getType() == Material.POTION || stack.getType() == Material.SPLASH_POTION || stack.getType() == Material.LINGERING_POTION || stack.getType() == Material.TIPPED_ARROW) {
            im = this.buildPotion(im);
        }
        if (stack.getType().equals((Object)VolatileMaterial.PLAYER_HEAD) || stack.getType().equals((Object)VolatileMaterial.PLAYER_WALL_HEAD)) {
            im = MythicItem.buildSkull((SkullMeta)im, this);
        }
        if (stack.getType().equals((Object)VolatileMaterial.FIREWORK_ROCKET)) {
            im = this.buildFirework(im);
        }
        if (stack.getType().equals((Object)VolatileMaterial.FIREWORK_STAR)) {
            im = this.buildFireworkCharge(im);
        }
        if (meta instanceof MapMeta && this.data > 0) {
            ((MapMeta)meta).setMapId(this.data);
            ((MapMeta)meta).setMapView(Bukkit.getMap((int)this.data));
        }
        try {
            if (this.displayName != null && !ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
                im.setDisplayName(this.displayName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hideOptions != null) {
            for (String hide : this.hideOptions) {
                ItemFlag flag = ItemFlag.valueOf((String)hide);
                im.addItemFlags(new ItemFlag[]{flag});
            }
        }
        stack.setItemMeta(im);
        if (this.data != 0) {
            stack.setDurability((short)this.data);
        }
        if (CompatibilityManager.EnchantsPlus != null) {
            CompatibilityManager.EnchantsPlus.setEnchants(stack, this.enchantments);
        }
        if (this.enchantments != null) {
            stack = this.setEnchantments(dropper, stack);
        }
        if (this.color != null) {
            stack = MythicItem.setLeatherColor(stack, this);
        }
        return BukkitAdapter.adapt(stack);
    }

    public static ItemStack addItemNBT(ItemStack itemStack, String baseKey, Map<String, Object> pairs) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(itemStack);
        if (baseKey.equals("Base")) {
            CompoundTagBuilder builder = compoundTag.createBuilder();
            for (Map.Entry<String, Object> entry : pairs.entrySet()) {
                Object val = entry.getValue();
                if (val instanceof Integer) {
                    builder.putInt(entry.getKey(), (Integer)val);
                    continue;
                }
                if (val instanceof Double) {
                    builder.putDouble(entry.getKey(), (Double)val);
                    continue;
                }
                if (val instanceof Float) {
                    builder.putFloat(entry.getKey(), ((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    builder.putBoolean(entry.getKey(), (Boolean)val);
                    continue;
                }
                if (val instanceof Byte) {
                    builder.putByte(entry.getKey(), (Byte)val);
                    continue;
                }
                builder.putString(entry.getKey(), val.toString());
            }
            compoundTag = builder.build();
        } else {
            CompoundTag newTag = compoundTag.getValue().containsKey(baseKey) ? (CompoundTag)compoundTag.getValue().get(baseKey) : MythicMobs.inst().getVolatileCodeHandler().createCompoundTag(new HashMap<String, Tag>());
            CompoundTagBuilder builder = newTag.createBuilder();
            for (Map.Entry<String, Object> entry : pairs.entrySet()) {
                Object val = entry.getValue();
                if (val instanceof Integer) {
                    builder.putInt(entry.getKey(), (Integer)val);
                    continue;
                }
                if (val instanceof Double) {
                    builder.putDouble(entry.getKey(), (Double)val);
                    continue;
                }
                if (val instanceof Float) {
                    builder.putFloat(entry.getKey(), ((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    builder.putBoolean(entry.getKey(), (Boolean)val);
                    continue;
                }
                if (val instanceof Byte) {
                    builder.putByte(entry.getKey(), (Byte)val);
                    continue;
                }
                builder.putString(entry.getKey(), val.toString());
            }
            newTag = builder.build();
            compoundTag = compoundTag.createBuilder().put(baseKey, newTag).build();
        }
        return MythicItem.getItemHandler().setNBTData(itemStack, compoundTag);
    }

    private ItemStack setEnchantments(AbstractEntity entity, ItemStack stack) {
        if (this.enchantments == null || this.enchantments.isEmpty()) {
            return stack;
        }
        int maxEnchants = entity == null ? this.maxEnchantments.get() : this.maxEnchantments.get(entity);
        if (maxEnchants > 0) {
            Collections.shuffle(this.enchantments);
        }
        int enchants = 0;
        for (String s2 : this.enchantments) {
            int enchantLevel;
            Enchantment en;
            if (s2.contains(":")) {
                String[] part = s2.split(":");
                en = Enchantment.getByName((String)part[0]);
                enchantLevel = PlaceholderInt.of(part[1]).get(entity);
                if (enchantLevel == 0) {
                    continue;
                }
            } else {
                en = Enchantment.getByName((String)s2);
                enchantLevel = 1;
            }
            if (en == null || MythicMobs.inst().getCompatibility().getMythicEnchants().isPresent() && MythicMobs.inst().getCompatibility().getMythicEnchants().get().handleEnchant(stack, en, enchantLevel) || MythicMobs.inst().getCompatibility().getArtifacts().isPresent() && MythicMobs.inst().getCompatibility().getArtifacts().get().handleEnchant(stack, en, enchantLevel)) continue;
            if (stack.getType() != Material.ENCHANTED_BOOK) {
                stack.addUnsafeEnchantment(en, enchantLevel);
            } else {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
                esm.addStoredEnchant(en, enchantLevel, true);
                stack.setItemMeta((ItemMeta)esm);
            }
            if (maxEnchants <= 0 || ++enchants < maxEnchants) continue;
            break;
        }
        return stack;
    }

    private ItemMeta buildPotion(ItemMeta im) {
        PotionMeta pm = (PotionMeta)im;
        if (this.color != null) {
            try {
                String[] rgb = this.color.split(",");
                int r = Integer.parseInt(rgb[0]);
                int g2 = Integer.parseInt(rgb[1]);
                int b = Integer.parseInt(rgb[2]);
                pm.setColor(Color.fromRGB((int)r, (int)g2, (int)b));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.potionEffects != null) {
            pm.clearCustomEffects();
            for (String s2 : this.potionEffects) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 3) {
                        MythicLogger.errorItemConfig(this, this.config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s2);
                        continue;
                    }
                    PotionEffectType pet = PotionEffectType.getByName((String)sp[0].toUpperCase());
                    int duration = Integer.parseInt(sp[1]);
                    int level = Integer.parseInt(sp[2]);
                    PotionEffect p = new PotionEffect(pet, duration, level - 1, true);
                    pm.addCustomEffect(p, false);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s2);
                }
            }
        }
        return im;
    }

    private ItemMeta buildFirework(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        FireworkMeta pm = (FireworkMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.addEffect(builder.build());
        return im;
    }

    private ItemMeta buildFireworkCharge(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        FireworkEffectMeta pm = (FireworkEffectMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.setEffect(builder.build());
        return im;
    }

    private ItemMeta buildBanner(ItemMeta im) {
        if (this.color != null) {
            try {
                ((BannerMeta)im).setBaseColor(DyeColor.valueOf((String)this.color));
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "A banner color is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
            }
        }
        if (this.bannerLayers != null) {
            for (String s2 : this.bannerLayers) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 2) {
                        MythicLogger.errorItemConfig(this, this.config, "A banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                        continue;
                    }
                    DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                    PatternType pt = PatternType.valueOf((String)sp[1]);
                    Pattern p = new Pattern(dc, pt);
                    ((BannerMeta)im).addPattern(p);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                }
            }
        }
        return im;
    }

    private ItemMeta buildShield(ItemMeta im) {
        BlockStateMeta meta = (BlockStateMeta)im;
        Banner banner = (Banner)meta.getBlockState();
        if (this.color != null) {
            try {
                banner.setBaseColor(DyeColor.valueOf((String)this.color));
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "The shield color is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
            }
        }
        if (this.bannerLayers != null) {
            for (String s2 : this.bannerLayers) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 2) {
                        MythicLogger.errorItemConfig(this, this.config, "A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                        continue;
                    }
                    DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                    PatternType pt = PatternType.valueOf((String)sp[1]);
                    Pattern p = new Pattern(dc, pt);
                    banner.addPattern(p);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                }
            }
        }
        banner.update();
        meta.setBlockState((BlockState)banner);
        return meta;
    }

    private static ItemStack setLeatherColor(ItemStack item, MythicItem mi) {
        if (item.getType().equals((Object)Material.LEATHER_CHESTPLATE) || item.getType().equals((Object)Material.LEATHER_BOOTS) || item.getType().equals((Object)Material.LEATHER_LEGGINGS) || item.getType().equals((Object)Material.LEATHER_HELMET) || item.getType().equals((Object)Material.LEATHER_HORSE_ARMOR)) {
            ItemMeta im = item.getItemMeta();
            LeatherArmorMeta la = (LeatherArmorMeta)im;
            if (mi.color.contains(",")) {
                String[] rgb = mi.color.split(",");
                int r = Integer.parseInt(rgb[0]);
                int g2 = Integer.parseInt(rgb[1]);
                int b = Integer.parseInt(rgb[2]);
                la.setColor(Color.fromRGB((int)r, (int)g2, (int)b));
            } else {
                DyeColor dColor = DyeColor.valueOf((String)mi.color);
                la.setColor(dColor.getColor());
            }
            item.setItemMeta((ItemMeta)la);
        }
        return item;
    }

    private static ItemMeta buildSkull(SkullMeta meta, MythicItem mi) {
        if (mi.player != null) {
            meta.setOwner(mi.player);
        } else if (mi.skinTexture != null) {
            GameProfile profile = new GameProfile(mi.skinUUID, null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", mi.skinTexture));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else if (mi.skinURL != null) {
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + mi.skinURL + "\"}}}"))));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return meta;
    }

    @Override
    public int compareTo(MythicItem o) {
        return this.internalName.compareTo(o.getInternalName());
    }

    public String getMythicType() {
        return this.mythicType;
    }

    public void setMythicType(String mythicType) {
        this.mythicType = mythicType;
    }

    public Boolean getAppendType() {
        return this.appendType;
    }

    public void setAppendType(Boolean appendType) {
        this.appendType = appendType;
    }
}

