/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.items;

import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public class LegacyItemConverter {
    private static final Map<String, ItemMapping> LEGACY_MAPPINGS = new HashMap<String, ItemMapping>();
    private static final String INTERNAL_DELIMITER = ":";
    private static final ItemMapping[] MAPPINGS;

    private static Material getMaterialByKey(String key) {
        if (LEGACY_MAPPINGS.containsKey(key)) {
            if (ServerVersion.isBefore(MinecraftVersions.v1_15)) {
                return Material.valueOf((String)LEGACY_MAPPINGS.get(key).getLegacyName());
            }
            return Material.valueOf((String)LEGACY_MAPPINGS.get(key).getMaterialName());
        }
        return null;
    }

    public static Material getMaterial(String id, byte dv) {
        String key = id + INTERNAL_DELIMITER + dv;
        Material material = LegacyItemConverter.getMaterialByKey(key);
        if (material == null && dv > 0) {
            return LegacyItemConverter.getMaterialByKey(id + INTERNAL_DELIMITER + "0");
        }
        return material;
    }

    public static Material getMaterial(String id) {
        String key = id + INTERNAL_DELIMITER + "0";
        return LegacyItemConverter.getMaterialByKey(key);
    }

    public static Material getMaterial(int iid) {
        return LegacyItemConverter.getMaterial(String.valueOf(iid), (byte)0);
    }

    public static Material getMaterial(int iid, byte dv) {
        return LegacyItemConverter.getMaterial(String.valueOf(iid), dv);
    }

    static {
        for (ItemMapping mapping : MAPPINGS = new ItemMapping[]{new ItemMapping(0, "AIR"), new ItemMapping(1, "STONE"), new ItemMapping(1, 1, "STONE", "GRANITE"), new ItemMapping(1, 2, "STONE", "POLISHED_GRANITE"), new ItemMapping(1, 3, "STONE", "DIORITE"), new ItemMapping(1, 4, "STONE", "POLISHED_DIORITE"), new ItemMapping(1, 5, "STONE", "ANDESITE"), new ItemMapping(1, 6, "STONE", "POLISHED_ANDESITE"), new ItemMapping(2, "GRASS"), new ItemMapping(3, "DIRT"), new ItemMapping(3, 1, "DIRT", "COARSE_DIRT"), new ItemMapping(3, 2, "DIRT", "PODZOL"), new ItemMapping(4, "COBBLESTONE"), new ItemMapping(5, "WOOD", "OAK_PLANKS"), new ItemMapping(5, 1, "WOOD", "SPRUCE_PLANKS"), new ItemMapping(5, 2, "WOOD", "BIRCH_PLANKS"), new ItemMapping(5, 3, "WOOD", "JUNGLE_PLANKS"), new ItemMapping(5, 4, "WOOD", "ACACIA_PLANKS"), new ItemMapping(5, 5, "WOOD", "DARK_OAK_PLANKS"), new ItemMapping(6, "SAPLING", "OAK_SAPLING"), new ItemMapping(6, 1, "SAPLING", "SPRUCE_SAPLING"), new ItemMapping(6, 2, "SAPLING", "BIRCH_SAPLING"), new ItemMapping(6, 3, "SAPLING", "JUNGLE_SAPLING"), new ItemMapping(6, 4, "SAPLING", "ACACIA_SAPLING"), new ItemMapping(6, 5, "SAPLING", "DARK_OAK_SAPLING"), new ItemMapping(7, "BEDROCK"), new ItemMapping(8, "WATER", "FLOWING_WATER"), new ItemMapping(9, "STATIONARY_WATER", "WATER"), new ItemMapping(10, "LAVA", "FLOWING_LAVA"), new ItemMapping(11, "STATIONARY_LAVA", "LAVA"), new ItemMapping(12, "SAND"), new ItemMapping(12, 1, "SAND", "RED_SAND"), new ItemMapping(13, "GRAVEL"), new ItemMapping(14, "GOLD_ORE"), new ItemMapping(15, "IRON_ORE"), new ItemMapping(16, "COAL_ORE"), new ItemMapping(17, "LOG", "OAK_LOG"), new ItemMapping(17, 1, "LOG", "OAK_LOG"), new ItemMapping(17, 2, "LOG", "SPRUCE_LOG"), new ItemMapping(17, 3, "LOG", "BIRCH_LOG"), new ItemMapping(17, 4, "LOG", "JUNGLE_LOG"), new ItemMapping(17, 5, "LOG", "OAK_BARK"), new ItemMapping(17, 6, "LOG", "SPRUCE_BARK"), new ItemMapping(17, 7, "LOG", "BIRCH_BARK"), new ItemMapping(17, 8, "LOG", "JUNGLE_BARK"), new ItemMapping(18, "LEAVES", "OAK_LEAVES"), new ItemMapping(18, 1, "LEAVES", "SPRUCE_LEAVES"), new ItemMapping(18, 2, "LEAVES", "BIRCH_LEAVES"), new ItemMapping(18, 3, "LEAVES", "JUNGLE_LEAVES"), new ItemMapping(19, "SPONGE"), new ItemMapping(19, 1, "SPONGE", "WET_SPONGE"), new ItemMapping(20, "GLASS"), new ItemMapping(21, "LAPIS_ORE"), new ItemMapping(22, "LAPIS_BLOCK"), new ItemMapping(23, "DISPENSER"), new ItemMapping(24, "SANDSTONE"), new ItemMapping(24, 1, "SANDSTONE", "CHISLED_SANDSTONE"), new ItemMapping(24, 2, "SANDSTONE", "CUT_SANDSTONE"), new ItemMapping(25, "NOTE_BLOCK"), new ItemMapping(26, "BED_BLOCK", "BROWN_BED"), new ItemMapping(27, "POWERED_RAIL"), new ItemMapping(28, "DETECTOR_RAIL"), new ItemMapping(29, "PISTON_STICKY_BASE", "STICKY_PISTON"), new ItemMapping(30, "WEB", "COBWEB"), new ItemMapping(31, "LONG_GRASS", "DEAD_BUSH"), new ItemMapping(31, 1, "LONG_GRASS", "GRASS"), new ItemMapping(31, 2, "LONG_GRASS", "FERN"), new ItemMapping(32, "DEAD_BUSH"), new ItemMapping(33, "PISTON_BASE", "PISTON"), new ItemMapping(34, "PISTON_EXTENSION", "PISTON_HEAD"), new ItemMapping(35, "WOOL", "WHITE_WOOL"), new ItemMapping(35, 1, "WOOL", "ORANGE_WOOL"), new ItemMapping(35, 2, "WOOL", "MAGENTA_WOOL"), new ItemMapping(35, 3, "WOOL", "LIGHT_BLUE_WOOL"), new ItemMapping(35, 4, "WOOL", "YELLOW_WOOL"), new ItemMapping(35, 5, "WOOL", "LIME_WOOL"), new ItemMapping(35, 6, "WOOL", "PINK_WOOL"), new ItemMapping(35, 7, "WOOL", "GRAY_WOOL"), new ItemMapping(35, 8, "WOOL", "LIGHT_GRAY_WOOL"), new ItemMapping(35, 9, "WOOL", "CYAN_WOOL"), new ItemMapping(35, 10, "WOOL", "PURPLE_WOOL"), new ItemMapping(35, 11, "WOOL", "BLUE_WOOL"), new ItemMapping(35, 12, "WOOL", "BROWN_WOOL"), new ItemMapping(35, 13, "WOOL", "GREEN_WOOL"), new ItemMapping(35, 14, "WOOL", "RED_WOOL"), new ItemMapping(35, 15, "WOOL", "BLACK_WOOL"), new ItemMapping(36, "PISTON_MOVING_PIECE", "MOVING_PISTON"), new ItemMapping(37, "YELLOW_FLOWER", "DANDELION"), new ItemMapping(38, "RED_ROSE", "POPPY"), new ItemMapping(38, 1, "RED_ROSE", "BLUE_ORCHID"), new ItemMapping(38, 2, "RED_ROSE", "ALLIUM"), new ItemMapping(38, 3, "RED_ROSE", "AZURE_BLUET"), new ItemMapping(38, 4, "RED_ROSE", "RED_TULIP"), new ItemMapping(38, 5, "RED_ROSE", "ORANGE_TULIP"), new ItemMapping(38, 6, "RED_ROSE", "WHITE_TULIP"), new ItemMapping(38, 7, "RED_ROSE", "PINK_TULIP"), new ItemMapping(38, 8, "RED_ROSE", "OXEYE_DAISY"), new ItemMapping(39, "BROWN_MUSHROOM"), new ItemMapping(40, "RED_MUSHROOM"), new ItemMapping(41, "GOLD_BLOCK"), new ItemMapping(42, "IRON_BLOCK"), new ItemMapping(43, "DOUBLE_STEP", "STONE_SLAB"), new ItemMapping(43, 6, "DOUBLE_STEP", "SMOOTH_QUARTZ"), new ItemMapping(43, 8, "DOUBLE_STEP", "SMOOTH_STONE"), new ItemMapping(43, 9, "DOUBLE_STEP", "SMOOTH_SANDSTONE"), new ItemMapping(44, "STEP", "STONE_SLAB"), new ItemMapping(44, 1, "STEP", "SANDSTONE_SLAB"), new ItemMapping(44, 2, "STEP", "PETRIFIED_OAK_SLAB"), new ItemMapping(44, 3, "STEP", "COBBLESTONE_SLAB"), new ItemMapping(44, 4, "STEP", "BRICK_SLAB"), new ItemMapping(44, 5, "STEP", "STONE_BRICK_SLAB"), new ItemMapping(44, 6, "STEP", "NETHER_BRICK_SLAB"), new ItemMapping(44, 7, "STEP", "QUARTZ_SLAB"), new ItemMapping(45, "BRICK", "BRICKS"), new ItemMapping(46, "TNT"), new ItemMapping(47, "BOOKSHELF"), new ItemMapping(48, "MOSSY_COBBLESTONE"), new ItemMapping(49, "OBSIDIAN"), new ItemMapping(50, "TORCH"), new ItemMapping(50, 1, "TORCH", "WALL_TORCH"), new ItemMapping(50, 2, "TORCH", "WALL_TORCH"), new ItemMapping(50, 3, "TORCH", "WALL_TORCH"), new ItemMapping(50, 4, "TORCH", "WALL_TORCH"), new ItemMapping(50, 5, "TORCH"), new ItemMapping(51, "FIRE"), new ItemMapping(52, "MOB_SPAWNER"), new ItemMapping(53, "WOOD_STAIRS", "OAK_STAIRS"), new ItemMapping(54, "CHEST", "CHEST"), new ItemMapping(55, "REDSTONE_WIRE"), new ItemMapping(56, "DIAMOND_ORE"), new ItemMapping(57, "DIAMOND_BLOCK"), new ItemMapping(58, "WORKBENCH", "CRAFTING_TABLE"), new ItemMapping(59, "CROPS", "WHEAT"), new ItemMapping(60, "SOIL", "FARMLAND"), new ItemMapping(61, "FURNACE"), new ItemMapping(62, "BURNING_FURNACE", "FURNACE"), new ItemMapping(63, "SIGN_POST", "SIGN"), new ItemMapping(64, "WOODEN_DOOR", "OAK_DOOR"), new ItemMapping(65, "LADDER"), new ItemMapping(66, "RAILS", "RAIL"), new ItemMapping(67, "COBBLESTONE_STAIRS"), new ItemMapping(68, "WALL_SIGN"), new ItemMapping(69, "LEVER"), new ItemMapping(70, "STONE_PLATE", "STONE_PRESSURE_PLATE"), new ItemMapping(71, "IRON_DOOR_BLOCK", "IRON_DOOR"), new ItemMapping(72, "WOOD_PLATE", "OAK_PRESSURE_PLATE"), new ItemMapping(73, "REDSTONE_ORE"), new ItemMapping(74, "GLOWING_REDSTONE_ORE", "REDSTONE_ORE"), new ItemMapping(75, "REDSTONE_TORCH_OFF", "REDSTONE_TORCH"), new ItemMapping(76, "REDSTONE_TORCH_ON", "REDSTONE_TORCH"), new ItemMapping(76, 1, "REDSTONE_TORCH_ON", "REDSTONE_WALL_TORCH"), new ItemMapping(76, 2, "REDSTONE_TORCH_ON", "REDSTONE_WALL_TORCH"), new ItemMapping(76, 3, "REDSTONE_TORCH_ON", "REDSTONE_WALL_TORCH"), new ItemMapping(76, 4, "REDSTONE_TORCH_ON", "REDSTONE_WALL_TORCH"), new ItemMapping(76, 5, "REDSTONE_TORCH_ON", "REDSTONE_TORCH"), new ItemMapping(77, "STONE_BUTTON"), new ItemMapping(78, "SNOW"), new ItemMapping(79, "ICE"), new ItemMapping(80, "SNOW_BLOCK"), new ItemMapping(81, "CACTUS"), new ItemMapping(82, "CLAY"), new ItemMapping(83, "SUGAR_CANE_BLOCK", "SUGAR_CANE"), new ItemMapping(84, "JUKEBOX"), new ItemMapping(85, "FENCE", "OAK_FENCE"), new ItemMapping(86, "PUMPKIN", "CARVED_PUMPKIN"), new ItemMapping(87, "NETHERRACK"), new ItemMapping(88, "SOUL_SAND"), new ItemMapping(89, "GLOWSTONE"), new ItemMapping(90, "PORTAL", "NETHER_PORTAL"), new ItemMapping(91, "JACK_O_LANTERN"), new ItemMapping(92, "CAKE_BLOCK", "CAKE"), new ItemMapping(93, "DIODE_BLOCK_OFF", "REPEATER"), new ItemMapping(94, "DIODE_BLOCK_ON", "REPEATER"), new ItemMapping(95, "STAINED_GLASS", "WHITE_STAINED_GLASS"), new ItemMapping(95, 1, "STAINED_GLASS", "ORANGE_STAINED_GLASS"), new ItemMapping(95, 2, "STAINED_GLASS", "MAGENTA_STAINED_GLASS"), new ItemMapping(95, 3, "STAINED_GLASS", "LIGHT_BLUE_STAINED_GLASS"), new ItemMapping(95, 4, "STAINED_GLASS", "YELLOW_STAINED_GLASS"), new ItemMapping(95, 5, "STAINED_GLASS", "LIME_STAINED_GLASS"), new ItemMapping(95, 6, "STAINED_GLASS", "PINK_STAINED_GLASS"), new ItemMapping(95, 7, "STAINED_GLASS", "GRAY_STAINED_GLASS"), new ItemMapping(95, 8, "STAINED_GLASS", "LIGHT_GRAY_STAINED_GLASS"), new ItemMapping(95, 9, "STAINED_GLASS", "CYAN_STAINED_GLASS"), new ItemMapping(95, 10, "STAINED_GLASS", "PURPLE_STAINED_GLASS"), new ItemMapping(95, 11, "STAINED_GLASS", "BLUE_STAINED_GLASS"), new ItemMapping(95, 12, "STAINED_GLASS", "BROWN_STAINED_GLASS"), new ItemMapping(95, 13, "STAINED_GLASS", "GREEN_STAINED_GLASS"), new ItemMapping(95, 14, "STAINED_GLASS", "RED_STAINED_GLASS"), new ItemMapping(95, 15, "STAINED_GLASS", "BLACK_STAINED_GLASS"), new ItemMapping(96, "TRAP_DOOR", "OAK_TRAPDOOR"), new ItemMapping(97, "MONSTER_EGGS", "INFESTED_STONE"), new ItemMapping(97, 1, "MONSTER_EGGS", "INFESTED_COBLESTONE"), new ItemMapping(97, 2, "MONSTER_EGGS", "INFESTED_STONE_BRICKS"), new ItemMapping(97, 3, "MONSTER_EGGS", "INFESTED_MOSSY_STONE_BRICKS"), new ItemMapping(97, 4, "MONSTER_EGGS", "INFESTED_CRCKED_STONE_BRICKS"), new ItemMapping(97, 5, "MONSTER_EGGS", "INFESTED_CHISELED_STONE_BRICKS"), new ItemMapping(98, "SMOOTH_BRICK", "STONE_BRICKS"), new ItemMapping(98, 1, "SMOOTH_BRICK", "MOSSY_STONE_BRICKS"), new ItemMapping(98, 2, "SMOOTH_BRICK", "CRACKED_STONE_BRICKS"), new ItemMapping(98, 3, "SMOOTH_BRICK", "CHISELED_BRICKS"), new ItemMapping(99, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 1, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 2, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 3, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 4, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 5, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 6, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 7, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 8, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 9, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 10, "HUGE_MUSHROOM_1", "MUSHROOM_STEM"), new ItemMapping(99, 14, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(99, 15, "HUGE_MUSHROOM_1", "BROWN_MUSHROOM_BLOCK"), new ItemMapping(100, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 1, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 2, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 3, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 4, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 5, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 6, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 7, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 8, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 9, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 10, "HUGE_MUSHROOM_2", "MUSHROOM_STEM"), new ItemMapping(100, 14, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(100, 15, "HUGE_MUSHROOM_2", "RED_MUSHROOM_BLOCK"), new ItemMapping(101, "IRON_FENCE", "IRONBARS"), new ItemMapping(102, "THIN_GLASS", "GLASS_PANE"), new ItemMapping(103, "MELON_BLOCK"), new ItemMapping(104, "PUMPKIN_STEM"), new ItemMapping(105, "MELON_STEM"), new ItemMapping(106, "VINE"), new ItemMapping(107, "FENCE_GATE", "OAK_FENCE_GATE"), new ItemMapping(108, "BRICK_STAIRS"), new ItemMapping(109, "SMOOTH_STAIRS", "STONE_BRICK_STAIRS"), new ItemMapping(110, "MYCEL", "MYCELIUM"), new ItemMapping(111, "WATER_LILY", "LILY_PAD"), new ItemMapping(112, "NETHER_BRICK", "NETHER_BRICKS"), new ItemMapping(113, "NETHER_FENCE", "NETHER_BRICK_FENCE"), new ItemMapping(114, "NETHER_BRICK_STAIRS"), new ItemMapping(115, "NETHER_WARTS", "NETHER_WART"), new ItemMapping(116, "ENCHANTMENT_TABLE", "ENCHANTING_TABLE"), new ItemMapping(117, "BREWING_STAND"), new ItemMapping(118, "CAULDRON"), new ItemMapping(119, "ENDER_PORTAL", "END_PORTAL"), new ItemMapping(120, "ENDER_PORTAL_FRAME", "END_PORTAL_FRAME"), new ItemMapping(121, "ENDER_STONE", "END_STONE"), new ItemMapping(122, "DRAGON_EGG"), new ItemMapping(123, "REDSTONE_LAMP_OFF", "REDSTONE_LAMP"), new ItemMapping(124, "REDSTONE_LAMP_ON", "REDSTONE_LAMP"), new ItemMapping(125, "WOOD_DOUBLE_STEP", "OAK_SLAB"), new ItemMapping(125, 1, "WOOD_DOUBLE_STEP", "SPRUCE_SLAB"), new ItemMapping(125, 2, "WOOD_DOUBLE_STEP", "BIRCH_SLAB"), new ItemMapping(125, 3, "WOOD_DOUBLE_STEP", "JUNGLE_SLAB"), new ItemMapping(125, 4, "WOOD_DOUBLE_STEP", "ACACIA_SLAB"), new ItemMapping(125, 5, "WOOD_DOUBLE_STEP", "DARK_OAK_SLAB"), new ItemMapping(126, "WOOD_STEP", "OAK_SLAB"), new ItemMapping(126, 1, "WOOD_STEP", "SPRUCE_SLAB"), new ItemMapping(126, 2, "WOOD_STEP", "BIRCH_SLAB"), new ItemMapping(126, 3, "WOOD_STEP", "JUNGLE_SLAB"), new ItemMapping(126, 4, "WOOD_STEP", "ACACIA_SLAB"), new ItemMapping(126, 5, "WOOD_STEP", "DARK_OAK_SLAB"), new ItemMapping(127, "COCOA"), new ItemMapping(128, "SANDSTONE_STAIRS"), new ItemMapping(129, "EMERALD_ORE"), new ItemMapping(130, "ENDER_CHEST"), new ItemMapping(131, "TRIPWIRE_HOOK"), new ItemMapping(132, "TRIPWIRE"), new ItemMapping(133, "EMERALD_BLOCK"), new ItemMapping(134, "SPRUCE_WOOD_STAIRS", "SPRUCE_STAIRS"), new ItemMapping(135, "BIRCH_WOOD_STAIRS", "BIRCH_STAIRS"), new ItemMapping(136, "JUNGLE_WOOD_STAIRS", "JUNGLE_STAIRS"), new ItemMapping(137, "COMMAND", "COMMAND_BLOCK"), new ItemMapping(138, "BEACON"), new ItemMapping(139, "COBBLE_WALL", "COBBLESTONE_WALL"), new ItemMapping(139, 1, "COBBLE_WALL", "MOSSY_COBBLESTONE_WALL"), new ItemMapping(140, "FLOWER_POT"), new ItemMapping(141, "CARROT", "CARROTS"), new ItemMapping(142, "POTATO", "POTATOES"), new ItemMapping(143, "WOOD_BUTTON", "OAK_BUTTON"), new ItemMapping(144, "SKULL", "SKELETON_SKULL"), new ItemMapping(144, 1, "SKULL", "SKELETON_WALL_SKULL"), new ItemMapping(144, 2, "SKULL", "SKELETON_WALL_SKULL"), new ItemMapping(144, 3, "SKULL", "SKELETON_WALL_SKULL"), new ItemMapping(144, 4, "SKULL", "SKELETON_WALL_SKULL"), new ItemMapping(144, 5, "SKULL", "SKELETON_WALL_SKULL"), new ItemMapping(145, "ANVIL"), new ItemMapping(145, 1, "ANVIL", "CHIPPED_ANVIL"), new ItemMapping(145, 2, "ANVIL", "DAMAGED_ANVIL"), new ItemMapping(146, "TRAPPED_CHEST"), new ItemMapping(147, "GOLD_PLATE", "LIGHT_WEIGHTED_PRESSURE_PLATE"), new ItemMapping(148, "IRON_PLATE", "HEAVY_WEIGHTED_PRESSURE_PLATE"), new ItemMapping(149, "REDSTONE_COMPARATOR_OFF", "COMPARATOR"), new ItemMapping(150, "REDSTONE_COMPARATOR_ON", "COMPARATOR"), new ItemMapping(151, "DAYLIGHT_DETECTOR"), new ItemMapping(152, "REDSTONE_BLOCK"), new ItemMapping(153, "QUARTZ_ORE", "NETHER_QUARTZ_ORE"), new ItemMapping(154, "HOPPER"), new ItemMapping(155, "QUARTZ_BLOCK"), new ItemMapping(156, "QUARTZ_STAIRS"), new ItemMapping(157, "ACTIVATOR_RAIL"), new ItemMapping(158, "DROPPER"), new ItemMapping(159, "STAINED_CLAY", "WHITE_TERRACOTTA"), new ItemMapping(159, 1, "STAINED_CLAY", "ORANGE_TERRACOTTA"), new ItemMapping(159, 2, "STAINED_CLAY", "MAGENTA_TERRACOTTA"), new ItemMapping(159, 3, "STAINED_CLAY", "LIGHT_BLUE_TERRACOTTA"), new ItemMapping(159, 4, "STAINED_CLAY", "YELLOW_TERRACOTTA"), new ItemMapping(159, 5, "STAINED_CLAY", "LIME_TERRACOTTA"), new ItemMapping(159, 6, "STAINED_CLAY", "PINK_TERRACOTTA"), new ItemMapping(159, 7, "STAINED_CLAY", "GRAY_TERRACOTTA"), new ItemMapping(159, 8, "STAINED_CLAY", "LIGHT_GRAY_TERRACOTTA"), new ItemMapping(159, 9, "STAINED_CLAY", "CYAN_TERRACOTTA"), new ItemMapping(159, 10, "STAINED_CLAY", "PURPLE_TERRACOTTA"), new ItemMapping(159, 11, "STAINED_CLAY", "BLUE_TERRACOTTA"), new ItemMapping(159, 12, "STAINED_CLAY", "BROWN_TERRACOTTA"), new ItemMapping(159, 13, "STAINED_CLAY", "GREEN_TERRACOTTA"), new ItemMapping(159, 14, "STAINED_CLAY", "RED_TERRACOTTA"), new ItemMapping(159, 15, "STAINED_CLAY", "BLACK_TERRACOTTA"), new ItemMapping(160, "STAINED_GLASS_PANE", "WHITE_STAINED_GLASS_PANE"), new ItemMapping(160, 1, "STAINED_GLASS_PANE", "ORANGE_STAINED_GLASS_PANE"), new ItemMapping(160, 2, "STAINED_GLASS_PANE", "MAGENTA_STAINED_GLASS_PANE"), new ItemMapping(160, 3, "STAINED_GLASS_PANE", "LIGHT_BLUE_STAINED_GLASS_PANE"), new ItemMapping(160, 4, "STAINED_GLASS_PANE", "YELLOW_STAINED_GLASS_PANE"), new ItemMapping(160, 5, "STAINED_GLASS_PANE", "LIME_STAINED_GLASS_PANE"), new ItemMapping(160, 6, "STAINED_GLASS_PANE", "PINK_STAINED_GLASS_PANE"), new ItemMapping(160, 7, "STAINED_GLASS_PANE", "GRAY_STAINED_GLASS_PANE"), new ItemMapping(160, 8, "STAINED_GLASS_PANE", "LIGHT_GRAY_STAINED_GLASS_PANE"), new ItemMapping(160, 9, "STAINED_GLASS_PANE", "CYAN_STAINED_GLASS_PANE"), new ItemMapping(160, 10, "STAINED_GLASS_PANE", "PURPLE_STAINED_GLASS_PANE"), new ItemMapping(160, 11, "STAINED_GLASS_PANE", "BLUE_STAINED_GLASS_PANE"), new ItemMapping(160, 12, "STAINED_GLASS_PANE", "BROWN_STAINED_GLASS_PANE"), new ItemMapping(160, 13, "STAINED_GLASS_PANE", "GREEN_STAINED_GLASS_PANE"), new ItemMapping(160, 14, "STAINED_GLASS_PANE", "RED_STAINED_GLASS_PANE"), new ItemMapping(160, 15, "STAINED_GLASS_PANE", "BLACK_STAINED_GLASS_PANE"), new ItemMapping(161, "LEAVES_2", "ACACIA_LEAVES"), new ItemMapping(161, 1, "LEAVES_2", "DARK_OAK_LEAVES"), new ItemMapping(162, "LOG_2", "ACACIA_LOG"), new ItemMapping(162, 1, "LOG_2", "SPRUCE_LOG"), new ItemMapping(162, 2, "LOG_2", "BIRCH_LOG"), new ItemMapping(162, 3, "LOG_2", "JUNGLE_LOG"), new ItemMapping(163, "ACACIA_STAIRS", "ACACIA_STAIRS"), new ItemMapping(164, "DARK_OAK_STAIRS", "DARK_OAK_STAIRS"), new ItemMapping(165, "SLIME_BLOCK", "SLIME_BLOCK"), new ItemMapping(166, "BARRIER", "BARRIER"), new ItemMapping(167, "IRON_TRAPDOOR", "IRON_TRAPDOOR"), new ItemMapping(168, "PRISMARINE"), new ItemMapping(168, 1, "PRISMARINE", "PRISMARINE_BRICKS"), new ItemMapping(168, 2, "PRISMARINE", "DARK_PRISMARINE"), new ItemMapping(169, "SEA_LANTERN"), new ItemMapping(170, "HAY_BLOCK"), new ItemMapping(171, "CARPET", "WHITE_CARPET"), new ItemMapping(171, 1, "CARPET", "ORANGE_CARPET"), new ItemMapping(171, 2, "CARPET", "MAGENTA_CARPET"), new ItemMapping(171, 3, "CARPET", "LIGHT_BLUE_CARPET"), new ItemMapping(171, 4, "CARPET", "YELLOW_CARPET"), new ItemMapping(171, 5, "CARPET", "LIME_CARPET"), new ItemMapping(171, 6, "CARPET", "PINK_CARPET"), new ItemMapping(171, 7, "CARPET", "GRAY_CARPET"), new ItemMapping(171, 8, "CARPET", "LIGHT_GRAY_CARPET"), new ItemMapping(171, 9, "CARPET", "CYAN_CARPET"), new ItemMapping(171, 10, "CARPET", "PURPLE_CARPET"), new ItemMapping(171, 11, "CARPET", "BLUE_CARPET"), new ItemMapping(171, 12, "CARPET", "BROWN_CARPET"), new ItemMapping(171, 13, "CARPET", "GREEN_CARPET"), new ItemMapping(171, 14, "CARPET", "RED_CARPET"), new ItemMapping(171, 15, "CARPET", "BLACK_CARPET"), new ItemMapping(172, "HARD_CLAY", "TERRACOTTA"), new ItemMapping(173, "COAL_BLOCK"), new ItemMapping(174, "PACKED_ICE"), new ItemMapping(175, "DOUBLE_PLANT", "SUNFLOWER"), new ItemMapping(175, 1, "DOUBLE_PLANT", "LILAC"), new ItemMapping(175, 2, "DOUBLE_PLANT", "TALL_GRASS"), new ItemMapping(175, 3, "DOUBLE_PLANT", "LARGE_FERN"), new ItemMapping(175, 4, "DOUBLE_PLANT", "ROSE_BUSH"), new ItemMapping(175, 5, "DOUBLE_PLANT", "PEONY"), new ItemMapping(176, "STANDING_BANNER", "WHITE_BANNER"), new ItemMapping(177, "WALL_BANNER", "WHITE_WALL_BANNER"), new ItemMapping(178, "DAYLIGHT_DETECTOR_INVERTED", "DAYLIGHT_DETECTOR"), new ItemMapping(179, "RED_SANDSTONE", "RED_SANDSTONE"), new ItemMapping(179, 1, "RED_SANDSTONE", "CHISELED_RED_SANDSTONE"), new ItemMapping(179, 2, "RED_SANDSTONE", "CUT_RED_SANDSTONE"), new ItemMapping(180, "RED_SANDSTONE_STAIRS"), new ItemMapping(181, "DOUBLE_STONE_SLAB2", "RED_SANDSTONE_SLAB"), new ItemMapping(181, 8, "DOUBLE_STONE_SLAB2", "SMOOTH_RED_SANDSTONE"), new ItemMapping(182, "STONE_SLAB2", "RED_SANDSTONE_SLAB"), new ItemMapping(183, "SPRUCE_FENCE_GATE"), new ItemMapping(184, "BIRCH_FENCE_GATE"), new ItemMapping(185, "JUNGLE_FENCE_GATE"), new ItemMapping(186, "DARK_OAK_FENCE_GATE"), new ItemMapping(187, "ACACIA_FENCE_GATE"), new ItemMapping(188, "SPRUCE_FENCE"), new ItemMapping(189, "BIRCH_FENCE"), new ItemMapping(190, "JUNGLE_FENCE"), new ItemMapping(191, "DARK_OAK_FENCE"), new ItemMapping(192, "ACACIA_FENCE"), new ItemMapping(193, "SPRUCE_DOOR"), new ItemMapping(194, "BIRCH_DOOR"), new ItemMapping(195, "JUNGLE_DOOR"), new ItemMapping(196, "ACACIA_DOOR"), new ItemMapping(197, "DARK_OAK_DOOR"), new ItemMapping(198, "END_ROD"), new ItemMapping(199, "CHORUS_PLANT"), new ItemMapping(200, "CHORUS_FLOWER"), new ItemMapping(201, "PURPUR_BLOCK"), new ItemMapping(202, "PURPUR_PILLAR"), new ItemMapping(203, "PURPUR_STAIRS"), new ItemMapping(204, "PURPUR_DOUBLE_SLAB", "PURPUR_SLAB"), new ItemMapping(205, "PURPUR_SLAB"), new ItemMapping(206, "END_BRICKS", "END_STONE_BRICKS"), new ItemMapping(207, "BEETROOT_BLOCK", "BEETROOTS"), new ItemMapping(208, "GRASS_PATH"), new ItemMapping(209, "END_GATEWAY"), new ItemMapping(210, "COMMAND_REPEATING", "REPEATING_COMMAND_BLOCK"), new ItemMapping(211, "COMMAND_CHAIN", "CHAIN_COMMAND_BLOCK"), new ItemMapping(212, "FROSTED_ICE"), new ItemMapping(213, "MAGMA", "MAGMA_BLOCK"), new ItemMapping(214, "NETHER_WART_BLOCK"), new ItemMapping(215, "RED_NETHER_BRICK", "RED_NETHER_BRICKS"), new ItemMapping(216, "BONE_BLOCK"), new ItemMapping(217, "STRUCTURE_VOID"), new ItemMapping(218, "OBSERVER"), new ItemMapping(219, "WHITE_SHULKER_BOX"), new ItemMapping(220, "ORANGE_SHULKER_BOX"), new ItemMapping(221, "MAGENTA_SHULKER_BOX"), new ItemMapping(222, "LIGHT_BLUE_SHULKER_BOX"), new ItemMapping(223, "YELLOW_SHULKER_BOX"), new ItemMapping(224, "LIME_SHULKER_BOX"), new ItemMapping(225, "PINK_SHULKER_BOX"), new ItemMapping(226, "GRAY_SHULKER_BOX"), new ItemMapping(227, "SILVER_SHULKER_BOX", "LIGHT_GRAY_SHULKER_BOX"), new ItemMapping(228, "CYAN_SHULKER_BOX"), new ItemMapping(229, "PURPLE_SHULKER_BOX"), new ItemMapping(230, "BLUE_SHULKER_BOX"), new ItemMapping(231, "BROWN_SHULKER_BOX"), new ItemMapping(232, "GREEN_SHULKER_BOX"), new ItemMapping(233, "RED_SHULKER_BOX"), new ItemMapping(234, "BLACK_SHULKER_BOX"), new ItemMapping(235, "WHITE_GLAZED_TERRACOTTA"), new ItemMapping(236, "ORANGE_GLAZED_TERRACOTTA"), new ItemMapping(237, "MAGENTA_GLAZED_TERRACOTTA"), new ItemMapping(238, "LIGHT_BLUE_GLAZED_TERRACOTTA"), new ItemMapping(239, "YELLOW_GLAZED_TERRACOTTA"), new ItemMapping(240, "LIME_GLAZED_TERRACOTTA"), new ItemMapping(241, "PINK_GLAZED_TERRACOTTA"), new ItemMapping(242, "GRAY_GLAZED_TERRACOTTA"), new ItemMapping(243, "SILVER_GLAZED_TERRACOTTA", "LIGHT_GRAY_GLAZED_TERRACOTTA"), new ItemMapping(244, "CYAN_GLAZED_TERRACOTTA"), new ItemMapping(245, "PURPLE_GLAZED_TERRACOTTA"), new ItemMapping(246, "BLUE_GLAZED_TERRACOTTA"), new ItemMapping(247, "BROWN_GLAZED_TERRACOTTA"), new ItemMapping(248, "GREEN_GLAZED_TERRACOTTA"), new ItemMapping(249, "RED_GLAZED_TERRACOTTA"), new ItemMapping(250, "BLACK_GLAZED_TERRACOTTA"), new ItemMapping(251, "CONCRETE", "WHITE_CONCRETE"), new ItemMapping(251, 1, "CONCRETE", "ORANGE_CONCRETE"), new ItemMapping(251, 2, "CONCRETE", "MAGENTA_CONCRETE"), new ItemMapping(251, 3, "CONCRETE", "LIGHT_BLUE_CONCRETE"), new ItemMapping(251, 4, "CONCRETE", "YELLOW_CONCRETE"), new ItemMapping(251, 5, "CONCRETE", "LIME_CONCRETE"), new ItemMapping(251, 6, "CONCRETE", "PINK_CONCRETE"), new ItemMapping(251, 7, "CONCRETE", "GRAY_CONCRETE"), new ItemMapping(251, 8, "CONCRETE", "LIGHT_GRAY_CONCRETE"), new ItemMapping(251, 9, "CONCRETE", "CYAN_CONCRETE"), new ItemMapping(251, 10, "CONCRETE", "PURPLE_CONCRETE"), new ItemMapping(251, 11, "CONCRETE", "BLUE_CONCRETE"), new ItemMapping(251, 12, "CONCRETE", "BROWN_CONCRETE"), new ItemMapping(251, 13, "CONCRETE", "GREEN_CONCRETE"), new ItemMapping(251, 14, "CONCRETE", "RED_CONCRETE"), new ItemMapping(251, 15, "CONCRETE", "BLACK_CONCRETE"), new ItemMapping(252, "CONCRETE_POWDER", "WHITE_CONCRETE_POWDER"), new ItemMapping(252, 1, "CONCRETE_POWDER", "ORANGE_CONCRETE_POWDER"), new ItemMapping(252, 2, "CONCRETE_POWDER", "MAGENTA_CONCRETE_POWDER"), new ItemMapping(252, 3, "CONCRETE_POWDER", "LIGHT_BLUE_CONCRETE_POWDER"), new ItemMapping(252, 4, "CONCRETE_POWDER", "YELLOW_CONCRETE_POWDER"), new ItemMapping(252, 5, "CONCRETE_POWDER", "LIME_CONCRETE_POWDER"), new ItemMapping(252, 6, "CONCRETE_POWDER", "PINK_CONCRETE_POWDER"), new ItemMapping(252, 7, "CONCRETE_POWDER", "GRAY_CONCRETE_POWDER"), new ItemMapping(252, 8, "CONCRETE_POWDER", "LIGHT_GRAY_CONCRETE_POWDER"), new ItemMapping(252, 9, "CONCRETE_POWDER", "CYAN_CONCRETE_POWDER"), new ItemMapping(252, 10, "CONCRETE_POWDER", "PURPLE_CONCRETE_POWDER"), new ItemMapping(252, 11, "CONCRETE_POWDER", "BLUE_CONCRETE_POWDER"), new ItemMapping(252, 12, "CONCRETE_POWDER", "BROWN_CONCRETE_POWDER"), new ItemMapping(252, 13, "CONCRETE_POWDER", "GREEN_CONCRETE_POWDER"), new ItemMapping(252, 14, "CONCRETE_POWDER", "RED_CONCRETE_POWDER"), new ItemMapping(252, 15, "CONCRETE_POWDER", "BLACK_CONCRETE_POWDER"), new ItemMapping(255, "STRUCTURE_BLOCK"), new ItemMapping(256, "IRON_SPADE", "IRON_SHOVEL"), new ItemMapping(257, "IRON_PICKAXE"), new ItemMapping(258, "IRON_AXE"), new ItemMapping(259, "FLINT_AND_STEEL"), new ItemMapping(260, "APPLE"), new ItemMapping(261, "BOW"), new ItemMapping(262, "ARROW"), new ItemMapping(263, "COAL"), new ItemMapping(263, 1, "COAL", "CHARCOAL"), new ItemMapping(264, "DIAMOND"), new ItemMapping(265, "IRON_INGOT"), new ItemMapping(266, "GOLD_INGOT"), new ItemMapping(267, "IRON_SWORD"), new ItemMapping(268, "WOOD_SWORD", "WOODEN_SWORD"), new ItemMapping(269, "WOOD_SPADE", "WOODEN_SHOVEL"), new ItemMapping(270, "WOOD_PICKAXE", "WOODEN_PICKAXE"), new ItemMapping(271, "WOOD_AXE", "WOODEN_AXE"), new ItemMapping(272, "STONE_SWORD"), new ItemMapping(273, "STONE_SPADE", "STONE_SHOVEL"), new ItemMapping(274, "STONE_PICKAXE"), new ItemMapping(275, "STONE_AXE"), new ItemMapping(276, "DIAMOND_SWORD"), new ItemMapping(277, "DIAMOND_SPADE", "DIAMOND_SHOVEL"), new ItemMapping(278, "DIAMOND_PICKAXE"), new ItemMapping(279, "DIAMOND_AXE"), new ItemMapping(280, "STICK"), new ItemMapping(281, "BOWL"), new ItemMapping(282, "MUSHROOM_SOUP", "MUSHROOM_STEW"), new ItemMapping(283, "GOLD_SWORD", "GOLDEN_SWORD"), new ItemMapping(284, "GOLD_SPADE", "GOLDEN_SHOVEL"), new ItemMapping(285, "GOLD_PICKAXE", "GOLDEN_PICKAXE"), new ItemMapping(286, "GOLD_AXE", "GOLDEN_AXE"), new ItemMapping(287, "STRING"), new ItemMapping(288, "FEATHER"), new ItemMapping(289, "SULPHUR", "GUNPOWDER"), new ItemMapping(290, "WOOD_HOE", "WOODEN_HOE"), new ItemMapping(291, "STONE_HOE"), new ItemMapping(292, "IRON_HOE"), new ItemMapping(293, "DIAMOND_HOE"), new ItemMapping(294, "GOLD_HOE", "GOLDEN_HOE"), new ItemMapping(295, "SEEDS", "WHEAT_SEEDS"), new ItemMapping(296, "WHEAT"), new ItemMapping(297, "BREAD"), new ItemMapping(298, "LEATHER_HELMET"), new ItemMapping(299, "LEATHER_CHESTPLATE"), new ItemMapping(300, "LEATHER_LEGGINGS"), new ItemMapping(301, "LEATHER_BOOTS"), new ItemMapping(302, "CHAINMAIL_HELMET"), new ItemMapping(303, "CHAINMAIL_CHESTPLATE"), new ItemMapping(304, "CHAINMAIL_LEGGINGS"), new ItemMapping(305, "CHAINMAIL_BOOTS"), new ItemMapping(306, "IRON_HELMET"), new ItemMapping(307, "IRON_CHESTPLATE"), new ItemMapping(308, "IRON_LEGGINGS"), new ItemMapping(309, "IRON_BOOTS"), new ItemMapping(310, "DIAMOND_HELMET"), new ItemMapping(311, "DIAMOND_CHESTPLATE"), new ItemMapping(312, "DIAMOND_LEGGINGS"), new ItemMapping(313, "DIAMOND_BOOTS"), new ItemMapping(314, "GOLD_HELMET", "GOLDEN_HELMET"), new ItemMapping(315, "GOLD_CHESTPLATE", "GOLDEN_CHESTPLATE"), new ItemMapping(316, "GOLD_LEGGINGS", "GOLDEN_LEGGINGS"), new ItemMapping(317, "GOLD_BOOTS", "GOLDEN_BOOTS"), new ItemMapping(318, "FLINT"), new ItemMapping(319, "PORK", "PORKCHOP"), new ItemMapping(320, "GRILLED_PORK", "COOKED_PORKCHOP"), new ItemMapping(321, "PAINTING"), new ItemMapping(322, "GOLDEN_APPLE", "GOLDEN_APPLE"), new ItemMapping(322, 1, "GOLDEN_APPLE", "ENCHANTED_GOLDEN_APPLE"), new ItemMapping(323, "SIGN"), new ItemMapping(324, "WOOD_DOOR", "OAK_DOOR"), new ItemMapping(325, "BUCKET"), new ItemMapping(326, "WATER_BUCKET"), new ItemMapping(327, "LAVA_BUCKET"), new ItemMapping(328, "MINECART"), new ItemMapping(329, "SADDLE"), new ItemMapping(330, "IRON_DOOR"), new ItemMapping(331, "REDSTONE"), new ItemMapping(332, "SNOW_BALL", "SNOWBALL"), new ItemMapping(333, "BOAT", "OAK_BOAT"), new ItemMapping(334, "LEATHER"), new ItemMapping(335, "MILK_BUCKET"), new ItemMapping(336, "CLAY_BRICK", "BRICK"), new ItemMapping(337, "CLAY_BALL"), new ItemMapping(338, "SUGAR_CANE"), new ItemMapping(339, "PAPER"), new ItemMapping(340, "BOOK"), new ItemMapping(341, "SLIME_BALL"), new ItemMapping(342, "STORAGE_MINECART", "CHEST_MINECART"), new ItemMapping(343, "POWERED_MINECART", "FURNACE_MINECART"), new ItemMapping(344, "EGG"), new ItemMapping(345, "COMPASS"), new ItemMapping(346, "FISHING_ROD"), new ItemMapping(347, "WATCH", "CLOCK"), new ItemMapping(348, "GLOWSTONE_DUST"), new ItemMapping(349, "RAW_FISH", "COD"), new ItemMapping(349, 1, "RAW_FISH", "SALMON"), new ItemMapping(349, 2, "RAW_FISH", "CLOWNFISH"), new ItemMapping(349, 3, "RAW_FISH", "PUFFERFISH"), new ItemMapping(350, "COOKED_FISH", "COOKED_COD"), new ItemMapping(350, 1, "COOKED_FISH", "COOKED_SALMON"), new ItemMapping(351, "INK_SACK", "INK_SAC"), new ItemMapping(351, 1, "INK_SACK", "ROSE_RED"), new ItemMapping(351, 2, "INK_SACK", "CACTUS_GREEN"), new ItemMapping(351, 3, "INK_SACK", "COCOA_BEANS"), new ItemMapping(351, 4, "INK_SACK", "LAPIS_LAZULI"), new ItemMapping(351, 5, "INK_SACK", "PURPLE_DYE"), new ItemMapping(351, 6, "INK_SACK", "CYAN_DYE"), new ItemMapping(351, 7, "INK_SACK", "LIGHT_GRAY_DYE"), new ItemMapping(351, 8, "INK_SACK", "GRAY_DYE"), new ItemMapping(351, 9, "INK_SACK", "PINK_DYE"), new ItemMapping(351, 10, "INK_SACK", "LIME_DYE"), new ItemMapping(351, 11, "INK_SACK", "DANDELION_YELLOW"), new ItemMapping(351, 12, "INK_SACK", "LIGHT_BLUE_DYE"), new ItemMapping(351, 13, "INK_SACK", "MAGENTA_DYE"), new ItemMapping(351, 14, "INK_SACK", "ORANGE_DYE"), new ItemMapping(351, 15, "INK_SACK", "BONE_MEAL"), new ItemMapping(352, "BONE"), new ItemMapping(353, "SUGAR", "SUGAR"), new ItemMapping(354, "CAKE", "CAKE"), new ItemMapping(355, "BED", "WHITE_BED"), new ItemMapping(355, 1, "BED", "ORANGE_BED"), new ItemMapping(355, 2, "BED", "MAGENTA_BED"), new ItemMapping(355, 3, "BED", "LIGHT_BLUE_BED"), new ItemMapping(355, 4, "BED", "YELLOW_BED"), new ItemMapping(355, 5, "BED", "LIME_BED"), new ItemMapping(355, 6, "BED", "PINK_BED"), new ItemMapping(355, 7, "BED", "GRAY_BED"), new ItemMapping(355, 8, "BED", "LIGHT_GRAY_BED"), new ItemMapping(355, 9, "BED", "CYAN_BED"), new ItemMapping(355, 10, "BED", "PURPLE_BED"), new ItemMapping(355, 11, "BED", "BLUE_BED"), new ItemMapping(355, 12, "BED", "BROWN_BED"), new ItemMapping(355, 13, "BED", "GREEN_BED"), new ItemMapping(355, 14, "BED", "RED_BED"), new ItemMapping(355, 15, "BED", "BLACK_BED"), new ItemMapping(356, "DIODE", "REPEATER"), new ItemMapping(357, "COOKIE", "COOKIE"), new ItemMapping(358, "MAP"), new ItemMapping(359, "SHEARS"), new ItemMapping(360, "MELON", "MELON"), new ItemMapping(361, "PUMPKIN_SEEDS", "PUMPKIN_SEEDS"), new ItemMapping(362, "MELON_SEEDS", "MELON_SEEDS"), new ItemMapping(363, "RAW_BEEF", "BEEF"), new ItemMapping(364, "COOKED_BEEF"), new ItemMapping(365, "RAW_CHICKEN", "CHICKEN"), new ItemMapping(366, "COOKED_CHICKEN"), new ItemMapping(367, "ROTTEN_FLESH"), new ItemMapping(368, "ENDER_PEARL"), new ItemMapping(369, "BLAZE_ROD"), new ItemMapping(370, "GHAST_TEAR"), new ItemMapping(371, "GOLD_NUGGET"), new ItemMapping(372, "NETHER_STALK", "NETHER_WART"), new ItemMapping(373, "POTION", "POTION"), new ItemMapping(374, "GLASS_BOTTLE"), new ItemMapping(375, "SPIDER_EYE"), new ItemMapping(376, "FERMENTED_SPIDER_EYE"), new ItemMapping(377, "BLAZE_POWDER"), new ItemMapping(378, "MAGMA_CREAM"), new ItemMapping(379, "BREWING_STAND_ITEM", "BREWING_STAND"), new ItemMapping(380, "CAULDRON_ITEM", "CAULDRON"), new ItemMapping(381, "EYE_OF_ENDER", "ENDER_EYE"), new ItemMapping(382, "SPECKLED_MELON"), new ItemMapping(383, "MONSTER_EGG", "PIG_SPAWN_EGG"), new ItemMapping(383, 4, "MONSTER_EGG", "ELDER_GUARDIAN_SPAWN_EGG"), new ItemMapping(383, 5, "MONSTER_EGG", "WITHER_SKELETON_SPAWN_EGG"), new ItemMapping(383, 6, "MONSTER_EGG", "STRAY_SPAWN_EGG"), new ItemMapping(383, 23, "MONSTER_EGG", "HUSK_SPAWN_EGG"), new ItemMapping(383, 27, "MONSTER_EGG", "ZOMBE_VILLAGER_SPAWN_EGG"), new ItemMapping(383, 28, "MONSTER_EGG", "SKELETON_HORSE_SPAWN_EGG"), new ItemMapping(383, 29, "MONSTER_EGG", "ZOMBIE_HORSE_SPAWN_EGG"), new ItemMapping(383, 31, "MONSTER_EGG", "DONKEY_SPAWN_EGG"), new ItemMapping(383, 32, "MONSTER_EGG", "MULE_SPAWN_EGG"), new ItemMapping(383, 34, "MONSTER_EGG", "EVOCATION_ILLAGER_SPAWN_EGG"), new ItemMapping(383, 35, "MONSTER_EGG", "VEX_SPAWN_EGG"), new ItemMapping(383, 36, "MONSTER_EGG", "VINDICATION_ILLAGER_SPAWN_EGG"), new ItemMapping(383, 50, "MONSTER_EGG", "CREEPER_SPAWN_EGG"), new ItemMapping(383, 51, "MONSTER_EGG", "SKELETON_SPAWN_EGG"), new ItemMapping(383, 52, "MONSTER_EGG", "SPIDER_SPAWN_EGG"), new ItemMapping(383, 54, "MONSTER_EGG", "ZOMBIE_SPAWN_EGG"), new ItemMapping(383, 55, "MONSTER_EGG", "SLIME_SPAWN_EGG"), new ItemMapping(383, 56, "MONSTER_EGG", "GHAST_SPAWN_EGG"), new ItemMapping(383, 57, "MONSTER_EGG", "ZOMBIE_PIGMAN_SPAWN_EGG"), new ItemMapping(383, 58, "MONSTER_EGG", "ENDERMAN_SPAWN_EGG"), new ItemMapping(383, 59, "MONSTER_EGG", "CAVE_SPIDER_SPAWN_EGG"), new ItemMapping(383, 60, "MONSTER_EGG", "SILVERFISH_SPAWN_EGG"), new ItemMapping(383, 61, "MONSTER_EGG", "BLAZE_SPAWN_EGG"), new ItemMapping(383, 62, "MONSTER_EGG", "MAGMA_CUBE_SPAWN_EGG"), new ItemMapping(383, 65, "MONSTER_EGG", "BAT_SPAWN_EGG"), new ItemMapping(383, 66, "MONSTER_EGG", "WITCH_SPAWN_EGG"), new ItemMapping(383, 67, "MONSTER_EGG", "ENDERMITE_SPAWN_EGG"), new ItemMapping(383, 68, "MONSTER_EGG", "GUARDIAN_SPAWN_EGG"), new ItemMapping(383, 69, "MONSTER_EGG", "SHULKER_SPAWN_EGG"), new ItemMapping(383, 90, "MONSTER_EGG", "PIG_SPAWN_EGG"), new ItemMapping(383, 91, "MONSTER_EGG", "SHEEP_SPAWN_EGG"), new ItemMapping(383, 92, "MONSTER_EGG", "COW_SPAWN_EGG"), new ItemMapping(383, 93, "MONSTER_EGG", "CHICKEN_SPAWN_EGG"), new ItemMapping(383, 94, "MONSTER_EGG", "SQUID_SPAWN_EGG"), new ItemMapping(383, 95, "MONSTER_EGG", "WOLF_SPAWN_EGG"), new ItemMapping(383, 96, "MONSTER_EGG", "MOOSHROOM_SPAWN_EGG"), new ItemMapping(383, 98, "MONSTER_EGG", "OCELOT_SPAWN_EGG"), new ItemMapping(383, 100, "MONSTER_EGG", "HORSE_SPAWN_EGG"), new ItemMapping(383, 101, "MONSTER_EGG", "RABBIT_SPAWN_EGG"), new ItemMapping(383, 102, "MONSTER_EGG", "POLAR_BEAR_SPAWN_EGG"), new ItemMapping(383, 103, "MONSTER_EGG", "LLAMA_SPAWN_EGG"), new ItemMapping(383, 120, "MONSTER_EGG", "VILLAGER_SPAWN_EGG"), new ItemMapping(384, "EXP_BOTTLE", "EXPERIENCE_BOTTLE"), new ItemMapping(385, "FIREBALL", "FIRE_CHARGE"), new ItemMapping(386, "BOOK_AND_QUILL", "WRITABLE_BOOK"), new ItemMapping(387, "WRITTEN_BOOK"), new ItemMapping(388, "EMERALD"), new ItemMapping(389, "ITEM_FRAME"), new ItemMapping(390, "FLOWER_POT_ITEM", "FLOWER_POT"), new ItemMapping(391, "CARROT_ITEM", "CARROT"), new ItemMapping(392, "POTATO_ITEM", "POTATO"), new ItemMapping(393, "BAKED_POTATO"), new ItemMapping(394, "POISONOUS_POTATO"), new ItemMapping(395, "EMPTY_MAP", "MAP"), new ItemMapping(396, "GOLDEN_CARROT"), new ItemMapping(397, "SKULL_ITEM", "SKELETON_SKULL"), new ItemMapping(397, 1, "SKULL_ITEM", "WITHER_SKELETON_SKULL"), new ItemMapping(397, 2, "SKULL_ITEM", "ZOMBIE_HEAD"), new ItemMapping(397, 3, "SKULL_ITEM", "PLAYER_HEAD"), new ItemMapping(397, 4, "SKULL_ITEM", "CREEPER_HEAD"), new ItemMapping(397, 5, "SKULL_ITEM", "DRAGON_HEAD"), new ItemMapping(398, "CARROT_STICK", "CARROT_ON_A_STICK"), new ItemMapping(399, "NETHER_STAR"), new ItemMapping(400, "PUMPKIN_PIE"), new ItemMapping(401, "FIREWORK", "FIREWORK_ROCKET"), new ItemMapping(402, "FIREWORK_CHARGE", "FIREWORK_STAR"), new ItemMapping(403, "ENCHANTED_BOOK"), new ItemMapping(404, "REDSTONE_COMPARATOR", "COMPARATOR"), new ItemMapping(405, "NETHER_BRICK_ITEM", "NETHER_BRICK"), new ItemMapping(406, "QUARTZ"), new ItemMapping(407, "EXPLOSIVE_MINECART", "TNT_MINECART"), new ItemMapping(408, "HOPPER_MINECART"), new ItemMapping(409, "PRISMARINE_SHARD"), new ItemMapping(410, "PRISMARINE_CRYSTALS"), new ItemMapping(411, "RABBIT"), new ItemMapping(412, "COOKED_RABBIT"), new ItemMapping(413, "RABBIT_STEW"), new ItemMapping(414, "RABBIT_FOOT"), new ItemMapping(415, "RABBIT_HIDE"), new ItemMapping(416, "ARMOR_STAND"), new ItemMapping(417, "IRON_BARDING", "IRON_HORSE_ARMOR"), new ItemMapping(418, "GOLD_BARDING", "GOLD_HORSE_ARMOR"), new ItemMapping(419, "DIAMOND_BARDING", "DIAMOND_HORSE_ARMOR"), new ItemMapping(420, "LEASH", "LEAD"), new ItemMapping(421, "NAME_TAG"), new ItemMapping(422, "COMMAND_MINECART", "COMMAND_BLOCK_MINECART"), new ItemMapping(423, "MUTTON"), new ItemMapping(424, "COOKED_MUTTON"), new ItemMapping(425, "BANNER", "WHITE_BANNER"), new ItemMapping(425, 1, "BANNER", "ORANGE_BANNER"), new ItemMapping(425, 2, "BANNER", "MAGENTA_BANNER"), new ItemMapping(425, 3, "BANNER", "LIGHT_BLUE_BANNER"), new ItemMapping(425, 4, "BANNER", "YELLOW_BANNER"), new ItemMapping(425, 5, "BANNER", "LIME_BANNER"), new ItemMapping(425, 6, "BANNER", "PINK_BANNER"), new ItemMapping(425, 7, "BANNER", "GRAY_BANNER"), new ItemMapping(425, 8, "BANNER", "LIGHT_GRAY_BANNER"), new ItemMapping(425, 9, "BANNER", "CYAN_BANNER"), new ItemMapping(425, 10, "BANNER", "PURPLE_BANNER"), new ItemMapping(425, 11, "BANNER", "BLUE_BANNER"), new ItemMapping(425, 12, "BANNER", "BROWN_BANNER"), new ItemMapping(425, 13, "BANNER", "GREEN_BANNER"), new ItemMapping(425, 14, "BANNER", "RED_BANNER"), new ItemMapping(425, 15, "BANNER", "BLACK_BANNER"), new ItemMapping(426, "END_CRYSTAL"), new ItemMapping(427, "SPRUCE_DOOR_ITEM", "SPRUCE_DOOR"), new ItemMapping(428, "BIRCH_DOOR_ITEM", "BIRCH_DOOR"), new ItemMapping(429, "JUNGLE_DOOR_ITEM", "JUNGLE_DOOR"), new ItemMapping(430, "ACACIA_DOOR_ITEM", "ACACIA_DOOR"), new ItemMapping(431, "DARK_OAK_DOOR_ITEM", "DARK_OAK_DOOR"), new ItemMapping(432, "CHORUS_FRUIT"), new ItemMapping(433, "CHORUS_FRUIT_POPPED"), new ItemMapping(434, "BEETROOT"), new ItemMapping(435, "BEETROOT_SEEDS"), new ItemMapping(436, "BEETROOT_SOUP"), new ItemMapping(437, "DRAGONS_BREATH", "DRAGON_BREATH"), new ItemMapping(438, "SPLASH_POTION"), new ItemMapping(439, "SPECTRAL_ARROW"), new ItemMapping(440, "TIPPED_ARROW"), new ItemMapping(441, "LINGERING_POTION"), new ItemMapping(442, "SHIELD"), new ItemMapping(443, "ELYTRA"), new ItemMapping(444, "BOAT_SPRUCE", "SPRUCE_BOAT"), new ItemMapping(445, "BOAT_BIRCH", "BIRCH_BOAT"), new ItemMapping(446, "BOAT_JUNGLE", "JUNGLE_BOAT"), new ItemMapping(447, "BOAT_ACACIA", "ACACIA_BOAT"), new ItemMapping(448, "BOAT_DARK_OAK", "DARK_OAK_BOAT"), new ItemMapping(449, "TOTEM", "TOTEM_OF_UNDYING"), new ItemMapping(450, "SHULKER_SHELL"), new ItemMapping(452, "IRON_NUGGET"), new ItemMapping(453, "KNOWLEDGE_BOOK"), new ItemMapping(2256, "GOLD_RECORD", "MUSIC_DISC_13"), new ItemMapping(2257, "GREEN_RECORD", "MUSIC_DISC_CAT"), new ItemMapping(2258, "RECORD_3", "MUSIC_DISC_BLOCKS"), new ItemMapping(2259, "RECORD_4", "MUSIC_DISC_CHIRP"), new ItemMapping(2260, "RECORD_5", "MUSIC_DISC_FAR"), new ItemMapping(2261, "RECORD_6", "MUSIC_DISC_MALL"), new ItemMapping(2262, "RECORD_7", "MUSIC_DISC_MELLOHI"), new ItemMapping(2263, "RECORD_8", "MUSIC_DISC_STAL"), new ItemMapping(2264, "RECORD_9", "MUSIC_DISC_STRAD"), new ItemMapping(2265, "RECORD_10", "MUSIC_DISC_WARD"), new ItemMapping(2266, "RECORD_11", "MUSIC_DISC_11"), new ItemMapping(2267, "RECORD_12", "MUSIC_DISC_WAIT")}) {
            String iid_key = String.valueOf(mapping.getLegacyId()) + INTERNAL_DELIMITER + String.valueOf(mapping.getLegacyDataValue());
            String name_key = mapping.getLegacyName() + INTERNAL_DELIMITER + String.valueOf(mapping.getLegacyDataValue());
            LEGACY_MAPPINGS.put(iid_key, mapping);
            LEGACY_MAPPINGS.put(name_key, mapping);
        }
    }

    private static class ItemMapping {
        private final String materialName;
        private final int legacyId;
        private final int legacyDataValue;
        private final String legacyName;

        public ItemMapping(int legacyId, int legacyDataValue, String legacyType, String name) {
            this.materialName = name.toUpperCase();
            this.legacyName = legacyType.toUpperCase();
            this.legacyId = legacyId;
            this.legacyDataValue = legacyDataValue;
        }

        public ItemMapping(int legacyId, String name) {
            this(legacyId, 0, name, name);
        }

        public ItemMapping(int legacyId, String legacyType, String name) {
            this(legacyId, 0, legacyType, name);
        }

        public ItemMapping(int legacyId, int data, String name) {
            this(legacyId, data, name, name);
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public int getLegacyId() {
            return this.legacyId;
        }

        public int getLegacyDataValue() {
            return this.legacyDataValue;
        }

        public String getLegacyName() {
            return this.legacyName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemMapping)) {
                return false;
            }
            ItemMapping other = (ItemMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLegacyId() != other.getLegacyId()) {
                return false;
            }
            if (this.getLegacyDataValue() != other.getLegacyDataValue()) {
                return false;
            }
            String this$materialName = this.getMaterialName();
            String other$materialName = other.getMaterialName();
            if (this$materialName == null ? other$materialName != null : !this$materialName.equals(other$materialName)) {
                return false;
            }
            String this$legacyName = this.getLegacyName();
            String other$legacyName = other.getLegacyName();
            return !(this$legacyName == null ? other$legacyName != null : !this$legacyName.equals(other$legacyName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ItemMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLegacyId();
            result = result * 59 + this.getLegacyDataValue();
            String $materialName = this.getMaterialName();
            result = result * 59 + ($materialName == null ? 43 : $materialName.hashCode());
            String $legacyName = this.getLegacyName();
            result = result * 59 + ($legacyName == null ? 43 : $legacyName.hashCode());
            return result;
        }

        public String toString() {
            return "LegacyItemConverter.ItemMapping(materialName=" + this.getMaterialName() + ", legacyId=" + this.getLegacyId() + ", legacyDataValue=" + this.getLegacyDataValue() + ", legacyName=" + this.getLegacyName() + ")";
        }
    }
}

