/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.io;

import io.lumine.xikage.mythicmobs.io.GenericConfig;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.utils.config.file.FileConfiguration;
import io.lumine.xikage.mythicmobs.utils.config.file.YamlConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MythicConfig
implements GenericConfig,
Cloneable {
    private String configName;
    private File file;
    private FileConfiguration fc;

    public MythicConfig(String name, FileConfiguration fc) {
        this.configName = name;
        this.fc = fc;
    }

    public MythicConfig(String name, File file, FileConfiguration fc) {
        this.configName = name;
        this.file = file;
        this.fc = fc;
    }

    public MythicConfig(String name, File file) {
        this.configName = name;
        this.file = file;
        this.fc = new YamlConfiguration();
        this.fc.createSection(this.configName);
    }

    public void setKey(String key) {
        this.configName = key;
    }

    public String getKey() {
        return this.configName;
    }

    public FileConfiguration getFileConfiguration() {
        return this.fc;
    }

    public boolean isSet(String field) {
        return this.fc.isSet(this.configName + "." + field);
    }

    public void set(String key, Object value) {
        this.fc.set(this.configName + "." + key, value);
    }

    public void load() {
        this.fc = YamlConfiguration.loadConfiguration(this.file);
    }

    public void save() {
        try {
            this.fc.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MythicConfig getNestedConfig(String field) {
        return new MythicConfig(this.configName + "." + field, this.fc);
    }

    public Map<String, MythicConfig> getNestedConfigs(String key) {
        HashMap<String, MythicConfig> map = new HashMap<String, MythicConfig>();
        if (!this.isSet(key)) {
            return map;
        }
        for (String k : this.getKeys(key)) {
            map.put(k, new MythicConfig(this.configName + "." + key + "." + k, this.fc));
        }
        return map;
    }

    @Override
    public String getString(String field) {
        String key = this.configName + "." + field;
        return this.fc.getString(key, this.fc.getString(key.toLowerCase()));
    }

    public String getString(String[] key) {
        return this.getString(key, null, new String[0]);
    }

    @Override
    public String getString(String field, String def) {
        String key = this.configName + "." + field;
        return this.fc.getString(key, this.fc.getString(key.toLowerCase(), def));
    }

    public String getString(String[] key, String def, String ... args) {
        String s2 = null;
        for (String k : key) {
            s2 = this.getString(this.fc.getString(k.toLowerCase(), null));
            if (s2 == null) continue;
            return s2;
        }
        for (String a : args) {
            if (a == null) continue;
            return a;
        }
        return def;
    }

    public PlaceholderString getPlaceholderString(String field) {
        String key = this.configName + "." + field;
        String s2 = this.fc.getString(key);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    public PlaceholderString getPlaceholderString(String field, String def) {
        String key = this.configName + "." + field;
        String s2 = this.fc.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    public String getColorString(String field) {
        String key = this.configName + "." + field;
        String s2 = this.fc.getString(key);
        if (s2 != null) {
            s2 = ChatColor.translateAlternateColorCodes((char)'&', (String)s2);
        }
        return s2;
    }

    public String getColorString(String field, String def) {
        String key = this.configName + "." + field;
        String s2 = this.fc.getString(key, def);
        if (s2 != null) {
            s2 = ChatColor.translateAlternateColorCodes((char)'&', (String)s2);
        }
        return s2;
    }

    @Override
    public boolean getBoolean(String field) {
        String key = this.configName + "." + field;
        return this.fc.getBoolean(this.configName + "." + field);
    }

    @Override
    public boolean getBoolean(String field, boolean def) {
        return this.fc.getBoolean(this.configName + "." + field, def);
    }

    @Override
    public int getInteger(String field) {
        String key = this.configName + "." + field;
        return this.fc.getInt(key, this.fc.getInt(key.toLowerCase()));
    }

    @Override
    public int getInteger(String field, int def) {
        String key = this.configName + "." + field;
        return this.fc.getInt(key, this.fc.getInt(key.toLowerCase(), def));
    }

    @Deprecated
    public int getInt(String field) {
        String key = this.configName + "." + field;
        return this.fc.getInt(this.configName + "." + field);
    }

    @Deprecated
    public int getInt(String field, int def) {
        String key = this.configName + "." + field;
        return this.fc.getInt(this.configName + "." + field, def);
    }

    public double getDouble(String field) {
        String key = this.configName + "." + field;
        return this.fc.getDouble(this.configName + "." + field);
    }

    public double getDouble(String field, double def) {
        String key = this.configName + "." + field;
        return this.fc.getDouble(this.configName + "." + field, def);
    }

    public List<String> getStringList(String field) {
        String key = this.configName + "." + field;
        return this.fc.getStringList(this.configName + "." + field);
    }

    public List<String> getColorStringList(String field) {
        String key = this.configName + "." + field;
        List<String> list = this.fc.getStringList(this.configName + "." + field);
        ArrayList<String> parsed = new ArrayList<String>();
        if (list != null) {
            for (String str : list) {
                parsed.add(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
            }
        }
        return parsed;
    }

    public List<PlaceholderString> getPlaceholderStringList(String field) {
        String key = this.configName + "." + field;
        List<String> list = this.fc.getStringList(this.configName + "." + field);
        ArrayList<PlaceholderString> parsed = new ArrayList<PlaceholderString>();
        if (list != null) {
            for (String str : list) {
                parsed.add(PlaceholderString.of(str));
            }
        }
        return parsed;
    }

    public List<Map<?, ?>> getMapList(String field) {
        String key = this.configName + "." + field;
        return this.fc.getMapList(this.configName + "." + field);
    }

    public List<?> getList(String field) {
        String key = this.configName + "." + field;
        if (this.fc.isSet(key)) {
            return this.fc.getList(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getList(key.toLowerCase());
        }
        return null;
    }

    public List<Byte> getByteList(String field) {
        String key = this.configName + "." + field;
        if (this.fc.isSet(key)) {
            return this.fc.getByteList(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getByteList(key.toLowerCase());
        }
        return null;
    }

    public ItemStack getItemStack(String field, String def) {
        String key = this.configName + "." + field;
        if (this.fc.isSet(key)) {
            return this.fc.getItemStack(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getItemStack(key.toLowerCase());
        }
        try {
            return new ItemStack(Material.valueOf((String)def));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isConfigurationSection(String section) {
        String key = this.configName + "." + section;
        return this.fc.isConfigurationSection(this.configName + "." + section);
    }

    public Set<String> getKeys(String section) {
        String key = this.configName + "." + section;
        return this.fc.getConfigurationSection(this.configName + "." + section).getKeys(false);
    }

    public boolean isList(String section) {
        String key = this.configName + "." + section;
        return this.fc.isList(this.configName + "." + section);
    }

    public PlaceholderInt getPlaceholderInt(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    public PlaceholderInt getPlaceholderInt(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    public PlaceholderDouble getPlaceholderDouble(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    public PlaceholderDouble getPlaceholderDouble(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    public File getFile() {
        return this.file;
    }
}

