/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.io;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.WorldScaling;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyConfiguration;
import io.lumine.xikage.mythicmobs.utils.logging.ConsoleColor;
import java.util.HashSet;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.bukkit.Material;

public class ConfigManager
extends PropertyConfiguration {
    private final MythicMobs core;
    private IOLoader<MythicMobs> settings;
    private MythicConfig config;
    public static int ClockInterval = 1;
    public static int debugLevel = -1;
    public static boolean debugMode = false;
    public static boolean debugSpawners = false;
    public static boolean errorLogging = true;
    public static int SaveInteval = 300;
    public static int SpawningInterval = 1;
    public static int timerupdate;
    public static int walkupdate;
    public static int ShowHealthRadius;
    public static int ScanInterval;
    public static int ClnrInterval;
    public static boolean AllowMetrics;
    public static boolean UseCompatibilityMode;
    public static boolean UseVolatileFeatures;
    public static String ShowHealthFormat;
    public static String KillMessagePrefix;
    public static boolean AllowUpdateChecking;
    public static int SpawnerRange;
    private boolean mobsDespawnByDefault = false;
    private boolean preventOtherDropsByDefault = false;
    public static boolean EnableAIModifiers;
    public static boolean EnableTimerSkills;
    public static boolean EnableThreatTables;
    public static boolean EnablePlayerFactions;
    public static boolean EnableLegacySkills;
    public static String defaultLevelModifierHealth;
    public static String defaultLevelModifierDamage;
    public static String defaultLevelModifierPower;
    public static String defaultLevelModifierArmor;
    public static String defaultLevelModifierKBR;
    public static boolean apiUseDeathEvent;
    public static boolean apiUseSkillEvent;
    public static boolean apiUseCustomSkillEvent;
    public static boolean compatHeroesXPEnable;
    public static boolean compatHeroesShowXPMessage;
    public static String compatHeroesXPMessageFormat;
    public static boolean compatSkillAPIShowXPMessage;
    public static String compatSkillAPIXPMessageFormat;
    public static boolean compatVaultShowMoneyMessage;
    public static String compatVaultMoneyMessageFormat;
    public static boolean compatMcMMOShowXPMessage;
    public static String compatMcMMOXPMessageFormat;
    private static boolean rsGeneratePoints;
    private static int rsMaxMobsPerChunk;
    private static int rsPlayerRadius;
    private static int rsPlayerRadiusY;
    private static int rsPointsPerSecondLand;
    private static int rsPointsPerSecondAir;
    private static int rsPointsPerSecondSea;
    private static int rsPointsPerSecondLava;
    private static int rsPointsPerSecondGround;
    private static int rsMaxGenerationTimeMillis;
    private static boolean rsDespawnVanillaOutsideRadius;
    private static boolean vanillaSpawnsDisabled;
    private Expression scalingEquationDamage = null;
    private Expression scalingEquationHealth = null;
    private static HashSet<Material> transparentBlocks;

    public ConfigManager(MythicMobs core) {
        super(core);
        this.core = core;
    }

    @Override
    public void load() {
        this.settings = new IOLoader<MythicMobs>(this.core, "config.yml");
        this.loadSettings();
        this.core.getItemManager().loadItems();
        this.core.getSkillManager().loadSkills();
        this.core.getMobManager().loadMobs();
        this.core.getDropManager().loadDropTables();
        this.core.getRandomSpawningManager().loadRandomSpawns();
        this.core.getSpawnerManager().loadSpawners();
        this.core.getSkillManager().runSecondPass();
        this.core.getDropManager().runSecondPass();
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getMobManager().getMobTypes().size() + " mobs.");
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getMobManager().getVanillaTypes().size() + " vanilla mob overrides.");
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getMobManager().getMobStacks().size() + " mob stacks.");
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getSkillManager().getSkills().size() + " skills.");
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getRandomSpawningManager().getNumberOfSpawners() + " random spawns.");
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getItemManager().getItems().size() + " mythic items.");
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getDropManager().getDropTables().size() + " drop tables.");
        MythicLogger.log("" + (Object)((Object)ConsoleColor.GREEN) + (Object)((Object)ConsoleColor.CHECK_MARK) + (Object)((Object)ConsoleColor.WHITE) + " Loaded " + MythicMobs.inst().getSpawnerManager().getSpawners().size() + " mob spawners.");
    }

    public void save() {
        this.core.getMobManager().saveCachedActiveMobs();
        this.core.getPlayerManager().saveAll();
        this.core.getWorldManager().saveAll();
        this.core.getVariableManager().save();
        this.core.getSpawnerManager().saveSpawners();
    }

    @Override
    public void unload() {
    }

    public void loadSettings() {
        this.loadLegacySettings();
        if (!this.settings.getCustomConfig().contains("Configuration.Version")) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Settings...", new Object[0]);
        MythicConfig mc = new MythicConfig("Configuration", this.settings.getCustomConfig());
        AllowMetrics = mc.getBoolean("General.AllowMetrics", true);
        if (debugLevel == -1) {
            debugLevel = mc.getInteger("General.DebugLevel", 0);
        }
        errorLogging = mc.getBoolean("General.ErrorLogging", true);
        UseCompatibilityMode = mc.getBoolean("General.Compatibilitymode", false);
        UseVolatileFeatures = mc.getBoolean("General.UseVolatileFeatures", true);
        AllowUpdateChecking = mc.getBoolean("General.CheckForUpdates", true);
        int i = mc.getInteger("Clock.SaveInterval", 5);
        SaveInteval = i * 60;
        ClockInterval = mc.getInteger("Clock.ClockInterval", 5);
        SpawningInterval = mc.getInteger("Clock.SpawnsInterval", 2);
        ScanInterval = mc.getInteger("Clock.ScannerInterval", 10);
        ClnrInterval = mc.getInteger("Clock.CleanupInterval", 600);
        this.mobsDespawnByDefault = mc.getBoolean("Mobs.DespawnByDefault", true);
        this.preventOtherDropsByDefault = mc.getBoolean("Mobs.PreventOtherDropsByDefault", false);
        EnableAIModifiers = mc.getBoolean("Mobs.EnableAIModifiers", true);
        EnableTimerSkills = mc.getBoolean("Mobs.EnableTimerSkills", true);
        EnableLegacySkills = mc.getBoolean("Mobs.EnableLegacySkills", false);
        EnableThreatTables = mc.getBoolean("Mobs.EnableThreatTables", true);
        EnablePlayerFactions = mc.getBoolean("Mobs.EnablePlayerFactions", true);
        ShowHealthRadius = mc.getInteger("Mobs.ShowHealth.Radius", 25);
        ShowHealthFormat = mc.getString("Mobs.ShowHealth.Format", ShowHealthFormat);
        KillMessagePrefix = SkillString.parseMessageSpecialChars(mc.getString("Mobs.KillMessagePrefix", KillMessagePrefix));
        rsGeneratePoints = mc.getBoolean("RandomSpawning.GenerateSpawnPoints", false);
        rsMaxMobsPerChunk = mc.getInteger("RandomSpawning.MaxMobsPerChunk", 2);
        rsPlayerRadius = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayer", 64);
        rsPlayerRadiusY = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayerY", 16);
        rsPointsPerSecondLand = mc.getInteger("RandomSpawning.PointsPerSecond.Land", 10);
        rsPointsPerSecondAir = mc.getInteger("RandomSpawning.PointsPerSecond.Air", 1);
        rsPointsPerSecondSea = mc.getInteger("RandomSpawning.PointsPerSecond.Sea", 1);
        rsPointsPerSecondLava = mc.getInteger("RandomSpawning.PointsPerSecond.Lava", 0);
        rsPointsPerSecondGround = mc.getInteger("RandomSpawning.PointsPerSecond.Ground", 0);
        rsDespawnVanillaOutsideRadius = mc.getBoolean("RandomSpawning.DespawnLazyRandomMobs", true);
        rsMaxGenerationTimeMillis = mc.getInteger("RandomSpawning.MaxGenerationTime", 20);
        vanillaSpawnsDisabled = mc.getBoolean("RandomSpawning.DisableVanillaSpawns", false);
        compatHeroesXPEnable = mc.getBoolean("Compatibility.Heroes.Enabled", compatHeroesXPEnable);
        compatHeroesShowXPMessage = mc.getBoolean("Compatibility.Heroes.ShowXPMessage", compatHeroesShowXPMessage);
        compatHeroesXPMessageFormat = mc.getString("Compatibility.Heroes.XPMessageFormat", compatHeroesXPMessageFormat);
        compatMcMMOShowXPMessage = mc.getBoolean("Compatibility.McMMO.ShowXPMessage", compatMcMMOShowXPMessage);
        compatMcMMOXPMessageFormat = mc.getString("Compatibility.McMMO.XPMessageFormat", compatMcMMOXPMessageFormat);
        compatSkillAPIShowXPMessage = mc.getBoolean("Compatibility.SkillAPI.ShowXPMessage", compatSkillAPIShowXPMessage);
        compatSkillAPIXPMessageFormat = mc.getString("Compatibility.SkillAPI.XPMessageFormat", compatSkillAPIXPMessageFormat);
        compatVaultShowMoneyMessage = mc.getBoolean("Compatibility.Vault.ShowMoneyMessage", compatVaultShowMoneyMessage);
        compatVaultMoneyMessageFormat = mc.getString("Compatibility.Vault.MoneyMessageFormat", compatVaultMoneyMessageFormat);
        compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
        compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
        compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
        compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        if (MythicMobs.isVolatile()) {
            String strScalingEquationHealth;
            String strScalingEquationDamage = mc.getString("Mobs.ScalingEquations.Damage", null);
            if (strScalingEquationDamage != null && !strScalingEquationDamage.equalsIgnoreCase("NONE")) {
                strScalingEquationDamage = strScalingEquationDamage.toLowerCase();
                this.scalingEquationDamage = new ExpressionBuilder(strScalingEquationDamage).variables("l", "v").build();
            }
            if ((strScalingEquationHealth = mc.getString("Mobs.ScalingEquations.Health", null)) != null && !strScalingEquationHealth.equalsIgnoreCase("NONE")) {
                strScalingEquationHealth = strScalingEquationHealth.toLowerCase();
                this.scalingEquationHealth = new ExpressionBuilder(strScalingEquationHealth).variables("l", "v").build();
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading WorldScaling Settings...", new Object[0]);
        WorldScaling.reset();
        if (this.settings.getCustomConfig().contains("Configuration.Mobs.Scaling")) {
            for (String world : this.settings.getCustomConfig().getConfigurationSection("Configuration.Mobs.Scaling").getKeys(false)) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "*** Loading WorldScaling for world " + world, new Object[0]);
                MythicConfig wmc = new MythicConfig("Configuration.Mobs.Scaling." + world, this.settings.getCustomConfig());
                WorldScaling.initialize(world, wmc);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Default Level Modifiers...", new Object[0]);
        defaultLevelModifierHealth = mc.getString("Mobs.DefaultLevelModifiers.Health", "0.1");
        defaultLevelModifierDamage = mc.getString("Mobs.DefaultLevelModifiers.Damage", "0");
        defaultLevelModifierPower = mc.getString("Mobs.DefaultLevelModifiers.Power", "0");
        defaultLevelModifierArmor = mc.getString("Mobs.DefaultLevelModifiers.Armor", "0");
        defaultLevelModifierKBR = mc.getString("Mobs.DefaultLevelModifiers.KnockbackResistance", "0");
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Health: " + defaultLevelModifierHealth, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Damage: " + defaultLevelModifierDamage, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Power: " + defaultLevelModifierPower, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Armor: " + defaultLevelModifierArmor, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - KBR: " + defaultLevelModifierKBR, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Finished Load Default Level Modifiers!", new Object[0]);
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public void loadLegacySettings() {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "* Checking for Legacy Settings...", new Object[0]);
        if (this.settings.getCustomConfig().contains("general.debug-level")) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Legacy Settings...", new Object[0]);
            if (debugLevel == 0) {
                debugLevel = this.settings.getCustomConfig().getInt("general.debug-level", 0);
            }
            errorLogging = this.settings.getCustomConfig().getBoolean("general.error-logging", true);
            int i = this.settings.getCustomConfig().getInt("general.save-interval", 5);
            SaveInteval = i * 60;
            ClockInterval = this.settings.getCustomConfig().getInt("general.clock-interval", ClockInterval);
            SpawningInterval = this.settings.getCustomConfig().getInt("general.spawns-interval", SpawningInterval);
            ScanInterval = this.settings.getCustomConfig().getInt("general.scanner-interval", ScanInterval);
            ClnrInterval = this.settings.getCustomConfig().getInt("general.cleanup-interval", ClnrInterval);
            EnableTimerSkills = this.settings.getCustomConfig().getBoolean("mobs.enable-timer-skills", EnableTimerSkills);
            EnableLegacySkills = this.settings.getCustomConfig().getBoolean("mobs.enable-legacy-skills", EnableLegacySkills);
            EnableThreatTables = this.settings.getCustomConfig().getBoolean("mobs.enable-threat-tables", EnableThreatTables);
            EnablePlayerFactions = this.settings.getCustomConfig().getBoolean("enable-player-factions", EnablePlayerFactions);
            ShowHealthRadius = this.settings.getCustomConfig().getInt("mobs.show-health-radius", ShowHealthRadius);
            ShowHealthFormat = this.settings.getCustomConfig().getString("mobs.show-health-format", ShowHealthFormat);
            KillMessagePrefix = this.settings.getCustomConfig().getString("mobs.kill-message-prefix", KillMessagePrefix);
            UseCompatibilityMode = this.settings.getCustomConfig().getBoolean("general.compatibility-mode", UseCompatibilityMode);
            UseVolatileFeatures = this.settings.getCustomConfig().getBoolean("general.use-volatile-features");
            AllowUpdateChecking = this.settings.getCustomConfig().getBoolean("general.check-for-updates");
            AllowMetrics = this.settings.getCustomConfig().getBoolean("metrics.allow");
            compatHeroesXPEnable = this.settings.getCustomConfig().getBoolean("compatibility.heroes-xp-enable", compatHeroesXPEnable);
            compatHeroesShowXPMessage = this.settings.getCustomConfig().getBoolean("compatibility.heroes-show-xp-message", compatHeroesShowXPMessage);
            compatHeroesXPMessageFormat = this.settings.getCustomConfig().getString("compatibility.heroes-xp-message-format", compatHeroesXPMessageFormat);
            compatMcMMOShowXPMessage = this.settings.getCustomConfig().getBoolean("compatibility.mcmmo-show-xp-message", compatMcMMOShowXPMessage);
            compatMcMMOXPMessageFormat = this.settings.getCustomConfig().getString("compatibility.mcmmo-xp-message-format", compatMcMMOXPMessageFormat);
            compatSkillAPIShowXPMessage = this.settings.getCustomConfig().getBoolean("compatibility.skillapi-show-xp-message", compatSkillAPIShowXPMessage);
            compatSkillAPIXPMessageFormat = this.settings.getCustomConfig().getString("compatibility.skillapi-xp-message-format", compatSkillAPIXPMessageFormat);
            compatVaultShowMoneyMessage = this.settings.getCustomConfig().getBoolean("compatibility.vault-show-money-message", compatVaultShowMoneyMessage);
            compatVaultMoneyMessageFormat = this.settings.getCustomConfig().getString("compatibility.vault-money-message-format", compatVaultMoneyMessageFormat);
            compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
            compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
            compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
            compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        }
    }

    public static boolean generateRSPoints() {
        return rsGeneratePoints;
    }

    public static int getRSMaxMobsPerChunk() {
        return rsMaxMobsPerChunk;
    }

    public static int getRSPlayerRadius() {
        return rsPlayerRadius;
    }

    public static int getRSPlayerRadiusY() {
        return rsPlayerRadiusY;
    }

    public static int getRSPointsPerSecondLand() {
        return rsPointsPerSecondLand;
    }

    public static int getRSPointsPerSecondAir() {
        return rsPointsPerSecondAir;
    }

    public static int getRSPointsPerSecondSea() {
        return rsPointsPerSecondSea;
    }

    public static int getRSPointsPerSecondLava() {
        return rsPointsPerSecondLava;
    }

    public static int getRSPointsPerSecondGround() {
        return rsPointsPerSecondGround;
    }

    public static int getRSMaxGenerationTimeMillis() {
        return rsMaxGenerationTimeMillis;
    }

    public static boolean getRSDespawnVanillaOutsideRadius() {
        return rsDespawnVanillaOutsideRadius;
    }

    public boolean getDespawnMobsByDefault() {
        return this.mobsDespawnByDefault;
    }

    public boolean getPreventOtherDropsByDefault() {
        return this.preventOtherDropsByDefault;
    }

    public HashSet<Material> getTransparentBlocks() {
        return transparentBlocks;
    }

    public static boolean isVanillaSpawnsDisabled() {
        return vanillaSpawnsDisabled;
    }

    public Expression getScalingEquationDamage() {
        return this.scalingEquationDamage;
    }

    public Expression getScalingEquationHealth() {
        return this.scalingEquationHealth;
    }

    static {
        ShowHealthRadius = 25;
        ScanInterval = 10;
        ClnrInterval = 600;
        AllowMetrics = true;
        UseCompatibilityMode = false;
        UseVolatileFeatures = true;
        ShowHealthFormat = "$mobname: $mobhp / $mobmaxhp";
        KillMessagePrefix = "";
        AllowUpdateChecking = true;
        SpawnerRange = 40;
        EnableAIModifiers = true;
        EnableTimerSkills = true;
        EnableThreatTables = true;
        EnablePlayerFactions = true;
        EnableLegacySkills = true;
        apiUseDeathEvent = true;
        apiUseSkillEvent = true;
        apiUseCustomSkillEvent = true;
        compatHeroesXPEnable = false;
        compatHeroesShowXPMessage = true;
        compatHeroesXPMessageFormat = "";
        compatSkillAPIShowXPMessage = true;
        compatSkillAPIXPMessageFormat = "";
        compatVaultShowMoneyMessage = true;
        compatVaultMoneyMessageFormat = "";
        compatMcMMOShowXPMessage = true;
        compatMcMMOXPMessageFormat = "";
        rsGeneratePoints = false;
        rsMaxMobsPerChunk = 20;
        rsPlayerRadius = 64;
        rsPlayerRadiusY = 16;
        rsPointsPerSecondLand = 10;
        rsPointsPerSecondAir = 0;
        rsPointsPerSecondSea = 1;
        rsPointsPerSecondLava = 0;
        rsPointsPerSecondGround = 0;
        rsMaxGenerationTimeMillis = 20;
        rsDespawnVanillaOutsideRadius = false;
        vanillaSpawnsDisabled = false;
        transparentBlocks = new HashSet();
        for (Material m3 : Material.values()) {
            if (!m3.isTransparent() && m3.isSolid() && m3.isOccluding()) continue;
            transparentBlocks.add(m3);
        }
    }
}

