/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops.droppables;

import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IIntangibleDrop;
import io.lumine.xikage.mythicmobs.drops.IMessagingDrop;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;

public class McMMODrop
extends Drop
implements IIntangibleDrop,
IMessagingDrop {
    private PlaceholderString rewardMessage = !ConfigManager.compatMcMMOShowXPMessage ? null : PlaceholderString.of(ConfigManager.compatMcMMOXPMessageFormat);

    public McMMODrop(String line, MythicLineConfig config) {
        super(line, config);
    }

    public McMMODrop(String line, MythicLineConfig config, double amount) {
        super(line, config, amount);
    }

    @Override
    public void giveDrop(AbstractPlayer target, DropMetadata metadata) {
        if (CompatibilityManager.mcMMO != null) {
            CompatibilityManager.mcMMO.giveExp(BukkitAdapter.adapt(target), (float)this.getAmount(), "swords");
        }
    }

    @Override
    public String getRewardMessage(DropMetadata meta, double amount) {
        if (this.rewardMessage == null || !ConfigManager.compatMcMMOShowXPMessage) {
            return null;
        }
        String message = this.rewardMessage.get(meta);
        message = message.replace("<drops.mcmmo>", String.valueOf(amount));
        message = message.replace("<drops.xp>", String.valueOf(amount));
        message = message.replace("<drop.amount>", String.valueOf(amount));
        return message;
    }
}

