/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops.droppables;

import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IItemDrop;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomDouble;
import java.util.ArrayList;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;

public class ItemDrop
extends Drop
implements IItemDrop {
    private final BukkitItemStack item;

    public ItemDrop(String line, MythicLineConfig config, String item) {
        super(line, config);
        String[] split;
        this.item = new BukkitItemStack(item);
        String display = config.getString(new String[]{"name", "display", "n"}, null, new String[0]);
        int data = config.getInteger(new String[]{"data", "d"}, 0);
        int amount = config.getInteger(new String[]{"amount", "a"}, 1);
        int model = config.getInteger(new String[]{"model"}, 0);
        String lore = config.getString(new String[]{"lore", "l"}, null, new String[0]);
        String color = config.getString(new String[]{"color", "c"}, null, new String[0]);
        String enchantments = config.getString(new String[]{"enchantments", "enchants", "ench", "e"}, null, new String[0]);
        String potionEffects = config.getString(new String[]{"potioneffects", "peffects", "potion", "pe"}, null, new String[0]);
        String skullOwner = config.getString(new String[]{"skullowner"}, null, new String[0]);
        String skullTexture = config.getString(new String[]{"skulltexture"}, null, new String[0]);
        if (display != null) {
            if (display.startsWith("\"")) {
                display = display.substring(1, display.length() - 1);
            }
            display = SkillString.parseMessageSpecialChars(display);
            this.item.name(display);
        }
        if (data > 0) {
            this.item.data((byte)data);
        }
        if (model > 0) {
            this.item.model(model);
        }
        if (amount != 1) {
            this.item.amount(amount);
        }
        if (lore != null) {
            try {
                ArrayList<String> loreList = new ArrayList<String>();
                String[] stringArray = lore.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s2 = stringArray[i];
                    String lores = s2.substring(1, s2.length() - 1);
                    lores = SkillString.parseMessageSpecialChars(lores);
                    loreList.add(lores);
                }
                this.item.lore(loreList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (color != null) {
            this.item.color(color);
        }
        if (enchantments != null) {
            try {
                for (String s3 : enchantments.split(",")) {
                    try {
                        split = s3.split(":");
                        Enchantment ench = Enchantment.getByName((String)split[0].toUpperCase());
                        int level = Integer.parseInt(split[1]);
                        this.item.enchant(ench, level);
                    }
                    catch (Exception ex) {
                        Log.error("Badly configured enchantment");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (potionEffects != null) {
            try {
                for (String s4 : potionEffects.split(",")) {
                    try {
                        split = s4.split(":");
                        PotionEffectType type = PotionEffectType.getByName((String)split[0].toUpperCase());
                        int duration = Integer.parseInt(split[1]);
                        int amplifier = 0;
                        if (split.length > 2) {
                            amplifier = Integer.parseInt(split[2]);
                        }
                        this.item.potionEffect(type, duration, amplifier);
                    }
                    catch (Exception ex) {
                        Log.error("Badly configured enchantment " + s4);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (skullOwner != null) {
            this.item.skullOwner(skullOwner);
        }
        if (skullTexture != null) {
            this.item.skullTexture(skullTexture);
        }
    }

    public ItemDrop(String line, MythicLineConfig config, BukkitItemStack item) {
        super(line, config);
        this.item = item;
    }

    public ItemDrop(String line, MythicLineConfig config, BukkitItemStack item, RandomDouble amount) {
        super(line, config, amount);
        this.item = item;
    }

    @Override
    public AbstractItemStack getDrop(DropMetadata metadata) {
        int amount = (int)((double)this.item.getAmount() * this.getAmount());
        return this.item.clone().amount(amount);
    }

    public String toString() {
        return "ItemDrop{" + this.item.toString() + "}";
    }
}

