/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.EquipSlot;
import io.lumine.xikage.mythicmobs.drops.IIntangibleDrop;
import io.lumine.xikage.mythicmobs.drops.IItemDrop;
import io.lumine.xikage.mythicmobs.drops.ILocationDrop;
import io.lumine.xikage.mythicmobs.drops.IMessagingDrop;
import io.lumine.xikage.mythicmobs.drops.IMultiDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.CustomDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.ExperienceDrop;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LootBag {
    private final DropMetadata metadata;
    private List<Drop> lootTable = new LinkedList<Drop>();
    private Map<Class, Drop> lootTableIntangible = new HashMap<Class, Drop>();

    public LootBag(DropMetadata meta) {
        this.metadata = meta;
    }

    public Collection<Drop> getDrops() {
        LinkedList<Drop> drops = new LinkedList<Drop>();
        drops.addAll(this.lootTable);
        drops.addAll(this.lootTableIntangible.values());
        return drops;
    }

    @Deprecated
    public LootBag add(Drop type) {
        return this.add(null, type);
    }

    public LootBag add(DropMetadata data, Drop type) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Adding Drop to LootBag: {0}", type.getLine());
        if (type instanceof CustomDrop) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "-- Rolling Custom Drop from API", new Object[0]);
            if (!((CustomDrop)type).getDrop().isPresent()) {
                return this;
            }
            type.rollAmount(data);
            type = ((CustomDrop)type).getDrop().get();
        }
        if (type instanceof IIntangibleDrop || type instanceof ExperienceDrop) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding Intangible Drop", new Object[0]);
            this.lootTableIntangible.merge(type.getClass(), type, (o, n) -> {
                Drop d = o.addAmount((Drop)n);
                return d;
            });
        } else if (type instanceof IMultiDrop) {
            int amount = (int)type.getAmount();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding {0} of MultiDrop", amount);
            for (int i = 0; i < amount; ++i) {
                this.add(data, ((IMultiDrop)((Object)type)).get(this.metadata));
            }
        } else if (type instanceof IItemDrop) {
            if (type.getAmount() < 1.0) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Cannot drop < 0 of item, skipping: {0}", type.getLine());
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding {0} of item drop: {1}", type.getAmount(), type.getLine());
                this.lootTable.add(type);
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding {0} of drop: {1}", type.getAmount(), type.getLine());
            this.lootTable.add(type);
        }
        return this;
    }

    public LootBag add(DropMetadata data, LootBag other) {
        for (Drop type : other.getLootTableIntangible().values()) {
            this.lootTableIntangible.merge(type.getClass(), type, (o, n) -> o.addAmount((Drop)n));
        }
        for (Drop type : other.getLootTable()) {
            this.lootTable.add(type);
        }
        return this;
    }

    public void drop(AbstractLocation target) {
        Location loc = BukkitAdapter.adapt(target);
        for (Drop type : this.getDrops()) {
            if (type instanceof IItemDrop) {
                AbstractItemStack stack = ((IItemDrop)((Object)type)).getDrop(this.metadata);
                loc.getWorld().dropItem(loc, BukkitAdapter.adapt(stack));
                continue;
            }
            if (!(type instanceof ILocationDrop)) continue;
            ((ILocationDrop)((Object)type)).drop(target, this.metadata);
        }
    }

    public void dropOrGive(AbstractLocation location, AbstractPlayer target) {
    }

    public void give(AbstractPlayer player) {
        this.give(player, true);
    }

    public void give(AbstractPlayer player, boolean sendMessages) {
        Player p = BukkitAdapter.adapt(player);
        HashMap<IMessagingDrop, Double> messagingDrops = new HashMap<IMessagingDrop, Double>();
        for (Drop drop : this.getDrops()) {
            if (drop instanceof IItemDrop) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Giving Item {0} with amount {1}", drop.getLine(), drop.getAmount());
                AbstractItemStack stack = ((IItemDrop)((Object)drop)).getDrop(this.metadata);
                ItemStack is = BukkitAdapter.adapt(stack);
                p.getInventory().addItem(new ItemStack[]{is});
            } else if (drop instanceof ExperienceDrop) {
                p.giveExp((int)drop.getAmount());
            } else if (drop instanceof IIntangibleDrop) {
                ((IIntangibleDrop)((Object)drop)).giveDrop(player, this.metadata);
            }
            if (!(drop instanceof IMessagingDrop)) continue;
            messagingDrops.merge((IMessagingDrop)((Object)drop), drop.getAmount(), (n, o) -> n + o);
        }
        if (messagingDrops.size() > 0 && sendMessages) {
            for (Map.Entry entry : messagingDrops.entrySet()) {
                String message = ((IMessagingDrop)entry.getKey()).getRewardMessage(this.metadata, (Double)entry.getValue());
                if (message == null) continue;
                player.sendMessage(message);
            }
        }
    }

    public void equip(AbstractEntity entity) {
        AbstractItemStack hand = null;
        AbstractItemStack offhand = null;
        AbstractItemStack head = null;
        AbstractItemStack chest = null;
        AbstractItemStack legs = null;
        AbstractItemStack feet = null;
        for (Drop type : this.getDrops()) {
            try {
                if (!(type instanceof IItemDrop) || type.getDropVar() == null) continue;
                EquipSlot slot = EquipSlot.of(type.getDropVar().toUpperCase());
                switch (slot) {
                    case HAND: {
                        hand = ((IItemDrop)((Object)type)).getDrop(this.metadata);
                        break;
                    }
                    case FEET: {
                        feet = ((IItemDrop)((Object)type)).getDrop(this.metadata);
                        break;
                    }
                    case LEGS: {
                        legs = ((IItemDrop)((Object)type)).getDrop(this.metadata);
                        break;
                    }
                    case CHEST: {
                        chest = ((IItemDrop)((Object)type)).getDrop(this.metadata);
                        break;
                    }
                    case HEAD: {
                        head = ((IItemDrop)((Object)type)).getDrop(this.metadata);
                        break;
                    }
                    case OFFHAND: {
                        offhand = ((IItemDrop)((Object)type)).getDrop(this.metadata);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (ConfigManager.debugLevel <= 0) continue;
                ex.printStackTrace();
            }
        }
        if (head != null) {
            entity.equipItemHead(head);
        }
        if (chest != null) {
            entity.equipItemChest(chest);
        }
        if (legs != null) {
            entity.equipItemLegs(legs);
        }
        if (feet != null) {
            entity.equipItemFeet(feet);
        }
        if (hand != null) {
            entity.equipItemMainHand(hand);
        }
        if (offhand != null) {
            entity.equipItemOffHand(offhand);
        }
    }

    public int size() {
        return this.lootTable.size();
    }

    public DropMetadata getMetadata() {
        return this.metadata;
    }

    public List<Drop> getLootTable() {
        return this.lootTable;
    }

    public Map<Class, Drop> getLootTableIntangible() {
        return this.lootTableIntangible;
    }

    public void setLootTable(List<Drop> lootTable) {
        this.lootTable = lootTable;
    }

    public void setLootTableIntangible(Map<Class, Drop> lootTableIntangible) {
        this.lootTableIntangible = lootTableIntangible;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootBag)) {
            return false;
        }
        LootBag other = (LootBag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DropMetadata this$metadata = this.getMetadata();
        DropMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<Drop> this$lootTable = this.getLootTable();
        List<Drop> other$lootTable = other.getLootTable();
        if (this$lootTable == null ? other$lootTable != null : !((Object)this$lootTable).equals(other$lootTable)) {
            return false;
        }
        Map<Class, Drop> this$lootTableIntangible = this.getLootTableIntangible();
        Map<Class, Drop> other$lootTableIntangible = other.getLootTableIntangible();
        return !(this$lootTableIntangible == null ? other$lootTableIntangible != null : !((Object)this$lootTableIntangible).equals(other$lootTableIntangible));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootBag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DropMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<Drop> $lootTable = this.getLootTable();
        result = result * 59 + ($lootTable == null ? 43 : ((Object)$lootTable).hashCode());
        Map<Class, Drop> $lootTableIntangible = this.getLootTableIntangible();
        result = result * 59 + ($lootTableIntangible == null ? 43 : ((Object)$lootTableIntangible).hashCode());
        return result;
    }

    public String toString() {
        return "LootBag(metadata=" + this.getMetadata() + ", lootTable=" + this.getLootTable() + ", lootTableIntangible=" + this.getLootTableIntangible() + ")";
    }
}

