/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public enum EquipSlot {
    HEAD("4", "HELMET", "HELM", "HAT"),
    CHEST("3", "CHESTPIECE", "CHESTPLATE", "BODY"),
    LEGS("2", "LEGGINGS", "PANTS"),
    FEET("1", "BOOTS", "SHOES"),
    HAND("0", "MAINHAND", "WEAPON"),
    OFFHAND("5", "SHIELD"),
    NONE(new String[0]);

    private HashSet<String> slotAliases = new HashSet();

    private EquipSlot(String ... aliases) {
        this.slotAliases.add(this.toString());
        for (String alias : aliases) {
            this.slotAliases.add(alias);
        }
    }

    public boolean matches(String slot) {
        for (String alias : this.slotAliases) {
            if (!alias.equalsIgnoreCase(slot)) continue;
            return true;
        }
        return false;
    }

    public void equip(AbstractEntity entity, AbstractItemStack item) {
        switch (this) {
            case HEAD: {
                entity.equipItemHead(item);
                break;
            }
            case CHEST: {
                entity.equipItemChest(item);
                break;
            }
            case LEGS: {
                entity.equipItemLegs(item);
                break;
            }
            case FEET: {
                entity.equipItemFeet(item);
                break;
            }
            case HAND: {
                entity.equipItemMainHand(item);
                break;
            }
            case OFFHAND: {
                entity.equipItemOffHand(item);
                break;
            }
        }
    }

    public static EquipSlot of(String key) {
        for (EquipSlot slot : EquipSlot.values()) {
            if (!slot.matches(key)) continue;
            return slot;
        }
        return NONE;
    }

    public Optional<ItemStack> get(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return Optional.empty();
        }
        LivingEntity bukkitEntity = (LivingEntity)entity.getBukkitEntity();
        ItemStack item = null;
        if (bukkitEntity.getType() == EntityType.ARMOR_STAND) {
            ArmorStand ass = (ArmorStand)bukkitEntity;
            switch (this) {
                case HEAD: {
                    item = ass.getItem(EquipmentSlot.HEAD);
                    break;
                }
                case CHEST: {
                    item = ass.getItem(EquipmentSlot.CHEST);
                    break;
                }
                case LEGS: {
                    item = ass.getItem(EquipmentSlot.LEGS);
                    break;
                }
                case FEET: {
                    item = ass.getItem(EquipmentSlot.FEET);
                    break;
                }
                case HAND: {
                    item = ass.getItem(EquipmentSlot.HAND);
                    break;
                }
                case OFFHAND: {
                    item = ass.getItem(EquipmentSlot.OFF_HAND);
                    break;
                }
            }
        } else {
            switch (this) {
                case HEAD: {
                    item = bukkitEntity.getEquipment().getHelmet();
                    break;
                }
                case CHEST: {
                    item = bukkitEntity.getEquipment().getChestplate();
                    break;
                }
                case LEGS: {
                    item = bukkitEntity.getEquipment().getLeggings();
                    break;
                }
                case FEET: {
                    item = bukkitEntity.getEquipment().getBoots();
                    break;
                }
                case HAND: {
                    item = bukkitEntity.getEquipment().getItemInMainHand();
                    break;
                }
                case OFFHAND: {
                    item = bukkitEntity.getEquipment().getItemInOffHand();
                    break;
                }
            }
        }
        return Optional.ofNullable(item);
    }
}

