/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.InvalidDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.CommandDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.CustomDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.DropTableDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.ExperienceDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.HeroesExperienceDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.ItemDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.McMMODrop;
import io.lumine.xikage.mythicmobs.drops.droppables.MythicDropsDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.MythicItemDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.NothingDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.PhatLootsDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.SkillAPIDrop;
import io.lumine.xikage.mythicmobs.drops.droppables.VaultDrop;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.GenericConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.LegacyItemConverter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.StaticDouble;
import io.lumine.xikage.mythicmobs.util.MathParser;
import io.lumine.xikage.mythicmobs.utils.collections.AWeightedItem;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomDouble;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.Material;

public abstract class Drop
extends AWeightedItem
implements Cloneable {
    private final String line;
    private final GenericConfig config;
    protected String dropVar;
    private PlaceholderDouble dropAmount;
    private double amount;

    public Drop(String line, MythicLineConfig config) {
        block12: {
            this.dropVar = null;
            this.dropAmount = new StaticDouble("1");
            this.amount = 0.0;
            this.line = line;
            this.config = config;
            try {
                String[] split = line.split(" ");
                if (split[0].contains(":")) {
                    String[] split2 = split[0].split(":");
                    this.dropVar = split2[1];
                }
                if (split.length == 2) {
                    if (RandomDouble.matches(split[1]) || split[1].startsWith("'")) {
                        this.dropAmount = PlaceholderDouble.of(split[1]);
                    } else {
                        this.dropVar = split[1];
                    }
                } else if (split.length == 3) {
                    if (RandomDouble.matches(split[1]) || split[1].startsWith("'")) {
                        this.dropAmount = PlaceholderDouble.of(split[1]);
                        this.weight = MathParser.evalChance(split[2]);
                    } else {
                        this.dropVar = split[1];
                        this.dropAmount = PlaceholderDouble.of(split[2]);
                    }
                } else if (split.length >= 4) {
                    this.dropVar = split[1];
                    this.dropAmount = PlaceholderDouble.of(split[2]);
                    this.weight = MathParser.evalChance(split[3]);
                }
            }
            catch (Exception ex) {
                MythicLogger.errorDropConfig(this, config, "Invalid Syntax");
                if (ConfigManager.debugLevel <= 0) break block12;
                ex.printStackTrace();
            }
        }
    }

    public Drop(String line, MythicLineConfig config, double amount) {
        this(line, config);
        this.dropAmount = new StaticDouble(amount);
    }

    public Drop(String line, MythicLineConfig config, RandomDouble amount) {
        this(line, config);
        this.dropAmount = new io.lumine.xikage.mythicmobs.skills.placeholders.parsers.RandomDouble(amount);
    }

    public boolean rollChance() {
        return this.weight == 1.0 || !(Numbers.randomDouble() > this.weight);
    }

    public void rollAmount(DropMetadata data) {
        this.amount = this.dropAmount.get(data);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().equals(this.getClass());
    }

    public Drop addAmount(Drop other) {
        this.amount += other.getAmount();
        return this.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Drop getDrop(String fileName, String drop) {
        if (drop.contains("}")) {
            sp1 = drop.substring(0, drop.indexOf("}"));
            sp2 = drop.substring(drop.indexOf("}"));
            drop = ns = sp1.replace(" ", "") + sp2;
        }
        s = drop.split(" ");
        name = null;
        mlc = new MythicLineConfig(fileName, s[0]);
        name = s[0].contains("{") != false ? s[0].substring(0, s[0].indexOf("{")) : s[0];
        oName = name.toUpperCase();
        oData = 0;
        if (name.contains(":")) {
            oName = name.split(":")[0].toUpperCase();
            try {
                oData = Byte.valueOf(name.split(":")[1]);
            }
            catch (Exception var7_7) {
                // empty catch block
            }
            name = name.split(":")[0];
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            material = null;
            try {
                v0 /* !! */  = material = oData == 0 ? Material.valueOf((String)oName) : LegacyItemConverter.getMaterial(oName, oData);
                if (material != null || oData <= 0) ** GOTO lbl50
                material = Material.valueOf((String)oName);
            }
            catch (Exception ex) {
                material = LegacyItemConverter.getMaterial(oName, oData);
                if (material != null || oData <= 0) ** GOTO lbl50
                try {
                    material = Material.valueOf((String)oName);
                }
                catch (Exception var9_14) {
                    // empty catch block
                }
            }
            finally {
                if (material != null && material != Material.AIR) {
                    name = material.toString();
                }
            }
        } else {
            material = Material.AIR;
            if (name.matches("[0-9]*")) {
                material = LegacyItemConverter.getMaterial(oName, (byte)0);
            } else {
                try {
                    material = Material.valueOf((String)oName);
                }
                catch (Exception var8_11) {
                    // empty catch block
                }
            }
            if (material != null && material != Material.AIR) {
                name = material.toString();
            }
        }
lbl50:
        // 8 sources

        try {
            if (Material.matchMaterial((String)name) != null) {
                return new ItemDrop(drop, mlc, name);
            }
            if (MythicMobs.inst().getDropManager().getDropTable(name).isPresent()) {
                return new DropTableDrop(drop, name, mlc);
            }
            if (MythicMobs.inst().getItemManager().getItem(name).isPresent()) {
                return new MythicItemDrop(drop, name, mlc);
            }
            material = name.toUpperCase();
            var8_13 = -1;
            switch (material.hashCode()) {
                case -1447660627: {
                    if (!material.equals("NOTHING")) break;
                    var8_13 = 0;
                    break;
                }
                case 2402104: {
                    if (!material.equals("NONE")) break;
                    var8_13 = 1;
                    break;
                }
                case 2407815: {
                    if (!material.equals("NULL")) break;
                    var8_13 = 2;
                    break;
                }
                case 1668377387: {
                    if (!material.equals("COMMAND")) break;
                    var8_13 = 3;
                    break;
                }
                case 66842: {
                    if (!material.equals("CMD")) break;
                    var8_13 = 4;
                    break;
                }
                case 399525226: {
                    if (!material.equals("EXPERIENCE")) break;
                    var8_13 = 5;
                    break;
                }
                case 69117: {
                    if (!material.equals("EXP")) break;
                    var8_13 = 6;
                    break;
                }
                case 2808: {
                    if (!material.equals("XP")) break;
                    var8_13 = 7;
                    break;
                }
                case 81443346: {
                    if (!material.equals("VAULT")) break;
                    var8_13 = 8;
                    break;
                }
                case 73541792: {
                    if (!material.equals("MONEY")) break;
                    var8_13 = 9;
                    break;
                }
                case 1358028817: {
                    if (!material.equals("CURRENCY")) break;
                    var8_13 = 10;
                    break;
                }
                case 795951829: {
                    if (!material.equals("HEROESEXP")) break;
                    var8_13 = 11;
                    break;
                }
                case -1096029992: {
                    if (!material.equals("HEROES-EXP")) break;
                    var8_13 = 12;
                    break;
                }
                case -1631374844: {
                    if (!material.equals("MCMMOEXP")) break;
                    var8_13 = 13;
                    break;
                }
                case 966254473: {
                    if (!material.equals("MCMMO-EXP")) break;
                    var8_13 = 14;
                    break;
                }
                case 2095518761: {
                    if (!material.equals("MYTHICDROP")) break;
                    var8_13 = 15;
                    break;
                }
                case 2455: {
                    if (!material.equals("MD")) break;
                    var8_13 = 16;
                    break;
                }
                case -892525229: {
                    if (!material.equals("PHATLOOT")) break;
                    var8_13 = 17;
                    break;
                }
                case -1898478240: {
                    if (!material.equals("PHATLOOTS")) break;
                    var8_13 = 18;
                    break;
                }
                case 2556: {
                    if (!material.equals("PL")) break;
                    var8_13 = 19;
                    break;
                }
                case 500514612: {
                    if (!material.equals("SKILLAPIEXP")) break;
                    var8_13 = 20;
                    break;
                }
                case -1664649127: {
                    if (!material.equals("SKILLAPI-EXP")) break;
                    var8_13 = 21;
                }
            }
            switch (var8_13) {
                case 0: 
                case 1: 
                case 2: {
                    return new NothingDrop(drop, mlc);
                }
                case 3: 
                case 4: {
                    return new CommandDrop(drop, mlc);
                }
                case 5: 
                case 6: 
                case 7: {
                    return new ExperienceDrop(drop, mlc);
                }
                case 8: 
                case 9: 
                case 10: {
                    return new VaultDrop(drop, mlc);
                }
                case 11: 
                case 12: {
                    return new HeroesExperienceDrop(drop, mlc);
                }
                case 13: 
                case 14: {
                    return new McMMODrop(drop, mlc);
                }
                case 15: 
                case 16: {
                    return new MythicDropsDrop(drop, mlc);
                }
                case 17: 
                case 18: 
                case 19: {
                    return new PhatLootsDrop(drop, mlc);
                }
                case 20: 
                case 21: {
                    return new SkillAPIDrop(drop, mlc);
                }
            }
            return new CustomDrop(name, drop, mlc);
        }
        catch (Exception ex) {
            return new InvalidDrop(drop, mlc);
        }
    }

    public Drop clone() {
        try {
            return (Drop)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLine() {
        return this.line;
    }

    public GenericConfig getConfig() {
        return this.config;
    }

    public String getDropVar() {
        return this.dropVar;
    }

    public PlaceholderDouble getDropAmount() {
        return this.dropAmount;
    }

    public void setDropAmount(PlaceholderDouble dropAmount) {
        this.dropAmount = dropAmount;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }
}

