/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import com.pg85.otg.bukkit.BukkitWorld;
import com.pg85.otg.bukkit.OTGPlugin;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicConditionLoadEvent;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.events.Subscription;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;

public class OpenTerrainGeneratorSupport
implements Listener {
    private OTGPlugin otg = (OTGPlugin)Bukkit.getPluginManager().getPlugin("OpenTerrainGenerator");
    private Subscription loader = Events.subscribe(MythicConditionLoadEvent.class).handler(event -> {
        switch (event.getConditionName()) {
            case "OTGBIOME": 
            case "OPENTERRAINGENERATORBIOME": 
            case "TCBIOME": 
            case "TERRAINCONTROLBIOME": {
                event.register(new OTGBiomeCondition(event.getConditionName(), event.getConfig()));
            }
        }
    });

    public String getBiome(AbstractLocation location) {
        String worldName = location.getWorld().getName();
        String biome = this.otg.worlds.containsKey(worldName) ? ((BukkitWorld)this.otg.worlds.get(worldName)).getBiome(location.getBlockX(), location.getBlockZ()).getName() : location.getBiome().toString();
        return biome;
    }

    public class OTGBiomeCondition
    extends SkillCondition
    implements ILocationCondition {
        private Set<String> biomes;
        private boolean strict;

        public OTGBiomeCondition(String line, MythicLineConfig mlc) {
            super(line);
            this.biomes = new HashSet<String>();
            this.strict = false;
            String b = mlc.getString(new String[]{"biome", "b"}, "PLAINS", this.conditionVar).toUpperCase();
            this.strict = mlc.getBoolean(new String[]{"strict", "s"}, false);
            for (String s2 : b.split(",")) {
                this.biomes.add(s2);
            }
        }

        @Override
        public boolean check(AbstractLocation location) {
            if (!MythicMobs.inst().getCompatibility().getOpenTerrainGenerator().isPresent()) {
                return false;
            }
            String biome = OpenTerrainGeneratorSupport.this.getBiome(location).toUpperCase();
            if (this.strict) {
                return this.biomes.contains(location.getBiome().toString());
            }
            for (String b : this.biomes) {
                if (!biome.contains(b)) continue;
                return true;
            }
            return false;
        }
    }
}

