/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.PluginComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicDropLoadEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicReloadedEvent;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IItemDrop;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.placeholders.Placeholder;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Optional;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.droptable.item.MMOItemDropItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MMOItemsSupport
extends PluginComponent {
    public MMOItemsSupport(MythicMobs plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicMobs plugin) {
        Events.subscribe(MythicDropLoadEvent.class).handler(event -> {
            if (event.getDropName().equalsIgnoreCase("mmoitems") || event.getDropName().equalsIgnoreCase("mmoitem")) {
                event.register(new MMOItemsDrop(event.getConfig()));
            }
        }).bindWith(this);
        Events.subscribe(MythicReloadedEvent.class).handler(event -> this.getPlugin().getPlaceholderManager().register("mmoitems.skill", (Placeholder)Placeholder.meta((metadata, arg) -> String.valueOf(PlayerData.get((OfflinePlayer)((Player)metadata.getCaster().getEntity().asPlayer().getBukkitEntity())).getAbilityData().getCachedModifier(arg))))).bindWith(this);
        Schedulers.sync().runLater(() -> this.getPlugin().getPlaceholderManager().register("mmoitems.skill", (Placeholder)Placeholder.meta((metadata, arg) -> String.valueOf(PlayerData.get((OfflinePlayer)((Player)metadata.getCaster().getEntity().asPlayer().getBukkitEntity())).getAbilityData().getCachedModifier(arg)))), 1L);
    }

    @Override
    public void unload() {
    }

    public boolean checkCustomBlock(Block block, int id) {
        Optional optional = MMOItems.plugin.getCustomBlocks().getFromBlock(block.getBlockData());
        if (optional.isPresent()) {
            CustomBlock custom = (CustomBlock)optional.get();
            return id == custom.getId();
        }
        return false;
    }

    public Material getCustomBlockMaterial(int id) {
        return MMOItems.plugin.getCustomBlocks().getBlock(id).getState().getType();
    }

    public ItemStack getCustomItem(String string) {
        try {
            String[] split = string.split("\\.");
            String typeFormat = split[0].toUpperCase().replace("-", "_");
            Type type = MMOItems.plugin.getTypes().get(typeFormat);
            String id = split[1];
            return MMOItems.plugin.getItems().getItem(type, id);
        }
        catch (IllegalArgumentException exception) {
            MythicLogger.error("Could not load drop item: " + exception.getMessage());
            return new ItemStack(Material.ZOMBIE_HORSE_SPAWN_EGG);
        }
    }

    public class MMOItemsDrop
    extends Drop
    implements IItemDrop {
        private Type type;
        private String id;
        private MMOItemDropItem dropItem;

        public MMOItemsDrop(MythicLineConfig config) {
            super(config.getLine(), config);
            try {
                String typeFormat = config.getString("type").toUpperCase().replace("-", "_");
                Validate.isTrue((boolean)MMOItems.plugin.getTypes().has(typeFormat), (String)("Could not find type with ID " + typeFormat));
                this.type = MMOItems.plugin.getTypes().get(typeFormat);
                this.id = config.getString("id");
                Validate.notNull((Object)this.id, (String)"MMOItems ID cannot be null");
                this.dropItem = new MMOItemDropItem(this.type, this.id, 1.0, config.getDouble("unidentified", 0.0), 1, 1);
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.WARNING, "Could not load drop item: " + exception.getMessage());
                return;
            }
        }

        @Override
        public AbstractItemStack getDrop(DropMetadata metadata) {
            if (this.dropItem != null) {
                PlayerData playerData = metadata.getTrigger() != null && metadata.getTrigger().isPlayer() ? PlayerData.get((OfflinePlayer)((Player)metadata.getTrigger().getBukkitEntity())) : null;
                ItemStack itemStack = this.dropItem.getItem(playerData, 1);
                if (itemStack == null) {
                    MythicLogger.errorCompatibility("MMOITEMS", "Item type " + this.type.getId() + "." + this.id + " not found");
                    return new BukkitItemStack(Material.STONE);
                }
                return new BukkitItemStack(this.dropItem.getItem(playerData, 1)).amount((int)this.getAmount());
            }
            return new BukkitItemStack(Material.STONE);
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public MMOItemDropItem getDropItem() {
            return this.dropItem;
        }
    }
}

