/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.GenericConfig;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileMaterial;
import java.util.Arrays;
import java.util.stream.Stream;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AreaEffectCloudWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CreeperWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.DonkeyWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.DroppedItemWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.EndermanWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FoxWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.HorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LlamaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MuleWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PandaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ParrotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PhantomWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PolarBearWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SkeletonHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TurtleWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.VillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WanderingTraderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieVillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class LibsDisguisesSupport {
    public LDVersion version = LDVersion.v1_1_1;
    public boolean enabled = false;
    public LibsDisguises ld = (LibsDisguises)Bukkit.getPluginManager().getPlugin("LibsDisguises");

    public LibsDisguisesSupport() {
        this.setCompatibility();
    }

    private void setCompatibility() {
        try {
            Integer[] v = (Integer[])Arrays.stream(this.ld.getDescription().getVersion().replaceAll("[^0-9.]", "").split("\\.")).map(Integer::parseInt).toArray(Integer[]::new);
            LDVersion[] versions = LDVersion.values();
            block2: for (int i = versions.length - 1; i >= 0; --i) {
                Integer[] v1 = (Integer[])Arrays.stream(versions[i].name().replace("v", "").split("_")).map(Integer::parseInt).toArray(Integer[]::new);
                for (int a = 0; a < Math.min(v1.length, v.length); ++a) {
                    if (v[a] < v1[a]) continue block2;
                }
                this.version = versions[i];
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isCompatible(LDVersion version) {
        return version.ordinal() >= this.version.ordinal();
    }

    public void setDisguise(ActiveMob am, String disguise, boolean legacy) {
        MythicMob mm3 = am.getType();
        MythicConfig mc = am.getType().getConfig();
        Entity e = am.getEntity().getBukkitEntity();
        Disguise fd = legacy ? this.getDisguise(disguise, mc, am.getDisplayName()) : this.setGenericOptions(this.getParsedDisguise(disguise), mc);
        if (fd instanceof PlayerDisguise) {
            PlayerWatcher pw = (PlayerWatcher)fd.getWatcher();
            String name = SkillString.parseMobVariables(((PlayerDisguise)fd).getName(), am, null, null);
            if (name != null && (name = ChatColor.translateAlternateColorCodes((char)'&', (String)name)).equals(" ")) {
                am.setShowCustomNameplate(true);
            }
            try {
                if (!pw.hasCustomName()) {
                    pw.setCustomName(am.getDisplayName());
                }
                pw.setCustomNameVisible(true);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Set disguise custom name to " + am.getDisplayName(), new Object[0]);
            }
            catch (NoSuchMethodError ex) {
                MythicLogger.error("An error occurred processing a disguise", ex);
            }
        } else if (fd instanceof MobDisguise) {
            if (am.getType().getConfig().getBoolean("Disguise.ShowName", false)) {
                FlagWatcher watcher = fd.getWatcher();
                try {
                    if (!watcher.hasCustomName()) {
                        watcher.setCustomName(am.getDisplayName());
                    }
                    watcher.setCustomNameVisible(true);
                }
                catch (NoSuchMethodError ex) {
                    MythicLogger.error("An error occurred processing a disguise", ex);
                }
            }
        } else if (am.getType().getConfig().getBoolean("Disguise.ShowName", false)) {
            FlagWatcher watcher = fd.getWatcher();
            try {
                if (!watcher.hasCustomName()) {
                    watcher.setCustomName(am.getDisplayName());
                }
                watcher.setCustomNameVisible(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        Schedulers.sync().run(() -> {
            try {
                DisguiseAPI.disguiseToAll((Entity)e, (Disguise)fd);
            }
            catch (Exception ex) {
                MythicLogger.errorCompatibility("LibsDisguises", "Error applying Disguise: disguise may be configured incorrectly.");
                if (ConfigManager.debugLevel > 0) {
                    ex.printStackTrace();
                }
                return;
            }
        });
    }

    public void setDisguise(AbstractEntity entity, MythicLineConfig mc) {
        Disguise fd;
        Entity e = BukkitAdapter.adapt(entity);
        String disguise = mc.getString(new String[]{"type", "disguise", "d"}, null, new String[0]);
        if (disguise == null) {
            disguise = mc.getString(new String[]{"config", "conf", "c"}, "player Xikage", new String[0]);
            fd = this.getParsedDisguise(disguise);
        } else {
            fd = this.getDisguise(disguise, mc, entity.getBukkitEntity() == null ? null : entity.getBukkitEntity().getCustomName());
        }
        if (mc.getBoolean("showname", true)) {
            FlagWatcher watcher = fd.getWatcher();
            try {
                watcher.setCustomNameVisible(true);
            }
            catch (NoSuchMethodError ex) {
                MythicLogger.error("An error occurred processing a disguise", ex);
            }
        }
        try {
            DisguiseAPI.disguiseToAll((Entity)e, (Disguise)fd);
        }
        catch (NullPointerException ex) {
            MythicLogger.error("(LibsDisguises) Error applying Disguise: disguise may be configured incorrectly.");
            ex.printStackTrace();
            return;
        }
    }

    public void removeDisguise(AbstractEntity entity) {
        Scheduler.runSync(() -> DisguiseAPI.undisguiseToAll((Entity)entity.getBukkitEntity()));
    }

    public Disguise getDisguise(String disguise) {
        try {
            return DisguiseParser.parseDisguise((String)disguise);
        }
        catch (Exception e) {
            MythicLogger.errorCompatibility("LibsDisguises", "Invalid disguise supplied");
            e.printStackTrace();
            return null;
        }
    }

    public void modifyDisguise(AbstractEntity target, String disguiseString) {
        try {
            Entity entity = target.getBukkitEntity();
            Disguise disguise = DisguiseAPI.getDisguise((Entity)entity);
            if (disguise != null) {
                DisguiseParser.modifyDisguise((Disguise)disguise, (Entity)entity, (String)disguiseString);
            }
        }
        catch (Exception e) {
            MythicLogger.errorCompatibility("LibsDisguises", "Failed to modify disguise: Invalid arguments supplied: " + disguiseString);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disguise getParsedDisguise(String disguiseConfig) {
        Disguise d = null;
        try {
            d = DisguiseParser.parseDisguise((String)disguiseConfig);
        }
        catch (Exception ex) {
            MythicLogger.errorCompatibility("LibsDisguises", "Disguise '" + disguiseConfig + "' failed to parse");
            ex.printStackTrace();
            d = new PlayerDisguise("Error");
        }
        finally {
            if (d == null) {
                MythicLogger.errorCompatibility("LibsDisguises", "Disguise '" + disguiseConfig + "' not found");
                d = new PlayerDisguise("Ashijin");
            }
        }
        return d;
    }

    @Deprecated
    public Disguise getDisguise(String disguise, GenericConfig mc) {
        return this.getDisguise(disguise, mc, "Ashijin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Disguise getDisguise(String disguise, GenericConfig mc, String displayName) {
        block357: {
            if (mc instanceof MythicConfig) {
                mc = new MythicConfig(((MythicConfig)mc).getKey() + ".Disguise", ((MythicConfig)mc).getFile(), ((MythicConfig)mc).getFileConfiguration());
            }
            split = disguise.split(":");
            dn = split[0];
            data = null;
            if (split.length > 1) {
                data = split[1];
            }
            d = null;
            try {
                var8_8 = dn.toLowerCase();
                var9_10 = -1;
                switch (var8_8.hashCode()) {
                    case -1773183786: {
                        if (!var8_8.equals("armor_stand")) break;
                        var9_10 = 0;
                        break;
                    }
                    case -1978379785: {
                        if (!var8_8.equals("armorstand")) break;
                        var9_10 = 1;
                        break;
                    }
                    case 93090825: {
                        if (!var8_8.equals("arrow")) break;
                        var9_10 = 2;
                        break;
                    }
                    case 97301: {
                        if (!var8_8.equals("bat")) break;
                        var9_10 = 3;
                        break;
                    }
                    case 3029312: {
                        if (!var8_8.equals("boat")) break;
                        var9_10 = 4;
                        break;
                    }
                    case 93819586: {
                        if (!var8_8.equals("blaze")) break;
                        var9_10 = 5;
                        break;
                    }
                    case 93832333: {
                        if (!var8_8.equals("block")) break;
                        var9_10 = 6;
                        break;
                    }
                    case 891564245: {
                        if (!var8_8.equals("falling_block")) break;
                        var9_10 = 7;
                        break;
                    }
                    case 98262: {
                        if (!var8_8.equals("cat")) break;
                        var9_10 = 8;
                        break;
                    }
                    case 44807071: {
                        if (!var8_8.equals("cat_baby")) break;
                        var9_10 = 9;
                        break;
                    }
                    case 2105563373: {
                        if (!var8_8.equals("baby_cat")) break;
                        var9_10 = 10;
                        break;
                    }
                    case -1131107961: {
                        if (!var8_8.equals("kitten")) break;
                        var9_10 = 11;
                        break;
                    }
                    case -475025449: {
                        if (!var8_8.equals("cave_spider")) break;
                        var9_10 = 12;
                        break;
                    }
                    case 746007989: {
                        if (!var8_8.equals("chicken")) break;
                        var9_10 = 13;
                        break;
                    }
                    case 172153120: {
                        if (!var8_8.equals("chicken_baby")) break;
                        var9_10 = 14;
                        break;
                    }
                    case -1373265076: {
                        if (!var8_8.equals("baby_chicken")) break;
                        var9_10 = 15;
                        break;
                    }
                    case 98680: {
                        if (!var8_8.equals("cod")) break;
                        var9_10 = 16;
                        break;
                    }
                    case 98699: {
                        if (!var8_8.equals("cow")) break;
                        var9_10 = 17;
                        break;
                    }
                    case -329155830: {
                        if (!var8_8.equals("cow_baby")) break;
                        var9_10 = 18;
                        break;
                    }
                    case 2105563810: {
                        if (!var8_8.equals("baby_cow")) break;
                        var9_10 = 19;
                        break;
                    }
                    case 1028669806: {
                        if (!var8_8.equals("creeper")) break;
                        var9_10 = 20;
                        break;
                    }
                    case 2018968211: {
                        if (!var8_8.equals("creeper_powered")) break;
                        var9_10 = 21;
                        break;
                    }
                    case -1970033517: {
                        if (!var8_8.equals("powered_creeper")) break;
                        var9_10 = 22;
                        break;
                    }
                    case 1837070814: {
                        if (!var8_8.equals("dolphin")) break;
                        var9_10 = 23;
                        break;
                    }
                    case 612417175: {
                        if (!var8_8.equals("dolphin_baby")) break;
                        var9_10 = 24;
                        break;
                    }
                    case -282202251: {
                        if (!var8_8.equals("baby_dolphin")) break;
                        var9_10 = 25;
                        break;
                    }
                    case -1326158276: {
                        if (!var8_8.equals("donkey")) break;
                        var9_10 = 26;
                        break;
                    }
                    case -1860072991: {
                        if (!var8_8.equals("dragon_fireball")) break;
                        var9_10 = 27;
                        break;
                    }
                    case -1023742904: {
                        if (!var8_8.equals("dragonfireball")) break;
                        var9_10 = 28;
                        break;
                    }
                    case 1925942999: {
                        if (!var8_8.equals("drowned")) break;
                        var9_10 = 29;
                        break;
                    }
                    case 1485299006: {
                        if (!var8_8.equals("drowned_baby")) break;
                        var9_10 = 30;
                        break;
                    }
                    case -193330066: {
                        if (!var8_8.equals("baby_drowned")) break;
                        var9_10 = 31;
                        break;
                    }
                    case -573797055: {
                        if (!var8_8.equals("babydrowned")) break;
                        var9_10 = 32;
                        break;
                    }
                    case 100357: {
                        if (!var8_8.equals("egg")) break;
                        var9_10 = 33;
                        break;
                    }
                    case 1731036562: {
                        if (!var8_8.equals("enderman")) break;
                        var9_10 = 34;
                        break;
                    }
                    case 1731036686: {
                        if (!var8_8.equals("endermen")) break;
                        var9_10 = 35;
                        break;
                    }
                    case 1803855826: {
                        if (!var8_8.equals("end_crystal")) break;
                        var9_10 = 36;
                        break;
                    }
                    case -389587461: {
                        if (!var8_8.equals("endcrystal")) break;
                        var9_10 = 37;
                        break;
                    }
                    case 1874954094: {
                        if (!var8_8.equals("endercrystal")) break;
                        var9_10 = 38;
                        break;
                    }
                    case -1009800001: {
                        if (!var8_8.equals("ender_crystal")) break;
                        var9_10 = 39;
                        break;
                    }
                    case -52455945: {
                        if (!var8_8.equals("end_dragon")) break;
                        var9_10 = 40;
                        break;
                    }
                    case -2082881686: {
                        if (!var8_8.equals("ender_dragon")) break;
                        var9_10 = 41;
                        break;
                    }
                    case 2093545134: {
                        if (!var8_8.equals("enddragon")) break;
                        var9_10 = 42;
                        break;
                    }
                    case -604351781: {
                        if (!var8_8.equals("enderdragon")) break;
                        var9_10 = 43;
                        break;
                    }
                    case 2122533845: {
                        if (!var8_8.equals("endermite")) break;
                        var9_10 = 44;
                        break;
                    }
                    case -296897498: {
                        if (!var8_8.equals("elder_guardian")) break;
                        var9_10 = 45;
                        break;
                    }
                    case -1291034694: {
                        if (!var8_8.equals("evoker")) break;
                        var9_10 = 46;
                        break;
                    }
                    case -1274575931: {
                        if (!var8_8.equals("evokerfangs")) break;
                        var9_10 = 47;
                        break;
                    }
                    case -1053315462: {
                        if (!var8_8.equals("evoker_fangs")) break;
                        var9_10 = 48;
                        break;
                    }
                    case -563351243: {
                        if (!var8_8.equals("fireball")) break;
                        var9_10 = 49;
                        break;
                    }
                    case 101583: {
                        if (!var8_8.equals("fox")) break;
                        var9_10 = 50;
                        break;
                    }
                    case 632937030: {
                        if (!var8_8.equals("fox_baby")) break;
                        var9_10 = 51;
                        break;
                    }
                    case 2105566694: {
                        if (!var8_8.equals("baby_fox")) break;
                        var9_10 = 52;
                        break;
                    }
                    case 98317825: {
                        if (!var8_8.equals("ghast")) break;
                        var9_10 = 53;
                        break;
                    }
                    case 98347461: {
                        if (!var8_8.equals("giant")) break;
                        var9_10 = 54;
                        break;
                    }
                    case -1530021487: {
                        if (!var8_8.equals("guardian")) break;
                        var9_10 = 55;
                        break;
                    }
                    case 99466205: {
                        if (!var8_8.equals("horse")) break;
                        var9_10 = 56;
                        break;
                    }
                    case 1056367608: {
                        if (!var8_8.equals("horse_baby")) break;
                        var9_10 = 57;
                        break;
                    }
                    case 521841460: {
                        if (!var8_8.equals("baby_horse")) break;
                        var9_10 = 58;
                        break;
                    }
                    case 3214373: {
                        if (!var8_8.equals("husk")) break;
                        var9_10 = 59;
                        break;
                    }
                    case 891453616: {
                        if (!var8_8.equals("husk_baby")) break;
                        var9_10 = 60;
                        break;
                    }
                    case 848123374: {
                        if (!var8_8.equals("baby_husk")) break;
                        var9_10 = 61;
                        break;
                    }
                    case -1989193970: {
                        if (!var8_8.equals("illusioner")) break;
                        var9_10 = 62;
                        break;
                    }
                    case 3242771: {
                        if (!var8_8.equals("item")) break;
                        var9_10 = 63;
                        break;
                    }
                    case 443458610: {
                        if (!var8_8.equals("dropped_item")) break;
                        var9_10 = 64;
                        break;
                    }
                    case -1507545611: {
                        if (!var8_8.equals("iron_golem")) break;
                        var9_10 = 65;
                        break;
                    }
                    case -1010838428: {
                        if (!var8_8.equals("irongolem")) break;
                        var9_10 = 66;
                        break;
                    }
                    case -2134760902: {
                        if (!var8_8.equals("itemframe")) break;
                        var9_10 = 67;
                        break;
                    }
                    case -1964069567: {
                        if (!var8_8.equals("item_frame")) break;
                        var9_10 = 68;
                        break;
                    }
                    case 103054389: {
                        if (!var8_8.equals("llama")) break;
                        var9_10 = 69;
                        break;
                    }
                    case 767759181: {
                        if (!var8_8.equals("magma_cube")) break;
                        var9_10 = 70;
                        break;
                    }
                    case -2053307684: {
                        if (!var8_8.equals("magmacube")) break;
                        var9_10 = 71;
                        break;
                    }
                    case -144869400: {
                        if (!var8_8.equals("lavaslime")) break;
                        var9_10 = 72;
                        break;
                    }
                    case -1363067405: {
                        if (!var8_8.equals("minecart")) break;
                        var9_10 = 73;
                        break;
                    }
                    case -1804991051: {
                        if (!var8_8.equals("minecart_chest")) break;
                        var9_10 = 74;
                        break;
                    }
                    case -678047988: {
                        if (!var8_8.equals("minecart_furnace")) break;
                        var9_10 = 75;
                        break;
                    }
                    case 29787136: {
                        if (!var8_8.equals("minecart_hopper")) break;
                        var9_10 = 76;
                        break;
                    }
                    case 925737693: {
                        if (!var8_8.equals("minecart_mob_spawner")) break;
                        var9_10 = 77;
                        break;
                    }
                    case -815268626: {
                        if (!var8_8.equals("minecart_tnt")) break;
                        var9_10 = 78;
                        break;
                    }
                    case -440023555: {
                        if (!var8_8.equals("mooshroom")) break;
                        var9_10 = 79;
                        break;
                    }
                    case 1101287716: {
                        if (!var8_8.equals("mushroom_cow")) break;
                        var9_10 = 80;
                        break;
                    }
                    case -852480552: {
                        if (!var8_8.equals("mooshroom_baby")) break;
                        var9_10 = 81;
                        break;
                    }
                    case -1246940716: {
                        if (!var8_8.equals("baby_mooshroom")) break;
                        var9_10 = 82;
                        break;
                    }
                    case 1164100077: {
                        if (!var8_8.equals("baby_mushroom_cow")) break;
                        var9_10 = 83;
                        break;
                    }
                    case 3363105: {
                        if (!var8_8.equals("mule")) break;
                        var9_10 = 84;
                        break;
                    }
                    case -1022586720: {
                        if (!var8_8.equals("ocelot")) break;
                        var9_10 = 85;
                        break;
                    }
                    case 925981380: {
                        if (!var8_8.equals("painting")) break;
                        var9_10 = 86;
                        break;
                    }
                    case 106432986: {
                        if (!var8_8.equals("panda")) break;
                        var9_10 = 87;
                        break;
                    }
                    case 95341595: {
                        if (!var8_8.equals("panda_baby")) break;
                        var9_10 = 88;
                        break;
                    }
                    case 528808241: {
                        if (!var8_8.equals("baby_panda")) break;
                        var9_10 = 89;
                        break;
                    }
                    case -995411562: {
                        if (!var8_8.equals("parrot")) break;
                        var9_10 = 90;
                        break;
                    }
                    case -608397555: {
                        if (!var8_8.equals("phantom")) break;
                        var9_10 = 91;
                        break;
                    }
                    case 110990: {
                        if (!var8_8.equals("pig")) break;
                        var9_10 = 92;
                        break;
                    }
                    case -635579161: {
                        if (!var8_8.equals("pig_baby")) break;
                        var9_10 = 93;
                        break;
                    }
                    case 2105576101: {
                        if (!var8_8.equals("baby_pig")) break;
                        var9_10 = 94;
                        break;
                    }
                    case -205879817: {
                        if (!var8_8.equals("pig_zombie")) break;
                        var9_10 = 95;
                        break;
                    }
                    case -1737734860: {
                        if (!var8_8.equals("pigzombie")) break;
                        var9_10 = 96;
                        break;
                    }
                    case -269067746: {
                        if (!var8_8.equals("pig_zombie_baby")) break;
                        var9_10 = 97;
                        break;
                    }
                    case -409233151: {
                        if (!var8_8.equals("pigzombie_baby")) break;
                        var9_10 = 98;
                        break;
                    }
                    case 1193759006: {
                        if (!var8_8.equals("babypigzombie")) break;
                        var9_10 = 99;
                        break;
                    }
                    case -480451572: {
                        if (!var8_8.equals("pillager")) break;
                        var9_10 = 100;
                        break;
                    }
                    case -985752863: {
                        if (!var8_8.equals("player")) break;
                        var9_10 = 101;
                        break;
                    }
                    case 75460223: {
                        if (!var8_8.equals("player_clone")) break;
                        var9_10 = 102;
                        break;
                    }
                    case 1461410850: {
                        if (!var8_8.equals("player_doppleganger")) break;
                        var9_10 = 103;
                        break;
                    }
                    case -1245571196: {
                        if (!var8_8.equals("doppleganger")) break;
                        var9_10 = 104;
                        break;
                    }
                    case -805682155: {
                        if (!var8_8.equals("polar_bear")) break;
                        var9_10 = 105;
                        break;
                    }
                    case -441539598: {
                        if (!var8_8.equals("polarbear")) break;
                        var9_10 = 106;
                        break;
                    }
                    case 1326366400: {
                        if (!var8_8.equals("polar_bear_baby")) break;
                        var9_10 = 107;
                        break;
                    }
                    case 1063043331: {
                        if (!var8_8.equals("polarbear_baby")) break;
                        var9_10 = 108;
                        break;
                    }
                    case -1805013028: {
                        if (!var8_8.equals("babypolarbear")) break;
                        var9_10 = 109;
                        break;
                    }
                    case -50310370: {
                        if (!var8_8.equals("baby_polar_bear")) break;
                        var9_10 = 110;
                        break;
                    }
                    case -844391862: {
                        if (!var8_8.equals("pufferfish")) break;
                        var9_10 = 111;
                        break;
                    }
                    case -938645478: {
                        if (!var8_8.equals("rabbit")) break;
                        var9_10 = 112;
                        break;
                    }
                    case 985199610: {
                        if (!var8_8.equals("ravager")) break;
                        var9_10 = 113;
                        break;
                    }
                    case -909707666: {
                        if (!var8_8.equals("salmon")) break;
                        var9_10 = 114;
                        break;
                    }
                    case 109403483: {
                        if (!var8_8.equals("sheep")) break;
                        var9_10 = 115;
                        break;
                    }
                    case -1744928454: {
                        if (!var8_8.equals("sheep_baby")) break;
                        var9_10 = 116;
                        break;
                    }
                    case 531778738: {
                        if (!var8_8.equals("baby_sheep")) break;
                        var9_10 = 117;
                        break;
                    }
                    case 2072515372: {
                        if (!var8_8.equals("shulker")) break;
                        var9_10 = 118;
                        break;
                    }
                    case -607214219: {
                        if (!var8_8.equals("shulker_bullet")) break;
                        var9_10 = 119;
                        break;
                    }
                    case -1856084178: {
                        if (!var8_8.equals("shulkerbullet")) break;
                        var9_10 = 120;
                        break;
                    }
                    case 1962769125: {
                        if (!var8_8.equals("silverfish")) break;
                        var9_10 = 121;
                        break;
                    }
                    case 2027747405: {
                        if (!var8_8.equals("skeleton")) break;
                        var9_10 = 122;
                        break;
                    }
                    case 109526728: {
                        if (!var8_8.equals("slime")) break;
                        var9_10 = 123;
                        break;
                    }
                    case -2055888649: {
                        if (!var8_8.equals("snowman")) break;
                        var9_10 = 124;
                        break;
                    }
                    case -895953179: {
                        if (!var8_8.equals("spider")) break;
                        var9_10 = 125;
                        break;
                    }
                    case -24319637: {
                        if (!var8_8.equals("skeleton_horse")) break;
                        var9_10 = 126;
                        break;
                    }
                    case -428867913: {
                        if (!var8_8.equals("skeletal_horse")) break;
                        var9_10 = 127;
                        break;
                    }
                    case 109687090: {
                        if (!var8_8.equals("squid")) break;
                        var9_10 = 128;
                        break;
                    }
                    case 109773353: {
                        if (!var8_8.equals("stray")) break;
                        var9_10 = 129;
                        break;
                    }
                    case -862422724: {
                        if (!var8_8.equals("turtle")) break;
                        var9_10 = 130;
                        break;
                    }
                    case 949398009: {
                        if (!var8_8.equals("turtle_baby")) break;
                        var9_10 = 131;
                        break;
                    }
                    case -653691707: {
                        if (!var8_8.equals("baby_turtle")) break;
                        var9_10 = 132;
                        break;
                    }
                    case 763246518: {
                        if (!var8_8.equals("thrown_xp_bottle")) break;
                        var9_10 = 133;
                        break;
                    }
                    case 1100300525: {
                        if (!var8_8.equals("xp_bottle")) break;
                        var9_10 = 134;
                        break;
                    }
                    case 68448906: {
                        if (!var8_8.equals("experience_orb")) break;
                        var9_10 = 135;
                        break;
                    }
                    case 100893: {
                        if (!var8_8.equals("exp")) break;
                        var9_10 = 136;
                        break;
                    }
                    case 3832: {
                        if (!var8_8.equals("xp")) break;
                        var9_10 = 137;
                        break;
                    }
                    case 114269415: {
                        if (!var8_8.equals("xporb")) break;
                        var9_10 = 138;
                        break;
                    }
                    case 1386475846: {
                        if (!var8_8.equals("villager")) break;
                        var9_10 = 139;
                        break;
                    }
                    case -1744394193: {
                        if (!var8_8.equals("villager_baby")) break;
                        var9_10 = 140;
                        break;
                    }
                    case 113520271: {
                        if (!var8_8.equals("baby_villager")) break;
                        var9_10 = 141;
                        break;
                    }
                    case 1203945500: {
                        if (!var8_8.equals("babyvillager")) break;
                        var9_10 = 142;
                        break;
                    }
                    case 1869210201: {
                        if (!var8_8.equals("vindicator")) break;
                        var9_10 = 143;
                        break;
                    }
                    case 116649: {
                        if (!var8_8.equals("vex")) break;
                        var9_10 = 144;
                        break;
                    }
                    case -427624989: {
                        if (!var8_8.equals("wanderingtrader")) break;
                        var9_10 = 145;
                        break;
                    }
                    case -1756313352: {
                        if (!var8_8.equals("wandering_trader")) break;
                        var9_10 = 146;
                        break;
                    }
                    case -865715314: {
                        if (!var8_8.equals("trader")) break;
                        var9_10 = 147;
                        break;
                    }
                    case -1677989299: {
                        if (!var8_8.equals("babywanderingtrader")) break;
                        var9_10 = 148;
                        break;
                    }
                    case -1050170047: {
                        if (!var8_8.equals("baby_wandering_trader")) break;
                        var9_10 = 149;
                        break;
                    }
                    case -656984297: {
                        if (!var8_8.equals("baby_trader")) break;
                        var9_10 = 150;
                        break;
                    }
                    case 113141703: {
                        if (!var8_8.equals("witch")) break;
                        var9_10 = 151;
                        break;
                    }
                    case -787569677: {
                        if (!var8_8.equals("wither")) break;
                        var9_10 = 152;
                        break;
                    }
                    case -1416758976: {
                        if (!var8_8.equals("witherskeleton")) break;
                        var9_10 = 153;
                        break;
                    }
                    case -1582217447: {
                        if (!var8_8.equals("wither_skeleton")) break;
                        var9_10 = 154;
                        break;
                    }
                    case 1926222666: {
                        if (!var8_8.equals("witherskull")) break;
                        var9_10 = 155;
                        break;
                    }
                    case -982123503: {
                        if (!var8_8.equals("wither_skull")) break;
                        var9_10 = 156;
                        break;
                    }
                    case 3655250: {
                        if (!var8_8.equals("wolf")) break;
                        var9_10 = 157;
                        break;
                    }
                    case -83223901: {
                        if (!var8_8.equals("wolf_baby")) break;
                        var9_10 = 158;
                        break;
                    }
                    case 848564251: {
                        if (!var8_8.equals("baby_wolf")) break;
                        var9_10 = 159;
                        break;
                    }
                    case 2106290216: {
                        if (!var8_8.equals("babywolf")) break;
                        var9_10 = 160;
                        break;
                    }
                    case -696355290: {
                        if (!var8_8.equals("zombie")) break;
                        var9_10 = 161;
                        break;
                    }
                    case 710684495: {
                        if (!var8_8.equals("zombie_baby")) break;
                        var9_10 = 162;
                        break;
                    }
                    case -487624273: {
                        if (!var8_8.equals("baby_zombie")) break;
                        var9_10 = 163;
                        break;
                    }
                    case 1301217916: {
                        if (!var8_8.equals("babyzombie")) break;
                        var9_10 = 164;
                        break;
                    }
                    case 562356356: {
                        if (!var8_8.equals("zombie_horse")) break;
                        var9_10 = 165;
                        break;
                    }
                    case 410035099: {
                        if (!var8_8.equals("undead_horse")) break;
                        var9_10 = 166;
                        break;
                    }
                    case 206976831: {
                        if (!var8_8.equals("zombie_villager")) break;
                        var9_10 = 167;
                        break;
                    }
                    case 1484054892: {
                        if (!var8_8.equals("zombievillager")) break;
                        var9_10 = 168;
                        break;
                    }
                    case -1500255790: {
                        if (!var8_8.equals("villagezombie")) break;
                        var9_10 = 169;
                        break;
                    }
                    case -2065812010: {
                        if (!var8_8.equals("zombie_villager_baby")) break;
                        var9_10 = 170;
                        break;
                    }
                    case -80300094: {
                        if (!var8_8.equals("babyzombievillager")) break;
                        var9_10 = 171;
                        break;
                    }
                    case 666038460: {
                        if (!var8_8.equals("babyvillagezombie")) break;
                        var9_10 = 172;
                        break;
                    }
                    case 94756405: {
                        if (!var8_8.equals("cloud")) break;
                        var9_10 = 173;
                        break;
                    }
                    case 136428695: {
                        if (!var8_8.equals("areaeffectcloud")) break;
                        var9_10 = 174;
                    }
                }
                switch (var9_10) {
                    case 0: 
                    case 1: {
                        d = new MobDisguise(DisguiseType.ARMOR_STAND);
                        has_arms = mc.getBoolean("HasArms", true);
                        small = mc.getBoolean("Small", false);
                        invisible = mc.getBoolean("Invisible", false);
                        baseplate = mc.getBoolean("HideBasePlate", false);
                        asw = (ArmorStandWatcher)d.getWatcher();
                        asw.setShowArms(has_arms);
                        asw.setSmall(small);
                        asw.setInvisible(invisible);
                        asw.setNoBasePlate(baseplate);
                        headPose = mc.getString("Pose.Head", null);
                        if (headPose == null) ** GOTO lbl738
                        try {
                            sp = headPose.split(",");
                            poseP = Double.valueOf(sp[0]);
                            poseY = Double.valueOf(sp[1]);
                            poseA = Double.valueOf(sp[2]);
                            a = new EulerAngle((double)((float)poseP), (double)((float)poseY), (double)((float)poseA));
                            asw.setHead(a);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("ArmorStand Disguise Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) ** GOTO lbl738
                            ex.printStackTrace();
                        }
lbl738:
                        // 4 sources

                        if ((bodyPose = mc.getString("Pose.Body", null)) == null) ** GOTO lbl751
                        try {
                            sp = headPose.split(",");
                            poseP = Double.valueOf(sp[0]);
                            poseY = Double.valueOf(sp[1]);
                            poseA = Double.valueOf(sp[2]);
                            a = new EulerAngle((double)((float)poseP), (double)((float)poseY), (double)((float)poseA));
                            asw.setBody(a);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) ** GOTO lbl751
                            ex.printStackTrace();
                        }
lbl751:
                        // 4 sources

                        if ((lArmPose = mc.getString("Pose.LeftArm", null)) == null) ** GOTO lbl764
                        try {
                            sp = headPose.split(",");
                            poseP = Double.valueOf(sp[0]);
                            poseY = Double.valueOf(sp[1]);
                            poseA = Double.valueOf(sp[2]);
                            a = new EulerAngle((double)((float)poseP), (double)((float)poseY), (double)((float)poseA));
                            asw.setLeftArm(a);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) ** GOTO lbl764
                            ex.printStackTrace();
                        }
lbl764:
                        // 4 sources

                        if ((rArmPose = mc.getString("Pose.RightArm", null)) == null) ** GOTO lbl777
                        try {
                            sp = headPose.split(",");
                            poseP = Double.valueOf(sp[0]);
                            poseY = Double.valueOf(sp[1]);
                            poseA = Double.valueOf(sp[2]);
                            a = new EulerAngle((double)((float)poseP), (double)((float)poseY), (double)((float)poseA));
                            asw.setRightArm(a);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) ** GOTO lbl777
                            ex.printStackTrace();
                        }
lbl777:
                        // 4 sources

                        if ((lLegPose = mc.getString("Pose.LeftLeg", null)) == null) ** GOTO lbl790
                        try {
                            sp = headPose.split(",");
                            poseP = Double.valueOf(sp[0]);
                            poseY = Double.valueOf(sp[1]);
                            poseA = Double.valueOf(sp[2]);
                            a = new EulerAngle((double)((float)poseP), (double)((float)poseY), (double)((float)poseA));
                            asw.setLeftLeg(a);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) ** GOTO lbl790
                            ex.printStackTrace();
                        }
lbl790:
                        // 4 sources

                        if ((rLegPose = mc.getString("Pose.RightLeg", null)) == null) break;
                        try {
                            sp = headPose.split(",");
                            poseP = Double.valueOf(sp[0]);
                            poseY = Double.valueOf(sp[1]);
                            poseA = Double.valueOf(sp[2]);
                            a = new EulerAngle((double)((float)poseP), (double)((float)poseY), (double)((float)poseA));
                            asw.setRightLeg(a);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) break;
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case 2: {
                        d = new MiscDisguise(DisguiseType.ARROW);
                        break;
                    }
                    case 3: {
                        d = new MobDisguise(DisguiseType.BAT, true);
                        break;
                    }
                    case 4: {
                        d = new MiscDisguise(DisguiseType.BOAT);
                        break;
                    }
                    case 5: {
                        d = new MobDisguise(DisguiseType.BLAZE, true);
                        break;
                    }
                    case 6: 
                    case 7: {
                        block_id = mc.getString("Block", data);
                        block_dv = (short)mc.getInteger("BlockData", 0);
                        d = new MiscDisguise(DisguiseType.FALLING_BLOCK);
                        fbw = (FallingBlockWatcher)d.getWatcher();
                        mi = MythicMobs.inst().getItemManager().getItem(block_id);
                        if (mi.isPresent()) {
                            i = BukkitAdapter.adapt(mi.get().generateItemStack(1));
                            fbw.setBlock(i);
                            break;
                        }
                        m = Material.getMaterial((String)block_id.toUpperCase());
                        if (m == null) break;
                        i = new ItemStack(m, 1, block_dv);
                        i.setDurability(block_dv);
                        fbw.setBlock(i);
                        break;
                    }
                    case 8: {
                        d = new MobDisguise(DisguiseType.CAT, true);
                        watcher = (CatWatcher)d.getWatcher();
                        catType = mc.getString("CatType", null);
                        if (catType == null) break;
                        watcher.setType(Cat.Type.valueOf((String)catType.toUpperCase()));
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        d = new MobDisguise(DisguiseType.CAT, true);
                        watcher = (CatWatcher)d.getWatcher();
                        watcher.setBaby();
                        catType = mc.getString("CatType", null);
                        if (catType == null) break;
                        watcher.setType(Cat.Type.valueOf((String)catType.toUpperCase()));
                        break;
                    }
                    case 12: {
                        d = new MobDisguise(DisguiseType.CAVE_SPIDER, true);
                        break;
                    }
                    case 13: {
                        d = new MobDisguise(DisguiseType.CHICKEN, true);
                        break;
                    }
                    case 14: 
                    case 15: {
                        d = new MobDisguise(DisguiseType.CHICKEN, true);
                        watcher = (AgeableWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 16: {
                        d = new MobDisguise(DisguiseType.COD, true);
                        break;
                    }
                    case 17: {
                        d = new MobDisguise(DisguiseType.COW, true);
                        break;
                    }
                    case 18: 
                    case 19: {
                        d = new MobDisguise(DisguiseType.COW, true);
                        cww = (AgeableWatcher)d.getWatcher();
                        cww.setBaby();
                        break;
                    }
                    case 20: {
                        d = new MobDisguise(DisguiseType.CREEPER, true);
                        break;
                    }
                    case 21: 
                    case 22: {
                        d = new MobDisguise(DisguiseType.CREEPER, true);
                        watcher = (CreeperWatcher)d.getWatcher();
                        watcher.setPowered(true);
                        break;
                    }
                    case 23: {
                        d = new MobDisguise(DisguiseType.DOLPHIN, true);
                        break;
                    }
                    case 24: 
                    case 25: {
                        d = new MobDisguise(DisguiseType.DOLPHIN, true);
                        break;
                    }
                    case 26: {
                        d = new MobDisguise(DisguiseType.DONKEY, true);
                        hw = (DonkeyWatcher)d.getWatcher();
                        horseSaddled = mc.getBoolean("Saddled", false);
                        horseChest = mc.getBoolean("HasChest", false);
                        if (horseSaddled) {
                            hw.setSaddled(true);
                        }
                        if (!horseChest) break;
                        hw.setCarryingChest(true);
                        break;
                    }
                    case 27: 
                    case 28: {
                        d = new MobDisguise(DisguiseType.DRAGON_FIREBALL, true);
                        break;
                    }
                    case 29: {
                        d = new MobDisguise(DisguiseType.DROWNED, true);
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: {
                        d = new MobDisguise(DisguiseType.DROWNED, true);
                        zwb = (ZombieWatcher)d.getWatcher();
                        zwb.setBaby();
                        break;
                    }
                    case 33: {
                        d = new MiscDisguise(DisguiseType.EGG);
                        break;
                    }
                    case 34: 
                    case 35: {
                        d = new MobDisguise(DisguiseType.ENDERMAN, true);
                        if (data == null) break;
                        enw = (EndermanWatcher)d.getWatcher();
                        itemstack = new ItemStack(Material.valueOf((String)data.toUpperCase()));
                        enw.setItemInHand(itemstack);
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        d = new MiscDisguise(DisguiseType.ENDER_CRYSTAL);
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: {
                        d = new MobDisguise(DisguiseType.ENDER_DRAGON, true);
                        break;
                    }
                    case 44: {
                        d = new MobDisguise(DisguiseType.ENDERMITE, true);
                        break;
                    }
                    case 45: {
                        d = new MobDisguise(DisguiseType.ELDER_GUARDIAN, true);
                        break;
                    }
                    case 46: {
                        d = new MobDisguise(DisguiseType.EVOKER, true);
                        break;
                    }
                    case 47: 
                    case 48: {
                        d = new MobDisguise(DisguiseType.EVOKER_FANGS, true);
                        break;
                    }
                    case 49: {
                        d = new MiscDisguise(DisguiseType.FIREBALL);
                        break;
                    }
                    case 50: {
                        d = new MobDisguise(DisguiseType.FOX, true);
                        break;
                    }
                    case 51: 
                    case 52: {
                        d = new MobDisguise(DisguiseType.DOLPHIN, true);
                        watcher = (FoxWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 53: {
                        d = new MobDisguise(DisguiseType.GHAST, true);
                        break;
                    }
                    case 54: {
                        d = new MobDisguise(DisguiseType.GIANT, true);
                        break;
                    }
                    case 55: {
                        d = new MobDisguise(DisguiseType.GUARDIAN, true);
                        break;
                    }
                    case 56: {
                        d = new MobDisguise(DisguiseType.HORSE, true);
                        hw = (HorseWatcher)d.getWatcher();
                        horseArmor = mc.getString("Armor", null);
                        horseColor = mc.getString("Color", null);
                        horseSaddled = mc.getBoolean("Saddled", false);
                        horseStyle = mc.getString("Style", null);
                        horseChest = mc.getBoolean("HasChest", false);
                        if (horseStyle != null) {
                            hw.setStyle(Horse.Style.valueOf((String)horseStyle));
                        }
                        if (horseColor != null) {
                            hw.setColor(Horse.Color.valueOf((String)horseColor));
                        }
                        if (horseArmor != null) {
                            bodyPose = horseArmor;
                            lArmPose = -1;
                            switch (bodyPose.hashCode()) {
                                case 1655054676: {
                                    if (!bodyPose.equals("diamond")) break;
                                    lArmPose = 0;
                                    break;
                                }
                                case 3178592: {
                                    if (!bodyPose.equals("gold")) break;
                                    lArmPose = 1;
                                    break;
                                }
                                case -1240337143: {
                                    if (!bodyPose.equals("golden")) break;
                                    lArmPose = 2;
                                }
                            }
                            switch (lArmPose) {
                                case 0: {
                                    hw.setArmor(new ItemStack[]{new ItemStack(VolatileMaterial.DIAMOND_HORSE_ARMOR, 1)});
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    hw.setArmor(new ItemStack[]{new ItemStack(VolatileMaterial.GOLDEN_HORSE_ARMOR, 1)});
                                    break;
                                }
                                default: {
                                    hw.setArmor(new ItemStack[]{new ItemStack(VolatileMaterial.IRON_HORSE_ARMOR, 1)});
                                }
                            }
                        }
                        if (!horseSaddled) break;
                        hw.setSaddled(true);
                        break;
                    }
                    case 57: 
                    case 58: {
                        d = new MobDisguise(DisguiseType.HORSE, true);
                        hw = (HorseWatcher)d.getWatcher();
                        hw.setBaby();
                        horseArmor = mc.getString("Armor", null);
                        horseColor = mc.getString("Color", null);
                        horseSaddled = mc.getBoolean("Saddled", false);
                        horseStyle = mc.getString("Style", null);
                        horseChest = mc.getBoolean("HasChest", false);
                        if (horseStyle != null) {
                            hw.setStyle(Horse.Style.valueOf((String)horseStyle));
                        }
                        if (horseColor != null) {
                            hw.setColor(Horse.Color.valueOf((String)horseColor));
                        }
                        if (horseArmor != null) {
                            bodyPose = horseArmor;
                            lArmPose = -1;
                            switch (bodyPose.hashCode()) {
                                case 1655054676: {
                                    if (!bodyPose.equals("diamond")) break;
                                    lArmPose = 0;
                                    break;
                                }
                                case 3178592: {
                                    if (!bodyPose.equals("gold")) break;
                                    lArmPose = 1;
                                    break;
                                }
                                case -1240337143: {
                                    if (!bodyPose.equals("golden")) break;
                                    lArmPose = 2;
                                }
                            }
                            switch (lArmPose) {
                                case 0: {
                                    hw.setArmor(new ItemStack[]{new ItemStack(VolatileMaterial.DIAMOND_HORSE_ARMOR, 1)});
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    hw.setArmor(new ItemStack[]{new ItemStack(VolatileMaterial.GOLDEN_HORSE_ARMOR, 1)});
                                    break;
                                }
                                default: {
                                    hw.setArmor(new ItemStack[]{new ItemStack(VolatileMaterial.IRON_HORSE_ARMOR, 1)});
                                }
                            }
                        }
                        if (!horseSaddled) break;
                        hw.setSaddled(true);
                        break;
                    }
                    case 59: {
                        d = new MobDisguise(DisguiseType.HUSK, true);
                        break;
                    }
                    case 60: 
                    case 61: {
                        d = new MobDisguise(DisguiseType.HUSK, true);
                        watcher = (ZombieWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 62: {
                        d = new MobDisguise(DisguiseType.ILLUSIONER, true);
                        break;
                    }
                    case 63: 
                    case 64: {
                        d = new MiscDisguise(DisguiseType.DROPPED_ITEM);
                        item_id = mc.getString("Item", data);
                        item_dv = (short)mc.getInteger("ItemData", 0);
                        diw = (DroppedItemWatcher)d.getWatcher();
                        mi = MythicMobs.inst().getItemManager().getItem(item_id);
                        if (mi.isPresent()) {
                            i = BukkitAdapter.adapt(mi.get().generateItemStack(1));
                            diw.setItemStack(i);
                            break;
                        }
                        ditemstack = new ItemStack(Material.valueOf((String)item_id.toUpperCase()), 1, item_dv);
                        diw.setItemStack(ditemstack);
                        break;
                    }
                    case 65: 
                    case 66: {
                        d = new MobDisguise(DisguiseType.IRON_GOLEM, true);
                        break;
                    }
                    case 67: 
                    case 68: {
                        d = new MiscDisguise(DisguiseType.ITEM_FRAME);
                        break;
                    }
                    case 69: {
                        d = new MobDisguise(DisguiseType.LLAMA, true);
                        watcher = (LlamaWatcher)d.getWatcher();
                        hasSaddle = mc.getBoolean("HasSaddle", false);
                        carryingChest = mc.getBoolean("CarryingChest", false);
                        isGrazing = mc.getBoolean("Grazing", false);
                        if (hasSaddle) {
                            watcher.setSaddled(true);
                        }
                        if (carryingChest) {
                            watcher.setCarryingChest(true);
                        }
                        if (!isGrazing) break;
                        watcher.setGrazing(true);
                        break;
                    }
                    case 70: 
                    case 71: 
                    case 72: {
                        d = new MobDisguise(DisguiseType.MAGMA_CUBE, true);
                        mcw = (SlimeWatcher)d.getWatcher();
                        slimesize = 2;
                        if (data != null && data.matches("[0-9]+")) {
                            slimesize = Integer.parseInt(data);
                        }
                        slimesize = mc.getInteger("Size", slimesize);
                        mcw.setSize(slimesize);
                        break;
                    }
                    case 73: {
                        d = new MiscDisguise(DisguiseType.MINECART);
                        break;
                    }
                    case 74: {
                        d = new MiscDisguise(DisguiseType.MINECART_CHEST);
                        break;
                    }
                    case 75: {
                        d = new MiscDisguise(DisguiseType.MINECART_FURNACE);
                        break;
                    }
                    case 76: {
                        d = new MiscDisguise(DisguiseType.MINECART_HOPPER);
                        break;
                    }
                    case 77: {
                        d = new MiscDisguise(DisguiseType.MINECART_MOB_SPAWNER);
                        break;
                    }
                    case 78: {
                        d = new MiscDisguise(DisguiseType.MINECART_TNT);
                        break;
                    }
                    case 79: 
                    case 80: {
                        d = new MobDisguise(DisguiseType.MUSHROOM_COW, true);
                        break;
                    }
                    case 81: 
                    case 82: 
                    case 83: {
                        d = new MobDisguise(DisguiseType.MUSHROOM_COW, true);
                        watcher = (AgeableWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 84: {
                        d = new MobDisguise(DisguiseType.MULE, true);
                        hw = (MuleWatcher)d.getWatcher();
                        horseSaddled = mc.getBoolean("Saddled", false);
                        horseChest = mc.getBoolean("HasChest", false);
                        if (horseSaddled) {
                            hw.setSaddled(true);
                        }
                        if (!horseChest) break;
                        hw.setCarryingChest(true);
                        break;
                    }
                    case 85: {
                        d = new MobDisguise(DisguiseType.OCELOT, true);
                        break;
                    }
                    case 86: {
                        if (data == null || !data.matches("[0-9]*")) break;
                        d = new MiscDisguise(DisguiseType.PAINTING, Integer.parseInt(data));
                        break;
                    }
                    case 87: {
                        d = new MobDisguise(DisguiseType.PANDA, true);
                        watcher = (PandaWatcher)d.getWatcher();
                        watcher.setMainGene(Panda.Gene.NORMAL);
                        watcher.setHiddenGene(Panda.Gene.NORMAL);
                        break;
                    }
                    case 88: 
                    case 89: {
                        d = new MobDisguise(DisguiseType.PANDA, true);
                        watcher = (PandaWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 90: {
                        d = new MobDisguise(DisguiseType.PARROT, true);
                        vw = (ParrotWatcher)d.getWatcher();
                        variant = mc.getString("Color", null);
                        variant = mc.getString("Variant", variant);
                        if (variant == null) break;
                        vw.setVariant(Parrot.Variant.valueOf((String)variant));
                        break;
                    }
                    case 91: {
                        d = new MobDisguise(DisguiseType.PHANTOM, true);
                        watcher = (PhantomWatcher)d.getWatcher();
                        size = mc.getInteger("Size", 0);
                        watcher.setSize(size);
                        break;
                    }
                    case 92: {
                        d = new MobDisguise(DisguiseType.PIG, true);
                        break;
                    }
                    case 93: 
                    case 94: {
                        d = new MobDisguise(DisguiseType.PIG, true);
                        watcher = (AgeableWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 95: 
                    case 96: {
                        d = new MobDisguise(DisguiseType.PIG_ZOMBIE, true);
                        break;
                    }
                    case 97: 
                    case 98: 
                    case 99: {
                        d = new MobDisguise(DisguiseType.PIG_ZOMBIE, true);
                        w = (ZombieWatcher)d.getWatcher();
                        w.setBaby();
                        break;
                    }
                    case 100: {
                        d = new MobDisguise(DisguiseType.PILLAGER, true);
                        break;
                    }
                    case 101: {
                        player = mc.getString("Player", data == null ? displayName : data);
                        skin = mc.getString("Skin", null);
                        if (player != null) {
                            player = ChatColor.translateAlternateColorCodes((char)'&', (String)player);
                            d = new PlayerDisguise(player);
                            pw = (PlayerWatcher)d.getWatcher();
                            if (split.length > 2) {
                                ((PlayerDisguise)d).setSkin(split[2]);
                                break;
                            }
                            if (skin == null) break;
                            ((PlayerDisguise)d).setSkin(skin);
                            break;
                        }
                        if (skin != null) {
                            if (MythicMobs.inst().getHologramManager().isActive()) {
                                d = new PlayerDisguise(" ");
                                pw = (PlayerWatcher)d.getWatcher();
                                pw.setSkin(skin);
                                break;
                            }
                            if (this.isCompatible(LDVersion.v9_9_3)) {
                                d = new PlayerDisguise(displayName == null ? "" : displayName);
                                ((PlayerDisguise)d).setSkin(skin);
                                break;
                            }
                            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Disguise missing 'Name' and Hologram support isn't enabled!", new Object[0]);
                            break;
                        }
                        MythicLogger.errorCompatibility("LibsDisguises", "'Name' and 'Skin' not defined on player disguise!");
                        break;
                    }
                    case 102: 
                    case 103: 
                    case 104: {
                        skin2 = player2 = data;
                        if (split.length > 2) {
                            skin2 = split[2];
                        }
                        if (player2 == null) break;
                        player2 = ChatColor.translateAlternateColorCodes((char)'&', (String)player2);
                        d = new PlayerDisguise(player2);
                        pw2 = (PlayerWatcher)d.getWatcher();
                        if (split.length > 2) {
                            pw2.setSkin(split[2]);
                            break;
                        }
                        pw2.setSkin(skin2);
                        break;
                    }
                    case 105: 
                    case 106: {
                        d = new MobDisguise(DisguiseType.POLAR_BEAR, true);
                        break;
                    }
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: {
                        d = new MobDisguise(DisguiseType.POLAR_BEAR, true);
                        watcher = (PolarBearWatcher)d.getWatcher();
                        watcher.setBaby(true);
                        break;
                    }
                    case 111: {
                        d = new MobDisguise(DisguiseType.PUFFERFISH, true);
                        break;
                    }
                    case 112: {
                        d = new MobDisguise(DisguiseType.RABBIT, true);
                        break;
                    }
                    case 113: {
                        d = new MobDisguise(DisguiseType.RAVAGER, true);
                        break;
                    }
                    case 114: {
                        d = new MobDisguise(DisguiseType.SALMON, true);
                        break;
                    }
                    case 115: {
                        d = new MobDisguise(DisguiseType.SHEEP);
                        shw = (SheepWatcher)d.getWatcher();
                        color = mc.getString("Color", null);
                        if (color == null) break;
                        shw.setColor(AnimalColor.valueOf((String)color));
                        break;
                    }
                    case 116: 
                    case 117: {
                        d = new MobDisguise(DisguiseType.SHEEP);
                        shw = (SheepWatcher)d.getWatcher();
                        shw.setBaby();
                        color = mc.getString("Color", null);
                        if (color == null) break;
                        shw.setColor(AnimalColor.valueOf((String)color));
                        break;
                    }
                    case 118: {
                        d = new MobDisguise(DisguiseType.SHULKER, true);
                        break;
                    }
                    case 119: 
                    case 120: {
                        d = new MobDisguise(DisguiseType.SHULKER_BULLET, true);
                        break;
                    }
                    case 121: {
                        d = new MobDisguise(DisguiseType.SILVERFISH, true);
                        break;
                    }
                    case 122: {
                        d = new MobDisguise(DisguiseType.SKELETON);
                        break;
                    }
                    case 123: {
                        d = new MobDisguise(DisguiseType.SLIME, true);
                        slw = (SlimeWatcher)d.getWatcher();
                        slimessize = 2;
                        if (data != null && data.matches("[0-9]+")) {
                            slimessize = Integer.parseInt(data);
                        }
                        slimessize = mc.getInteger("Size", slimessize);
                        slw.setSize(slimessize);
                        break;
                    }
                    case 124: {
                        d = new MobDisguise(DisguiseType.SNOWMAN, true);
                        break;
                    }
                    case 125: {
                        d = new MobDisguise(DisguiseType.SPIDER, true);
                        break;
                    }
                    case 126: 
                    case 127: {
                        d = new MobDisguise(DisguiseType.SKELETON_HORSE, true);
                        hw = (SkeletonHorseWatcher)d.getWatcher();
                        horseSaddled = mc.getBoolean("Saddled", false);
                        horseChest = mc.getBoolean("HasChest", false);
                        if (!horseSaddled) break;
                        hw.setSaddled(true);
                        break;
                    }
                    case 128: {
                        d = new MobDisguise(DisguiseType.SQUID, true);
                        break;
                    }
                    case 129: {
                        d = new MobDisguise(DisguiseType.STRAY, true);
                        break;
                    }
                    case 130: {
                        d = new MobDisguise(DisguiseType.TURTLE, true);
                        break;
                    }
                    case 131: 
                    case 132: {
                        d = new MobDisguise(DisguiseType.TURTLE, true);
                        watcher = (TurtleWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 133: 
                    case 134: {
                        d = new MiscDisguise(DisguiseType.THROWN_EXP_BOTTLE);
                        break;
                    }
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: {
                        d = new MiscDisguise(DisguiseType.EXPERIENCE_ORB);
                        break;
                    }
                    case 139: {
                        d = new MobDisguise(DisguiseType.VILLAGER, true);
                        vw = (VillagerWatcher)d.getWatcher();
                        villagerType = mc.getString("Profession", null);
                        if (villagerType == null) break;
                        vw.setProfession(Villager.Profession.valueOf((String)villagerType));
                        break;
                    }
                    case 140: 
                    case 141: 
                    case 142: {
                        d = new MobDisguise(DisguiseType.VILLAGER, true);
                        vw = (VillagerWatcher)d.getWatcher();
                        vw.setBaby();
                        villagerType = mc.getString("Profession", null);
                        if (villagerType == null) break;
                        vw.setProfession(Villager.Profession.valueOf((String)villagerType));
                        break;
                    }
                    case 143: {
                        d = new MobDisguise(DisguiseType.VINDICATOR, true);
                        break;
                    }
                    case 144: {
                        d = new MobDisguise(DisguiseType.VEX, true);
                        break;
                    }
                    case 145: 
                    case 146: 
                    case 147: {
                        d = new MobDisguise(DisguiseType.WANDERING_TRADER, true);
                        break;
                    }
                    case 148: 
                    case 149: 
                    case 150: {
                        d = new MobDisguise(DisguiseType.WANDERING_TRADER, true);
                        watcher = (WanderingTraderWatcher)d.getWatcher();
                        watcher.setBaby();
                        break;
                    }
                    case 151: {
                        d = new MobDisguise(DisguiseType.WITCH, true);
                        break;
                    }
                    case 152: {
                        d = new MobDisguise(DisguiseType.WITHER, true);
                        break;
                    }
                    case 153: 
                    case 154: {
                        d = new MobDisguise(DisguiseType.WITHER_SKELETON);
                        break;
                    }
                    case 155: 
                    case 156: {
                        d = new MiscDisguise(DisguiseType.WITHER_SKULL);
                        break;
                    }
                    case 157: {
                        d = new MobDisguise(DisguiseType.WOLF, true);
                        ww = (WolfWatcher)d.getWatcher();
                        angry = mc.getBoolean("Angry", false);
                        ww.setAngry(angry);
                        break;
                    }
                    case 158: 
                    case 159: 
                    case 160: {
                        d = new MobDisguise(DisguiseType.WOLF, true);
                        bww = (WolfWatcher)d.getWatcher();
                        angry2 = mc.getBoolean("Angry", false);
                        bww.setBaby();
                        bww.setAngry(angry2);
                        break;
                    }
                    case 161: {
                        d = new MobDisguise(DisguiseType.ZOMBIE, true);
                        break;
                    }
                    case 162: 
                    case 163: 
                    case 164: {
                        d = new MobDisguise(DisguiseType.ZOMBIE, true);
                        zwb = (ZombieWatcher)d.getWatcher();
                        zwb.setBaby();
                        break;
                    }
                    case 165: 
                    case 166: {
                        d = new MobDisguise(DisguiseType.ZOMBIE_HORSE, true);
                        hw = (ZombieHorseWatcher)d.getWatcher();
                        horseSaddled = mc.getBoolean("Saddled", false);
                        horseChest = mc.getBoolean("HasChest", false);
                        if (!horseSaddled) break;
                        hw.setSaddled(true);
                        break;
                    }
                    case 167: 
                    case 168: 
                    case 169: {
                        d = new MobDisguise(DisguiseType.ZOMBIE_VILLAGER, true);
                        zw = (ZombieVillagerWatcher)d.getWatcher();
                        zw.setProfession(Villager.Profession.FARMER);
                        break;
                    }
                    case 170: 
                    case 171: 
                    case 172: {
                        d = new MobDisguise(DisguiseType.ZOMBIE_VILLAGER, true);
                        zwbv = (ZombieVillagerWatcher)d.getWatcher();
                        zwbv.setProfession(Villager.Profession.FARMER);
                        zwbv.setBaby();
                        break;
                    }
                    case 173: 
                    case 174: {
                        d = new MiscDisguise(DisguiseType.AREA_EFFECT_CLOUD);
                        watcher = (AreaEffectCloudWatcher)d.getWatcher();
                        try {
                            strColor = mc.getString("Color", "255,0,0");
                            spl = strColor.split(",");
                            red = Integer.valueOf(spl[0]);
                            green = Integer.valueOf(spl[1]);
                            blue = Integer.valueOf(spl[2]);
                            colorID = Color.fromRGB((int)red, (int)green, (int)blue);
                            watcher.setColor(colorID);
                        }
                        catch (Exception strColor) {
                            // empty catch block
                        }
                        try {
                            particle = Particle.valueOf((String)mc.getString("Particle", "CLOUD"));
                            watcher.setParticle(particle, null);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        try {
                            d = DisguiseAPI.getCustomDisguise((String)dn);
                            if (d != null) break;
                            type = null;
                            try {
                                type = DisguiseType.valueOf((String)dn.toUpperCase());
                            }
                            catch (Exception var13_102) {
                                // empty catch block
                            }
                            if (type == null) break;
                            if (type.isMob()) {
                                d = new MobDisguise(type);
                                break;
                            }
                            if (type.isPlayer()) break;
                            d = new MiscDisguise(type);
                            break;
                        }
                        catch (Exception ex) {
                            MythicLogger.errorCompatibility("LibsDisguises", "Disguise '" + dn + "' not found");
                            ex.printStackTrace();
                            d = new PlayerDisguise("Error");
                            break;
                        }
                        finally {
                            if (d == null) {
                                MythicLogger.errorCompatibility("LibsDisguises", "Disguise '" + dn + "' not found");
                                d = new PlayerDisguise("Ashijin");
                            }
                        }
                    }
                }
                if (d instanceof PlayerDisguise && this.isCompatible(LDVersion.v9_9_3) && (displayName != null || data != null)) {
                    ((PlayerDisguise)d).setName(displayName == null ? data : displayName);
                }
                if (d == null) {
                    return null;
                }
                d = this.setGenericOptions(d, mc);
            }
            catch (Exception ex) {
                MythicLogger.errorCompatibility("LibsDisguises", "Disguise type '" + disguise + "' not found");
                if (ConfigManager.debugLevel <= 0) break block357;
                ex.printStackTrace();
            }
        }
        return d;
    }

    public Disguise setGenericOptions(Disguise d, GenericConfig mc) {
        String armorHead;
        String armorChest;
        String armorLegs;
        String armorFeet;
        String handOff;
        String handMain;
        FlagWatcher fw = d.getWatcher();
        if (mc.getBoolean("Burning", false)) {
            fw.setBurning(true);
        }
        if (mc.getBoolean("Invisible", false)) {
            fw.setInvisible(true);
        }
        if (mc.getBoolean("Glowing", false)) {
            fw.setGlowing(true);
        }
        if (mc.getBoolean("Gliding", false)) {
            fw.setFlyingWithElytra(true);
        }
        if (mc.getBoolean("Blocking", false)) {
            fw.setRightClicking(true);
        }
        if (mc.getBoolean("Sneaking", false)) {
            fw.setSneaking(true);
        }
        if (mc.getBoolean("Sprinting", false)) {
            fw.setSprinting(true);
        }
        if (!mc.getBoolean("ModifyBoundingBox", true)) {
            d.setModifyBoundingBox(false);
        }
        if (mc.getString("Name", null) != null) {
            fw.setCustomName(mc.getString("Name"));
        }
        if ((handMain = mc.getString("Equipment.MainHand", null)) != null) {
            fw.setItemInMainHand(MythicMobs.inst().getItemManager().getItemStack(handMain));
        }
        if ((handOff = mc.getString("Equipment.OffHand", null)) != null) {
            fw.setItemInMainHand(MythicMobs.inst().getItemManager().getItemStack(handOff));
        }
        if (!Stream.of(armorFeet = mc.getString("Equipment.Feet", null), armorLegs = mc.getString("Equipment.Legs", null), armorChest = mc.getString("Equipment.Chest", null), armorHead = mc.getString("Equipment.Head", null)).allMatch(v -> v == null)) {
            ItemStack[] armorItems = new ItemStack[]{armorFeet == null ? null : MythicMobs.inst().getItemManager().getItemStack(armorFeet), armorLegs == null ? null : MythicMobs.inst().getItemManager().getItemStack(armorLegs), armorChest == null ? null : MythicMobs.inst().getItemManager().getItemStack(armorChest), armorHead == null ? null : MythicMobs.inst().getItemManager().getItemStack(armorHead)};
            fw.setArmor(armorItems);
        }
        return d;
    }

    public void setDisguiseName(AbstractEntity target, String name) {
        Disguise disguise = DisguiseAPI.getDisguise((Entity)target.getBukkitEntity());
        if (disguise == null) {
            return;
        }
        if (disguise.isPlayerDisguise() && this.isCompatible(LDVersion.v9_9_3)) {
            if (!((PlayerDisguise)disguise).getName().equals(" ")) {
                ((PlayerDisguise)disguise).setName(name);
            }
        } else if (disguise.getWatcher().getCustomName() != null) {
            disguise.getWatcher().setCustomName(name);
        }
    }

    public void modifyDisguise(AbstractEntity target, GenericConfig mc) {
        Entity entity = BukkitAdapter.adapt(target);
        Disguise d = DisguiseAPI.getDisguise((Entity)entity);
        if (d == null) {
            return;
        }
        FlagWatcher fw = d.getWatcher();
        if (mc.getBoolean("Burning", false)) {
            fw.setBurning(true);
        } else {
            fw.setBurning(false);
        }
        if (mc.getBoolean("Invisible", false)) {
            fw.setInvisible(true);
        } else {
            fw.setInvisible(false);
        }
        if (mc.getBoolean("Glowing", false)) {
            fw.setGlowing(true);
        } else {
            fw.setGlowing(false);
        }
        if (mc.getBoolean("Gliding", false)) {
            fw.setFlyingWithElytra(true);
        } else {
            fw.setFlyingWithElytra(false);
        }
        if (mc.getBoolean("Blocking", false)) {
            fw.setRightClicking(true);
        } else {
            fw.setRightClicking(false);
        }
        if (mc.getBoolean("Sneaking", false)) {
            fw.setSneaking(true);
        } else {
            fw.setSneaking(false);
        }
        if (mc.getBoolean("Sprinting", false)) {
            fw.setSprinting(true);
        } else {
            fw.setSprinting(false);
        }
        if (!mc.getBoolean("ModifyBoundingBox", true)) {
            d.setModifyBoundingBox(false);
        } else {
            d.setModifyBoundingBox(true);
        }
        d = d.setWatcher(fw);
        DisguiseAPI.disguiseToAll((Entity)entity, (Disguise)d);
    }

    static enum LDVersion {
        v1_1_1,
        v9_9_3;

    }
}

