/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import com.sainttx.holograms.HologramPlugin;
import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.HologramManager;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.api.line.TextLine;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobDeathEvent;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HologramsSupport2
implements Listener {
    private final MythicMobs core;
    private HologramManager hologramManager;
    private ConcurrentHashMap<UUID, Nameplate> nameplates = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, HealthBar> healthBars = new ConcurrentHashMap();

    public HologramsSupport2(MythicMobs mm3) {
        this.core = mm3;
        this.hologramManager = ((HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class)).getHologramManager();
        if (this.hologramManager == null) {
            return;
        }
        this.hologramManager.getActiveHolograms().values().forEach(hologram -> {
            if (hologram.getId().startsWith("#Temp")) {
                Schedulers.sync().runLater(() -> {
                    hologram.despawn();
                    this.hologramManager.removeActiveHologram(hologram);
                }, 1L);
            }
        });
        this.core.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.core);
        this.core.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this.core, () -> {
            this.nameplates.values().removeIf(bar -> !bar.check());
            this.healthBars.values().removeIf(bar -> !bar.check());
            this.healthBars.values().stream().forEach(bar -> bar.update());
        }, 0L, 10L);
        this.core.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.core, () -> {
            this.nameplates.values().stream().forEach(bar -> bar.teleport());
            this.healthBars.values().stream().forEach(bar -> bar.teleport());
        }, 0L, 1L);
    }

    public void addNameplate(ActiveMob am) {
        if (!this.nameplates.containsKey(am.getUniqueId())) {
            this.nameplates.put(am.getUniqueId(), new Nameplate(am));
        }
    }

    public void shutdown() {
        this.healthBars.values().stream().forEach(bar -> bar.remove());
    }

    @EventHandler
    public void onDamaged(EntityDamageEvent event) {
        UUID uuid = event.getEntity().getUniqueId();
        if (this.core.getMobManager().isActiveMob(uuid)) {
            ActiveMob am = MythicMobs.inst().getMobManager().getActiveMob(uuid).get();
            if (this.healthBars.containsKey(uuid)) {
                this.healthBars.get(uuid).update();
            } else if (am.getType().getConfig().getBoolean("HealthBar.Enabled", false)) {
                this.healthBars.put(uuid, new HealthBar(am));
            }
        }
    }

    @EventHandler
    public void onMythicMobDeath(MythicMobDeathEvent event) {
        UUID uuid = event.getEntity().getUniqueId();
        if (this.nameplates.containsKey(uuid)) {
            this.nameplates.get(uuid).remove();
            this.nameplates.remove(event.getEntity().getUniqueId());
        }
        if (this.healthBars.containsKey(uuid)) {
            this.healthBars.get(uuid).remove();
            this.healthBars.remove(event.getEntity().getUniqueId());
        }
    }

    private class Nameplate {
        private final ActiveMob activemob;
        private Hologram hologram;
        private double yOffset;

        public Nameplate(ActiveMob am) {
            this.activemob = am;
            this.yOffset = am.getType().getConfig().getDouble("Disguise.NameplateOffset", 0.525f);
            this.yOffset = am.getType().getConfig().getDouble("Nameplate.Offset", this.yOffset);
            this.hologram = new Hologram("#TempNameplate" + this.activemob.getUniqueId().toString(), this.getLocation());
            this.hologram.setPersistent(false);
            this.hologram.addLine((HologramLine)new TextLine(this.hologram, this.getLine()));
            HologramsSupport2.this.hologramManager.addActiveHologram(this.hologram);
        }

        public boolean check() {
            if (this.activemob.isDead() || !this.activemob.getEntity().isValid()) {
                this.remove();
                return false;
            }
            return true;
        }

        public void teleport() {
            Location location = this.getLocation();
            if (location == null) {
                this.remove();
            } else {
                this.hologram.getLine(0).setLocation(this.getLocation());
            }
        }

        public void remove() {
            this.hologram.removeLine(this.hologram.getLine(0));
            HologramsSupport2.this.hologramManager.removeActiveHologram(this.hologram);
        }

        private Location getLocation() {
            return BukkitAdapter.adapt(this.activemob.getEntity().getEyeLocation().add(0.0, this.yOffset, 0.0));
        }

        private String getLine() {
            return SkillString.parseMobVariables(this.activemob.getDisplayName(), this.activemob, null, null);
        }
    }

    private class HealthBar {
        private final ActiveMob activemob;
        private Hologram hologram;
        private double yOffset;

        public HealthBar(ActiveMob am) {
            this.activemob = am;
            this.yOffset = am.getType().getConfig().getDouble("HealthBar.Offset", am.getType().isFakePlayer() ? (double)0.3f : am.getType().getMythicEntity().getHealthbarOffset());
            this.hologram = new Hologram("#TempHealthBar" + this.activemob.getUniqueId().toString(), this.getLocation());
            this.hologram.setPersistent(false);
            this.hologram.addLine((HologramLine)new TextLine(this.hologram, this.getLine()));
            HologramsSupport2.this.hologramManager.addActiveHologram(this.hologram);
        }

        private Location getLocation() {
            return BukkitAdapter.adapt(this.activemob.getEntity().getEyeLocation().add(0.0, this.yOffset, 0.0));
        }

        public boolean check() {
            if (this.activemob.isDead() || !this.activemob.getEntity().isValid() || this.activemob.getEntity().getHealth() == this.activemob.getEntity().getMaxHealth()) {
                this.remove();
                return false;
            }
            return true;
        }

        public void teleport() {
            this.hologram.getLine(0).setLocation(this.getLocation());
        }

        public void update() {
            ((TextLine)this.hologram.getLine(0)).setText(this.getLine());
        }

        public void remove() {
            this.hologram.removeLine(this.hologram.getLine(0));
            HologramsSupport2.this.hologramManager.removeActiveHologram(this.hologram);
        }

        private String getLine() {
            int hp = (int)this.activemob.getEntity().getHealth();
            double percent = this.activemob.getEntity().getHealth() / this.activemob.getEntity().getMaxHealth();
            String sHP = String.valueOf(hp);
            int hplength = sHP.length();
            int length = 10 + hplength;
            int gray = (int)Math.floor(percent * (double)length);
            StringBuilder line = new StringBuilder().append(ChatColor.DARK_RED).append("[");
            boolean passed = false;
            for (int i = 0; i < length; ++i) {
                if (!passed && i > gray) {
                    passed = true;
                }
                if (i < 5) {
                    line.append(passed ? ChatColor.DARK_GRAY : ChatColor.RED);
                    line.append("|");
                    continue;
                }
                if (i < 5 + hplength) {
                    line.append(passed ? ChatColor.GRAY : ChatColor.DARK_RED);
                    try {
                        line.append(sHP.substring(i - 5, i - 4));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (i == hplength + 2 && !passed) {
                    line.append(ChatColor.RED);
                }
                line.append(passed ? ChatColor.DARK_GRAY : ChatColor.RED);
                line.append("|");
            }
            return line.append(ChatColor.DARK_RED).append("]").toString();
        }
    }
}

