/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.spawners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.command.CommandSender;

public class RemoveCommand
extends Command<MythicMobs> {
    public RemoveCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a mob spawner to remove!");
            return true;
        }
        String name = args[0];
        MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
        if (ms == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The spawner entered does not exist!");
            return true;
        }
        if (MythicMobs.inst().getSpawnerManager().removeSpawner(ms)) {
            BukkitAdapter.adapt(ms.getLocation()).getWorld().playEffect(BukkitAdapter.adapt(ms.getLocation()), Effect.SMOKE, 0);
            BukkitAdapter.adapt(ms.getLocation()).getWorld().playEffect(BukkitAdapter.adapt(ms.getLocation()), Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner was removed successfully!");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.remove";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"re", "delete", "r"};
    }
}

