/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.items;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.commands.CommandHelper;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ImportCommand
extends Command<MythicMobs> {
    public ImportCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        File file;
        Player player;
        ItemStack item;
        if (args.length < 1) {
            CommandHelper.sendError(sender, "You must specify a name for this item.");
            return true;
        }
        String name = args[0];
        String fileName = name + ".yml";
        if (args.length > 1) {
            fileName = args[1];
        }
        if ((item = (player = (Player)sender).getInventory().getItemInHand()) == null || item.getType() == Material.AIR) {
            CommandHelper.sendError(sender, "You must be holding an item to import.");
            return true;
        }
        String path = ((MythicMobs)this.plugin).getDataFolder() + System.getProperty("file.separator") + "Items" + System.getProperty("file.separator") + fileName;
        if (!path.endsWith(".yml")) {
            path = path + ".yml";
        }
        if (!(file = new File(path)).exists()) {
            try {
                if (!file.createNewFile()) {
                    CommandHelper.sendError(sender, "Failed to create new file for Item Import.");
                    return true;
                }
            }
            catch (IOException e) {
                CommandHelper.sendError(sender, "Failed to create new file for Item Import.");
                e.printStackTrace();
            }
        }
        MythicConfig mc = new MythicConfig(name, file);
        mc.load();
        mc.set("ItemStack", item);
        mc.save();
        MythicItem mi = new MythicItem(file.getName(), name, mc);
        ((MythicMobs)this.getPlugin()).getItemManager().registerItem(name, mi);
        CommandHelper.sendSuccess(sender, "Item '" + name + "' imported successfully to file " + path);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.import";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "import";
    }
}

