/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.items;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.commands.CommandHelper;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.drops.LootBag;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class GetCommand
extends Command<MythicMobs> {
    public GetCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        if (args.length < 1) {
            CommandHelper.sendError(sender, "Command Syntax: /mm item get <name>");
            return true;
        }
        String item = args[0];
        int amount = 1;
        if (args.length > 1) {
            amount = Integer.valueOf(args[1]);
        }
        AbstractPlayer target = BukkitAdapter.adapt(p);
        DropMetadata meta = new DropMetadata(new GenericCaster(target), target);
        Optional<DropTable> maybeDrops = MythicMobs.inst().getDropManager().getDropTable(item);
        if (maybeDrops.isPresent()) {
            DropTable dt = maybeDrops.get();
            if (dt.hasDrops()) {
                for (int i = 0; i < amount; ++i) {
                    LootBag loot = dt.generate(meta);
                    loot.give(target);
                }
            }
            CommandHelper.sendSuccess(sender, "DropTable &b" + item + " &awas put in your inventory!");
            return true;
        }
        Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(item);
        if (maybeItem.isPresent()) {
            MythicItem mi = maybeItem.get();
            for (int i = 0; i < amount; ++i) {
                try {
                    p.getInventory().addItem(new ItemStack[]{BukkitAdapter.adapt(mi.generateItemStack(meta, 1))});
                    continue;
                }
                catch (Exception ex) {
                    CommandHelper.sendError(sender, "Could not get item: item is improperly configured and returned null.");
                    if (ConfigManager.debugLevel > 0) {
                        ex.printStackTrace();
                    }
                    return true;
                }
            }
            CommandHelper.sendSuccess(sender, "Item &b" + item + " &awas put in your inventory!");
        } else {
            CommandHelper.sendError(sender, "No Mythic Item loaded with the name " + item + ".");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicMobs)this.getPlugin()).getItemManager().getItemNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.get";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "get";
    }
}

