/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties;

import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.EntityPropertySet;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.TropicalFish;

public class ColoredProperty
implements EntityPropertySet {
    private String strColor;
    private Object color;

    public ColoredProperty(MythicConfig mc) {
        this.strColor = mc.getString("Options.Color", "WHITE");
    }

    public ColoredProperty(MythicLineConfig mc) {
        this.strColor = mc.getString("color", "WHITE");
    }

    public ColoredProperty(String color) {
        this.strColor = color;
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if (entity instanceof Horse) {
            if (this.color == null) {
                try {
                    this.color = Horse.Color.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = Horse.Color.WHITE;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for Horse");
                }
            }
            Horse.Color color = (Horse.Color)this.color;
            Horse target = (Horse)entity;
            target.setColor(color);
        } else if (entity instanceof Llama) {
            if (this.color == null) {
                try {
                    this.color = Llama.Color.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = Llama.Color.WHITE;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for Llama");
                }
            }
            Llama.Color color = (Llama.Color)this.color;
            Llama target = (Llama)entity;
            target.setColor(color);
        } else if (entity instanceof TraderLlama) {
            if (this.color == null) {
                try {
                    this.color = Llama.Color.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = Llama.Color.WHITE;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for TraderLlama");
                }
            }
            Llama.Color color = (Llama.Color)this.color;
            TraderLlama target = (TraderLlama)entity;
            target.setColor(color);
        } else if (entity instanceof Parrot) {
            if (this.color == null) {
                try {
                    this.color = Parrot.Variant.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = Parrot.Variant.BLUE;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for Parrot");
                }
            }
            Parrot.Variant color = (Parrot.Variant)this.color;
            Parrot target = (Parrot)entity;
            target.setVariant(color);
        } else if (entity instanceof Sheep) {
            if (this.color == null) {
                try {
                    this.color = DyeColor.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = DyeColor.WHITE;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for Sheep");
                }
            }
            DyeColor color = (DyeColor)this.color;
            Sheep target = (Sheep)entity;
            target.setColor(color);
        } else if (entity instanceof Shulker) {
            if (this.color == null) {
                try {
                    this.color = DyeColor.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = DyeColor.WHITE;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for Shulker");
                }
            }
            DyeColor color = (DyeColor)this.color;
            Shulker target = (Shulker)entity;
            target.setColor(color);
        } else if (entity instanceof TropicalFish) {
            if (this.color == null) {
                try {
                    this.color = TropicalFish.Pattern.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = TropicalFish.Pattern.GLITTER;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for TropicalFish");
                }
            }
            TropicalFish.Pattern color = (TropicalFish.Pattern)this.color;
            TropicalFish target = (TropicalFish)entity;
            target.setPattern(color);
        } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && entity instanceof Cat) {
            if (this.color == null) {
                try {
                    this.color = Cat.Type.valueOf((String)this.strColor.toUpperCase());
                }
                catch (Error | Exception ex) {
                    this.color = Cat.Type.WHITE;
                    MythicLogger.error("Invalid color '" + this.strColor + "' configured for Horse");
                }
            }
            Cat.Type color = (Cat.Type)this.color;
            Cat target = (Cat)entity;
            target.setCatType(color);
        }
        return entity;
    }
}

